/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.flow.impl;

import com.google.common.collect.ArrayListMultimap;
import java.util.Iterator;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.cfg.ComponentConfigAdapter;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.CoreServiceAdapter;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleBatchEntry;
import org.onosproject.net.flow.FlowRuleBatchOperation;
import org.onosproject.net.flow.FlowRuleOperation;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.IntentTestsMocks;
import org.onosproject.store.cluster.messaging.ClusterCommunicationServiceAdapter;
import org.onosproject.store.flow.impl.DistributedFlowRuleStore;
import org.onosproject.store.flow.impl.ReplicaInfoManager;
import org.onosproject.store.persistence.PersistenceServiceAdapter;
import org.onosproject.store.service.TestStorageService;
import org.osgi.service.component.ComponentContext;

public class DistributedFlowRuleStoreTest {
    DistributedFlowRuleStore flowStoreImpl;
    ComponentContext context = null;
    private ClusterService mockClusterService;
    private ControllerNode mockControllerNode;
    private NodeId nodeId;
    private static final IntentTestsMocks.MockSelector SELECTOR = new IntentTestsMocks.MockSelector();
    private static final IntentTestsMocks.MockTreatment TREATMENT = new IntentTestsMocks.MockTreatment();
    DeviceId deviceId = NetTestTools.did((String)"device1");
    FlowRule flowRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector((TrafficSelector)SELECTOR).withTreatment((TrafficTreatment)TREATMENT).withPriority(22).makeTemporary(44).fromApp(NetTestTools.APP_ID).build();
    FlowRule flowRule1 = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector((TrafficSelector)SELECTOR).withTreatment((TrafficTreatment)TREATMENT).withPriority(33).makeTemporary(44).fromApp(NetTestTools.APP_ID).build();

    @Before
    public void setUp() throws Exception {
        this.flowStoreImpl = new DistributedFlowRuleStore();
        this.flowStoreImpl.storageService = new TestStorageService();
        this.flowStoreImpl.replicaInfoManager = new ReplicaInfoManager();
        this.flowStoreImpl.clusterService = this.mockClusterService = (ClusterService)EasyMock.createMock(ClusterService.class);
        this.nodeId = new NodeId("1");
        this.mockControllerNode = new MockControllerNode(this.nodeId);
        EasyMock.expect((Object)this.mockClusterService.getLocalNode()).andReturn((Object)this.mockControllerNode).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockClusterService});
        this.flowStoreImpl.clusterCommunicator = new ClusterCommunicationServiceAdapter();
        this.flowStoreImpl.mastershipService = new MasterOfAll();
        this.flowStoreImpl.deviceService = new DeviceServiceAdapter();
        this.flowStoreImpl.coreService = new CoreServiceAdapter();
        this.flowStoreImpl.configService = new ComponentConfigAdapter();
        this.flowStoreImpl.persistenceService = new PersistenceServiceAdapter();
        this.flowStoreImpl.activate(this.context);
    }

    @After
    public void tearDown() throws Exception {
        this.flowStoreImpl.deactivate(this.context);
    }

    @Test
    public void testEmptyStore() {
        MatcherAssert.assertThat((Object)this.flowStoreImpl.getFlowRuleCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.flowStoreImpl.getFlowEntries(this.deviceId), (Matcher)Matchers.is((Matcher)Matchers.emptyIterable()));
    }

    @Test
    public void testStoreBatch() {
        FlowRuleOperation op = new FlowRuleOperation(this.flowRule, FlowRuleOperation.Type.ADD);
        ArrayListMultimap perDeviceBatches = ArrayListMultimap.create();
        perDeviceBatches.put((Object)op.rule().deviceId(), (Object)new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.ADD, op.rule()));
        FlowRuleBatchOperation b = new FlowRuleBatchOperation(perDeviceBatches.get((Object)this.deviceId), this.deviceId, 1L);
        this.flowStoreImpl.storeBatch(b);
        FlowEntry flowEntry1 = this.flowStoreImpl.getFlowEntry(this.flowRule);
        Assert.assertEquals((Object)"PENDING_ADD", (Object)flowEntry1.state().toString());
    }

    @Test
    public void testAddFlow() {
        DefaultFlowEntry flowEntry = new DefaultFlowEntry(this.flowRule);
        FlowRuleOperation op = new FlowRuleOperation(this.flowRule, FlowRuleOperation.Type.ADD);
        ArrayListMultimap perDeviceBatches = ArrayListMultimap.create();
        perDeviceBatches.put((Object)op.rule().deviceId(), (Object)new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.ADD, op.rule()));
        FlowRuleBatchOperation b = new FlowRuleBatchOperation(perDeviceBatches.get((Object)this.deviceId), this.deviceId, 1L);
        this.flowStoreImpl.storeBatch(b);
        FlowEntry flowEntry1 = this.flowStoreImpl.getFlowEntry(this.flowRule);
        Assert.assertEquals((Object)"PENDING_ADD", (Object)flowEntry1.state().toString());
        this.flowStoreImpl.addOrUpdateFlowRule((FlowEntry)flowEntry);
        Iterable flows = this.flowStoreImpl.getFlowEntries(this.deviceId);
        int sum = 0;
        Iterator it = flows.iterator();
        while (it.hasNext()) {
            it.next();
            ++sum;
        }
        MatcherAssert.assertThat((Object)sum, (Matcher)Matchers.is((Object)1));
        FlowEntry flowEntry2 = this.flowStoreImpl.getFlowEntry(this.flowRule);
        Assert.assertEquals((Object)"ADDED", (Object)flowEntry2.state().toString());
        MatcherAssert.assertThat((Object)this.flowStoreImpl.getTableStatistics(this.deviceId), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testRemoveFlow() {
        Iterable flows1 = this.flowStoreImpl.getFlowEntries(this.deviceId);
        for (FlowEntry flow : flows1) {
            this.flowStoreImpl.removeFlowRule(flow);
        }
        Iterable flows2 = this.flowStoreImpl.getFlowEntries(this.deviceId);
        int sum = 0;
        Iterator it = flows2.iterator();
        while (it.hasNext()) {
            it.next();
            ++sum;
        }
        MatcherAssert.assertThat((Object)sum, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testPurgeFlow() {
        DefaultFlowEntry flowEntry = new DefaultFlowEntry(this.flowRule);
        this.flowStoreImpl.addOrUpdateFlowRule((FlowEntry)flowEntry);
        DefaultFlowEntry flowEntry1 = new DefaultFlowEntry(this.flowRule1);
        this.flowStoreImpl.addOrUpdateFlowRule((FlowEntry)flowEntry1);
        Iterable flows1 = this.flowStoreImpl.getFlowEntries(this.deviceId);
        int sum2 = 0;
        Iterator it1 = flows1.iterator();
        while (it1.hasNext()) {
            it1.next();
            ++sum2;
        }
        MatcherAssert.assertThat((Object)sum2, (Matcher)Matchers.is((Object)2));
        this.flowStoreImpl.purgeFlowRule(this.deviceId);
        Iterable flows3 = this.flowStoreImpl.getFlowEntries(this.deviceId);
        int sum3 = 0;
        Iterator it3 = flows3.iterator();
        while (it3.hasNext()) {
            it3.next();
            ++sum3;
        }
        MatcherAssert.assertThat((Object)sum3, (Matcher)Matchers.is((Object)0));
    }

    private static class MockControllerNode
    implements ControllerNode {
        final NodeId id;

        public MockControllerNode(NodeId id) {
            this.id = id;
        }

        public NodeId id() {
            return this.id;
        }

        public Ip4Address ip() {
            return Ip4Address.valueOf((String)"127.0.0.1");
        }

        public int tcpPort() {
            return 0;
        }
    }

    static class MasterOfAll
    extends MastershipServiceAdapter {
        MasterOfAll() {
        }

        public MastershipRole getLocalRole(DeviceId deviceId) {
            return MastershipRole.MASTER;
        }

        public NodeId getMasterFor(DeviceId deviceId) {
            return new NodeId("1");
        }
    }
}

