/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.VlanId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.DiscreteResourceCodec;
import org.onosproject.net.resource.Resources;
import org.onosproject.store.resource.impl.EncodedDiscreteResources;
import org.onosproject.store.resource.impl.VlanIdCodec;

public class EncodedDiscreteResourcesTest {
    private static final DeviceId DID = DeviceId.deviceId((String)"device1");
    private static final PortNumber PN = PortNumber.portNumber((long)1L);
    private static final VlanId VID1 = VlanId.vlanId((short)1);
    private static final VlanId VID2 = VlanId.vlanId((short)2);
    private static final VlanId VID3 = VlanId.vlanId((short)3);

    @Test
    public void testContains() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DID, (PortNumber)PN, (Object[])new Object[]{VID1}).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DID, (PortNumber)PN, (Object[])new Object[]{VID2}).resource();
        DiscreteResource res3 = Resources.discrete((DeviceId)DID, (PortNumber)PN, (Object[])new Object[]{VID3}).resource();
        ImmutableSet resources = ImmutableSet.of((Object)res1, (Object)res2);
        EncodedDiscreteResources sut = EncodedDiscreteResources.of((Set)resources, (DiscreteResourceCodec)new VlanIdCodec());
        Assert.assertThat((Object)sut.contains(res1), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)sut.contains(res3), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testDifference() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DID, (PortNumber)PN, (Object[])new Object[]{VID1}).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DID, (PortNumber)PN, (Object[])new Object[]{VID2}).resource();
        DiscreteResource res3 = Resources.discrete((DeviceId)DID, (PortNumber)PN, (Object[])new Object[]{VID3}).resource();
        EncodedDiscreteResources sut = EncodedDiscreteResources.of((Set)ImmutableSet.of((Object)res1, (Object)res2), (DiscreteResourceCodec)new VlanIdCodec());
        EncodedDiscreteResources other = EncodedDiscreteResources.of((Set)ImmutableSet.of((Object)res1, (Object)res3), (DiscreteResourceCodec)new VlanIdCodec());
        Assert.assertThat((Object)sut.difference(other), (Matcher)Matchers.is((Object)EncodedDiscreteResources.of((Set)ImmutableSet.of((Object)res2), (DiscreteResourceCodec)new VlanIdCodec())));
    }

    @Test
    public void testAdd() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DID, (PortNumber)PN, (Object[])new Object[]{VID1}).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DID, (PortNumber)PN, (Object[])new Object[]{VID2}).resource();
        DiscreteResource res3 = Resources.discrete((DeviceId)DID, (PortNumber)PN, (Object[])new Object[]{VID3}).resource();
        EncodedDiscreteResources sut = EncodedDiscreteResources.of((Set)ImmutableSet.of((Object)res1, (Object)res2), (DiscreteResourceCodec)new VlanIdCodec());
        EncodedDiscreteResources other = EncodedDiscreteResources.of((Set)ImmutableSet.of((Object)res1, (Object)res3), (DiscreteResourceCodec)new VlanIdCodec());
        Assert.assertThat((Object)sut.add(other), (Matcher)Matchers.is((Object)EncodedDiscreteResources.of((Set)ImmutableSet.of((Object)res1, (Object)res2, (Object)res3), (DiscreteResourceCodec)new VlanIdCodec())));
    }
}

