/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.VlanId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.Resources;
import org.onosproject.store.resource.impl.ConsistentResourceStore;
import org.onosproject.store.resource.impl.DiscreteResources;
import org.onosproject.store.resource.impl.EncodableDiscreteResources;
import org.onosproject.store.service.Serializer;

public class EncodableDiscreteResourcesTest {
    private final Serializer serializer = ConsistentResourceStore.SERIALIZER;

    @Test
    public void testPortSerialize() {
        DiscreteResource device = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        Set resources = IntStream.range(0, 100).mapToObj(PortNumber::portNumber).map(arg_0 -> ((DiscreteResource)device).child(arg_0)).collect(Collectors.toSet());
        DiscreteResources original = EncodableDiscreteResources.of(resources);
        byte[] bytes = this.serializer.encode((Object)original);
        DiscreteResources decoded = (DiscreteResources)this.serializer.decode(bytes);
        Assert.assertThat((Object)decoded, (Matcher)Matchers.is((Object)original));
    }

    @Test
    public void testIfResourceIsFound() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)1L), (Object[])new Object[0]).resource();
        DiscreteResources sut = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        Assert.assertThat((Object)sut.lookup(res1.id()), (Matcher)Matchers.is(Optional.of(res1)));
    }

    @Test
    public void testIfResourceIsNotFound() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)1L), (Object[])new Object[0]).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)2L), (Object[])new Object[0]).resource();
        DiscreteResources sut = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        Assert.assertThat((Object)sut.lookup(res2.id()), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void testIfDifferenceIsEmpty() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)1L), (Object[])new Object[0]).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)2L), (Object[])new Object[0]).resource();
        DiscreteResources sut = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res1, (Object)res2));
        DiscreteResources other = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res1, (Object)res2));
        DiscreteResources expected = DiscreteResources.empty();
        Assert.assertThat((Object)sut.difference(other), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testSerializeInstanceContainingEmptyEncodedDiscreteResources() {
        DiscreteResource device = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        List ports = IntStream.range(0, 1).mapToObj(PortNumber::portNumber).collect(Collectors.toList());
        List vlans = IntStream.range(0, 2).mapToObj(x -> VlanId.vlanId((short)((short)x))).collect(Collectors.toList());
        Set originalResources = Stream.concat(ports.stream(), vlans.stream()).map(arg_0 -> ((DiscreteResource)device).child(arg_0)).collect(Collectors.toSet());
        DiscreteResources sut = EncodableDiscreteResources.of(originalResources);
        Set portOnlyResources = ports.stream().map(arg_0 -> ((DiscreteResource)device).child(arg_0)).collect(Collectors.toSet());
        DiscreteResources other = EncodableDiscreteResources.of(portOnlyResources);
        DiscreteResources diff = sut.difference(other);
        byte[] bytes = this.serializer.encode((Object)diff);
        Assert.assertThat((Object)this.serializer.decode(bytes), (Matcher)Matchers.is((Object)diff));
    }

    @Test
    public void testIfDifferenceIsNotEmpty() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)1L), (Object[])new Object[0]).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)2L), (Object[])new Object[0]).resource();
        DiscreteResources sut = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res1, (Object)res2));
        DiscreteResources other = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        DiscreteResources expected = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res2));
        Assert.assertThat((Object)sut.difference(other), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testIfDifferenceIsNotChanged() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)1L), (Object[])new Object[0]).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)2L), (Object[])new Object[0]).resource();
        DiscreteResources sut = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        DiscreteResources other = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res2));
        DiscreteResources expected = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        Assert.assertThat((Object)sut.difference(other), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testDifferenceFromEmpty() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)1L), (Object[])new Object[0]).resource();
        DiscreteResources sut = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        DiscreteResources other = DiscreteResources.empty();
        DiscreteResources expected = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        Assert.assertThat((Object)sut.difference(other), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testEmpty() {
        DiscreteResources sut = EncodableDiscreteResources.of((Set)ImmutableSet.of());
        Assert.assertThat((Object)sut.isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testNotEmpty() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)1L), (Object[])new Object[0]).resource();
        DiscreteResources sut = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        Assert.assertThat((Object)sut.isEmpty(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIfResourceIsContained() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)1L), (Object[])new Object[0]).resource();
        DiscreteResources sut = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        Assert.assertThat((Object)sut.containsAny((Set)ImmutableSet.of((Object)res1)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testIfResourceIsNotContained() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)1L), (Object[])new Object[0]).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)2L), (Object[])new Object[0]).resource();
        DiscreteResources sut = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        Assert.assertThat((Object)sut.containsAny((Set)ImmutableSet.of((Object)res2)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testContainsWithEmpty() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)1L), (Object[])new Object[0]).resource();
        DiscreteResources sut = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        Assert.assertThat((Object)sut.containsAny((Set)ImmutableSet.of()), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAdd() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)1L), (Object[])new Object[0]).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)2L), (Object[])new Object[0]).resource();
        DiscreteResources sut = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        DiscreteResources other = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res2));
        DiscreteResources expected = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res1, (Object)res2));
        Assert.assertThat((Object)sut.add(other), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testValues() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)1L), (Object[])new Object[0]).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a"), (PortNumber)PortNumber.portNumber((long)2L), (Object[])new Object[0]).resource();
        DiscreteResources sut = EncodableDiscreteResources.of((Set)ImmutableSet.of((Object)res1, (Object)res2));
        Assert.assertThat((Object)sut.values(), (Matcher)Matchers.is((Object)ImmutableSet.of((Object)res1, (Object)res2)));
    }
}

