/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.messaging.impl;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import org.onlab.packet.IpAddress;
import org.onosproject.store.cluster.messaging.Endpoint;
import org.onosproject.store.cluster.messaging.impl.InternalMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MessageEncoder
extends MessageToByteEncoder<Object> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final int preamble;

    public MessageEncoder(int preamble) {
        this.preamble = preamble;
    }

    protected void encode(ChannelHandlerContext context, Object rawMessage, ByteBuf out) throws Exception {
        InternalMessage message = (InternalMessage)rawMessage;
        out.writeInt(this.preamble);
        out.writeLong(message.time().logicalTime());
        out.writeLong(message.time().logicalCounter());
        out.writeLong(message.id());
        Endpoint sender = message.sender();
        IpAddress senderIp = sender.host();
        if (senderIp.version() == IpAddress.Version.INET) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
        }
        out.writeBytes(senderIp.toOctets());
        out.writeInt(sender.port());
        byte[] messageTypeBytes = message.type().getBytes(Charsets.UTF_8);
        out.writeInt(messageTypeBytes.length);
        out.writeBytes(messageTypeBytes);
        out.writeInt(message.status().id());
        byte[] payload = message.payload();
        out.writeInt(payload.length);
        out.writeBytes(payload);
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        if (cause instanceof IOException) {
            this.log.debug("IOException inside channel handling pipeline.", cause);
        } else {
            this.log.error("non-IOException inside channel handling pipeline.", cause);
        }
        context.close();
    }

    public final boolean acceptOutboundMessage(Object msg) throws Exception {
        return msg instanceof InternalMessage;
    }
}

