/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.host.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.event.Event;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostStore;
import org.onosproject.net.host.HostStoreDelegate;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.Timestamp;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedHostStore
extends AbstractStore<HostEvent, HostStoreDelegate>
implements HostStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final boolean DEFAULT_RECORD_TIMESTAMP_ENABLED = false;
    @Property(name="recordHostTimestamp", boolValue={false}, label="Indicates whether recoding of host timestamp is enabled or not")
    private volatile boolean recordHostTimestamp = false;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private ConsistentMap<HostId, DefaultHost> hostsConsistentMap;
    private Map<HostId, DefaultHost> hosts;
    private Map<IpAddress, Set<Host>> hostsByIp;
    private MapEventListener<HostId, DefaultHost> hostLocationTracker = new HostLocationTracker();
    private EventuallyConsistentMap<HostId, Timestamp> hostsTimestamp;
    private ScheduledExecutorService executor;
    private Consumer<DistributedPrimitive.Status> statusChangeListener;

    @Activate
    public void activate(ComponentContext context) {
        this.configService.registerProperties(((Object)((Object)this)).getClass());
        KryoNamespace.Builder hostSerializer = KryoNamespace.newBuilder().register(KryoNamespaces.API);
        this.hostsConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-hosts")).withRelaxedReadConsistency()).withSerializer(Serializer.using((KryoNamespace)hostSerializer.build()))).build();
        this.hosts = this.hostsConsistentMap.asJavaMap();
        this.hostsTimestamp = this.storageService.eventuallyConsistentMapBuilder().withName("onos-hosts-timestamp").withTimestampProvider((k, v) -> new WallClockTimestamp()).withSerializer(hostSerializer).build();
        this.hostsConsistentMap.addListener(this.hostLocationTracker);
        this.modified(context);
        this.executor = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/hosts", (String)"store", (Logger)this.log));
        this.statusChangeListener = status -> {
            if (status == DistributedPrimitive.Status.ACTIVE) {
                this.executor.execute(this::loadHostsByIp);
            }
        };
        this.hostsConsistentMap.addStatusChangeListener(this.statusChangeListener);
        this.loadHostsByIp();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.configService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.hostsConsistentMap.removeListener(this.hostLocationTracker);
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        boolean newRecordTimestamp;
        if (context == null) {
            this.recordHostTimestamp = false;
            this.log.info("Default config");
            return;
        }
        Dictionary properties = context.getProperties();
        String s = Tools.get((Dictionary)properties, (String)"recordHostTimestamp");
        boolean bl = newRecordTimestamp = Strings.isNullOrEmpty((String)s) ? this.recordHostTimestamp : Boolean.parseBoolean(s.trim());
        if (newRecordTimestamp != this.recordHostTimestamp) {
            this.recordHostTimestamp = newRecordTimestamp;
        }
    }

    private void loadHostsByIp() {
        this.hostsByIp = new ConcurrentHashMap<IpAddress, Set<Host>>();
        this.hostsConsistentMap.asJavaMap().values().forEach(host -> host.ipAddresses().forEach(ip -> {
            Set<Host> existingHosts = this.hostsByIp.get(ip);
            if (existingHosts == null) {
                this.hostsByIp.put((IpAddress)ip, this.addHosts((Host)host));
            } else {
                existingHosts.add((Host)host);
            }
        }));
    }

    private boolean shouldUpdate(DefaultHost existingHost, ProviderId providerId, HostId hostId, HostDescription hostDescription, boolean replaceIPs) {
        if (existingHost == null) {
            return true;
        }
        if (!(Objects.equals(existingHost.providerId(), providerId) && Objects.equals(existingHost.mac(), hostDescription.hwAddress()) && Objects.equals(existingHost.vlan(), hostDescription.vlan()) && Objects.equals(existingHost.location(), hostDescription.location()))) {
            return true;
        }
        if (replaceIPs ? !Objects.equals(hostDescription.ipAddress(), existingHost.ipAddresses()) : !existingHost.ipAddresses().containsAll(hostDescription.ipAddress())) {
            return true;
        }
        return hostDescription.annotations().keys().stream().anyMatch(k -> !Objects.equals(hostDescription.annotations().value(k), existingHost.annotations().value(k)));
    }

    public HostEvent createOrUpdateHost(ProviderId providerId, HostId hostId, HostDescription hostDescription, boolean replaceIPs) {
        if (this.recordHostTimestamp && !hostDescription.ipAddress().isEmpty()) {
            this.hostsTimestamp.put((Object)hostId, (Object)new WallClockTimestamp());
        }
        this.hostsConsistentMap.computeIf((Object)hostId, existingHost -> this.shouldUpdate((DefaultHost)existingHost, providerId, hostId, hostDescription, replaceIPs), (id, existingHost) -> {
            boolean configured;
            SparseAnnotations annotations;
            Object addresses;
            HostLocation location = hostDescription.location();
            if (existingHost == null || replaceIPs) {
                addresses = ImmutableSet.copyOf((Collection)hostDescription.ipAddress());
            } else {
                addresses = Sets.newHashSet((Iterable)existingHost.ipAddresses());
                addresses.addAll(hostDescription.ipAddress());
            }
            if (existingHost != null) {
                annotations = DefaultAnnotations.merge((DefaultAnnotations)((DefaultAnnotations)existingHost.annotations()), (SparseAnnotations)hostDescription.annotations());
                configured = existingHost.configured();
            } else {
                annotations = hostDescription.annotations();
                configured = hostDescription.configured();
            }
            return new DefaultHost(providerId, hostId, hostDescription.hwAddress(), hostDescription.vlan(), location, (Set)addresses, configured, new Annotations[]{annotations});
        });
        return null;
    }

    public HostEvent removeHost(HostId hostId) {
        this.hosts.remove(hostId);
        return null;
    }

    public HostEvent removeIp(HostId hostId, IpAddress ipAddress) {
        this.hosts.compute(hostId, (id, existingHost) -> {
            if (existingHost != null) {
                Preconditions.checkState((boolean)Objects.equals(hostId.mac(), existingHost.mac()), (Object)"Existing and new MAC addresses differ.");
                Preconditions.checkState((boolean)Objects.equals(hostId.vlanId(), existingHost.vlan()), (Object)"Existing and new VLANs differ.");
                HashSet addresses = existingHost.ipAddresses();
                if (addresses != null && addresses.contains(ipAddress)) {
                    addresses = new HashSet(existingHost.ipAddresses());
                    addresses.remove(ipAddress);
                    this.removeIpFromHostsByIp((DefaultHost)existingHost, ipAddress);
                    return new DefaultHost(existingHost.providerId(), hostId, existingHost.mac(), existingHost.vlan(), existingHost.location(), (Set)ImmutableSet.copyOf(addresses), new Annotations[]{existingHost.annotations()});
                }
                return existingHost;
            }
            return null;
        });
        return null;
    }

    public int getHostCount() {
        return this.hosts.size();
    }

    public Iterable<Host> getHosts() {
        return ImmutableSet.copyOf(this.hosts.values());
    }

    public Host getHost(HostId hostId) {
        return (Host)this.hosts.get(hostId);
    }

    public Set<Host> getHosts(VlanId vlanId) {
        return this.filter(this.hosts.values(), host -> Objects.equals(host.vlan(), vlanId));
    }

    public Set<Host> getHosts(MacAddress mac) {
        return this.filter(this.hosts.values(), host -> Objects.equals(host.mac(), mac));
    }

    public Set<Host> getHosts(IpAddress ip) {
        Set<Host> hosts = this.hostsByIp.get(ip);
        return hosts != null ? ImmutableSet.copyOf(hosts) : ImmutableSet.of();
    }

    public Set<Host> getConnectedHosts(ConnectPoint connectPoint) {
        Set filtered = this.hosts.entrySet().stream().filter(entry -> ((DefaultHost)entry.getValue()).location().equals((Object)connectPoint)).map(Map.Entry::getValue).collect(Collectors.toSet());
        return ImmutableSet.copyOf(filtered);
    }

    public Set<Host> getConnectedHosts(DeviceId deviceId) {
        Set filtered = this.hosts.entrySet().stream().filter(entry -> ((DefaultHost)entry.getValue()).location().deviceId().equals((Object)deviceId)).map(Map.Entry::getValue).collect(Collectors.toSet());
        return ImmutableSet.copyOf(filtered);
    }

    public Timestamp getHostLastseenTime(HostId hostId) {
        return (Timestamp)this.hostsTimestamp.get((Object)hostId);
    }

    private Set<Host> filter(Collection<DefaultHost> collection, Predicate<DefaultHost> predicate) {
        return collection.stream().filter(predicate).collect(Collectors.toSet());
    }

    private Set<Host> addHosts(Host host) {
        Set hosts = Sets.newConcurrentHashSet();
        hosts.add(host);
        return hosts;
    }

    private Set<Host> updateHosts(Set<Host> existingHosts, Host host) {
        Iterator<Host> iterator = existingHosts.iterator();
        while (iterator.hasNext()) {
            Host existingHost = iterator.next();
            if (!existingHost.id().equals((Object)host.id())) continue;
            iterator.remove();
        }
        existingHosts.add(host);
        return existingHosts;
    }

    private Set<Host> removeHosts(Set<Host> existingHosts, Host host) {
        if (existingHosts != null) {
            Iterator<Host> iterator = existingHosts.iterator();
            while (iterator.hasNext()) {
                Host existingHost = iterator.next();
                if (!existingHost.id().equals((Object)host.id())) continue;
                iterator.remove();
            }
        }
        if (existingHosts.isEmpty()) {
            return null;
        }
        return existingHosts;
    }

    private void updateHostsByIp(DefaultHost host) {
        host.ipAddresses().forEach(ip -> this.hostsByIp.compute((IpAddress)ip, (k, v) -> v == null ? this.addHosts((Host)host) : this.updateHosts((Set<Host>)v, (Host)host)));
    }

    private void removeHostsByIp(DefaultHost host) {
        host.ipAddresses().forEach(ip -> this.hostsByIp.computeIfPresent((IpAddress)ip, (k, v) -> this.removeHosts((Set<Host>)v, (Host)host)));
    }

    private void removeIpFromHostsByIp(DefaultHost host, IpAddress ip) {
        this.hostsByIp.computeIfPresent(ip, (k, v) -> this.removeHosts((Set<Host>)v, (Host)host));
    }

    protected void bindConfigService(ComponentConfigService componentConfigService) {
        this.configService = componentConfigService;
    }

    protected void unbindConfigService(ComponentConfigService componentConfigService) {
        if (this.configService == componentConfigService) {
            this.configService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class HostLocationTracker
    implements MapEventListener<HostId, DefaultHost> {
        private HostLocationTracker() {
        }

        public void event(MapEvent<HostId, DefaultHost> event) {
            DefaultHost host = (DefaultHost)Preconditions.checkNotNull((Object)event.value().value());
            switch (event.type()) {
                case INSERT: {
                    DistributedHostStore.this.updateHostsByIp(host);
                    DistributedHostStore.this.notifyDelegate((Event)new HostEvent(HostEvent.Type.HOST_ADDED, (Host)host));
                    break;
                }
                case UPDATE: {
                    DistributedHostStore.this.updateHostsByIp(host);
                    DefaultHost prevHost = (DefaultHost)Preconditions.checkNotNull((Object)event.oldValue().value());
                    if (!Objects.equals(prevHost.location(), host.location())) {
                        DistributedHostStore.this.notifyDelegate((Event)new HostEvent(HostEvent.Type.HOST_MOVED, (Host)host, (Host)prevHost));
                        break;
                    }
                    if (Objects.equals(prevHost, host)) break;
                    DistributedHostStore.this.notifyDelegate((Event)new HostEvent(HostEvent.Type.HOST_UPDATED, (Host)host, (Host)prevHost));
                    break;
                }
                case REMOVE: {
                    DistributedHostStore.this.updateHostsByIp(host);
                    DistributedHostStore.this.notifyDelegate((Event)new HostEvent(HostEvent.Type.HOST_REMOVED, (Host)host));
                    break;
                }
                default: {
                    DistributedHostStore.this.log.warn("Unknown map event type: {}", (Object)event.type());
                }
            }
        }
    }
}

