/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.intent.impl;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.event.EventListener;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.net.intent.WorkPartitionEvent;
import org.onosproject.net.intent.WorkPartitionEventListener;
import org.onosproject.net.intent.WorkPartitionService;
import org.onosproject.store.intent.impl.PartitionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class WorkPartitionManager
implements WorkPartitionService {
    private static final Logger log = LoggerFactory.getLogger(WorkPartitionManager.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected EventDeliveryService eventDispatcher;
    protected final AtomicBoolean rebalanceScheduled = new AtomicBoolean(false);
    static final int NUM_PARTITIONS = 14;
    private static final int BACKOFF_TIME = 2;
    private static final int CHECK_PARTITION_BALANCE_PERIOD_SEC = 10;
    private static final int RETRY_AFTER_DELAY_SEC = 5;
    private static final String ELECTION_PREFIX = "work-partition-";
    protected NodeId localNodeId;
    private ListenerRegistry<WorkPartitionEvent, WorkPartitionEventListener> listenerRegistry;
    private LeadershipEventListener leaderListener = new InternalLeadershipListener();
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, Tools.groupedThreads((String)"work-parition", (String)"balancer-%d", (Logger)log));

    @Activate
    public void activate() {
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.leadershipService.addListener((EventListener)this.leaderListener);
        this.listenerRegistry = new ListenerRegistry();
        this.eventDispatcher.addSink(WorkPartitionEvent.class, this.listenerRegistry);
        for (int i = 0; i < 14; ++i) {
            this.leadershipService.runForLeadership(this.getPartitionPath(i));
            log.debug("Registered to run for {}", (Object)this.getPartitionPath(i));
        }
        this.executor.scheduleAtFixedRate(() -> this.scheduleRebalance(0), 0L, 10L, TimeUnit.SECONDS);
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.executor.shutdownNow();
        this.eventDispatcher.removeSink(WorkPartitionEvent.class);
        this.leadershipService.removeListener((EventListener)this.leaderListener);
        log.info("Stopped");
    }

    WorkPartitionManager withScheduledExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
        return this;
    }

    private String getPartitionPath(int i) {
        return ELECTION_PREFIX + i;
    }

    public <K> boolean isMine(K id, Function<K, Long> hasher) {
        return Objects.equals(this.localNodeId, this.getLeader(id, hasher));
    }

    public <K> NodeId getLeader(K id, Function<K, Long> hasher) {
        int partition = Math.abs(hasher.apply(id).intValue()) % 14;
        PartitionId partitionId = new PartitionId(partition);
        return this.leadershipService.getLeadership(this.getPartitionPath(partitionId.value())).leaderNodeId();
    }

    public void addListener(WorkPartitionEventListener listener) {
        this.listenerRegistry.addListener((EventListener)listener);
    }

    public void removeListener(WorkPartitionEventListener listener) {
        this.listenerRegistry.removeListener((EventListener)listener);
    }

    void doRebalance() {
        this.rebalanceScheduled.set(false);
        try {
            this.rebalance();
        }
        catch (Exception e) {
            log.warn("Exception caught during rebalance task. Will retry in 5 seconds", (Throwable)e);
            this.scheduleRebalance(5);
        }
    }

    private void rebalance() {
        int activeNodes = (int)this.clusterService.getNodes().stream().filter(node -> this.clusterService.getState(node.id()).isActive()).count();
        int myShare = (int)Math.ceil(14.0 / (double)activeNodes);
        IntStream.range(0, 14).mapToObj(this::getPartitionPath).map(arg_0 -> ((LeadershipService)this.leadershipService).getLeadership(arg_0)).filter(leadership -> !leadership.candidates().contains(this.localNodeId)).map(Leadership::topic).forEach(arg_0 -> ((LeadershipService)this.leadershipService).runForLeadership(arg_0));
        List myPartitions = IntStream.range(0, 14).mapToObj(this::getPartitionPath).map(arg_0 -> ((LeadershipService)this.leadershipService).getLeadership(arg_0)).filter(Objects::nonNull).filter(leadership -> this.localNodeId.equals((Object)leadership.leaderNodeId())).map(Leadership::topic).collect(Collectors.toList());
        int relinquish = myPartitions.size() - myShare;
        for (int i = 0; i < relinquish; ++i) {
            String topic = (String)myPartitions.get(i);
            if (this.leadershipService.getCandidates(topic).size() != activeNodes) continue;
            this.leadershipService.withdraw(topic);
            this.executor.schedule(() -> this.recontest(topic), 2L, TimeUnit.SECONDS);
        }
    }

    private void scheduleRebalance(int afterDelaySec) {
        if (this.rebalanceScheduled.compareAndSet(false, true)) {
            this.executor.schedule(this::doRebalance, (long)afterDelaySec, TimeUnit.SECONDS);
        }
    }

    private void recontest(String path) {
        this.leadershipService.runForLeadership(path);
    }

    protected void bindLeadershipService(LeadershipService leadershipService) {
        this.leadershipService = leadershipService;
    }

    protected void unbindLeadershipService(LeadershipService leadershipService) {
        if (this.leadershipService == leadershipService) {
            this.leadershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindEventDispatcher(EventDeliveryService eventDeliveryService) {
        this.eventDispatcher = eventDeliveryService;
    }

    protected void unbindEventDispatcher(EventDeliveryService eventDeliveryService) {
        if (this.eventDispatcher == eventDeliveryService) {
            this.eventDispatcher = null;
        }
    }

    private final class InternalLeadershipListener
    implements LeadershipEventListener {
        private InternalLeadershipListener() {
        }

        public void event(LeadershipEvent event) {
            Leadership leadership = (Leadership)event.subject();
            if (Objects.equals(leadership.leaderNodeId(), WorkPartitionManager.this.localNodeId) && leadership.topic().startsWith(WorkPartitionManager.ELECTION_PREFIX)) {
                WorkPartitionManager.this.eventDispatcher.post((Event)new WorkPartitionEvent(WorkPartitionEvent.Type.LEADER_CHANGED, leadership.topic()));
            }
            if (event.type() == LeadershipEvent.Type.CANDIDATES_CHANGED) {
                WorkPartitionManager.this.scheduleRebalance(0);
            }
        }
    }
}

