/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.host.impl;

import com.google.common.collect.Sets;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ComponentContextAdapter;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onosproject.cfg.ComponentConfigAdapter;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.host.DefaultHostDescription;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.Timestamp;
import org.onosproject.store.host.impl.DistributedHostStore;
import org.onosproject.store.service.TestStorageService;
import org.osgi.service.component.ComponentContext;

public class DistributedHostStoreTest {
    private DistributedHostStore ecXHostStore;
    private static final HostId HOSTID = HostId.hostId((MacAddress)MacAddress.valueOf((String)"1a:1a:1a:1a:1a:1a"));
    private static final HostId HOSTID1 = HostId.hostId((MacAddress)MacAddress.valueOf((String)"1a:1a:1a:1a:1a:1b"));
    private static final IpAddress IP1 = IpAddress.valueOf((String)"10.2.0.2");
    private static final IpAddress IP2 = IpAddress.valueOf((String)"10.2.0.3");
    private static final ProviderId PID = new ProviderId("of", "foo");
    public static final ComponentContextAdapter RECORD_HOST_TIMESTAMP = new ComponentContextAdapter(){

        public Dictionary getProperties() {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("recordHostTimestamp", "true");
            return props;
        }
    };

    @Before
    public void setUp() {
        this.ecXHostStore = new DistributedHostStore();
        this.ecXHostStore.storageService = new TestStorageService();
        this.ecXHostStore.configService = new ComponentConfigAdapter();
        this.ecXHostStore.activate((ComponentContext)RECORD_HOST_TIMESTAMP);
    }

    @After
    public void tearDown() {
        this.ecXHostStore.deactivate();
    }

    @Test
    public void testRemoveIp() {
        HashSet<IpAddress> ips = new HashSet<IpAddress>();
        ips.add(IP1);
        ips.add(IP2);
        HostDescription description = this.createHostDesc(HOSTID, ips);
        this.ecXHostStore.createOrUpdateHost(PID, HOSTID, description, false);
        this.ecXHostStore.removeIp(HOSTID, IP1);
        Host host = this.ecXHostStore.getHost(HOSTID);
        Assert.assertFalse((boolean)host.ipAddresses().contains(IP1));
        TestCase.assertTrue((boolean)host.ipAddresses().contains(IP2));
    }

    @Test
    public void testRecordTimestamp() {
        HashSet<IpAddress> ips = new HashSet<IpAddress>();
        ips.add(IP1);
        ips.add(IP2);
        DefaultHostDescription description = new DefaultHostDescription(HOSTID.mac(), HOSTID.vlanId(), HostLocation.NONE, ips, new SparseAnnotations[0]);
        this.ecXHostStore.createOrUpdateHost(PID, HOSTID, (HostDescription)description, false);
        Timestamp timestamp = this.ecXHostStore.getHostLastseenTime(HOSTID);
        Assert.assertFalse((timestamp == null ? 1 : 0) != 0);
        TestCase.assertTrue((timestamp != null ? 1 : 0) != 0);
    }

    @Test
    public void testAddHostByIp() {
        HashSet<IpAddress> ips = new HashSet<IpAddress>();
        ips.add(IP1);
        ips.add(IP2);
        HostDescription description = this.createHostDesc(HOSTID, ips);
        this.ecXHostStore.createOrUpdateHost(PID, HOSTID, description, false);
        Set hosts = this.ecXHostStore.getHosts(IP1);
        Assert.assertFalse((hosts.size() > 1 ? 1 : 0) != 0);
        TestCase.assertTrue((hosts.size() == 1 ? 1 : 0) != 0);
        HostDescription description1 = this.createHostDesc(HOSTID1, Sets.newHashSet((Object[])new IpAddress[]{IP2}));
        this.ecXHostStore.createOrUpdateHost(PID, HOSTID1, description1, false);
        Set hosts1 = this.ecXHostStore.getHosts(IP2);
        Assert.assertFalse((hosts1.size() < 1 ? 1 : 0) != 0);
        TestCase.assertTrue((hosts1.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveHostByIp() {
        HashSet<IpAddress> ips = new HashSet<IpAddress>();
        ips.add(IP1);
        ips.add(IP2);
        HostDescription description = this.createHostDesc(HOSTID, ips);
        this.ecXHostStore.createOrUpdateHost(PID, HOSTID, description, false);
        this.ecXHostStore.removeIp(HOSTID, IP1);
        Set hosts = this.ecXHostStore.getHosts(IP1);
        TestCase.assertTrue((hosts.size() == 0 ? 1 : 0) != 0);
    }

    private HostDescription createHostDesc(HostId hostId, Set<IpAddress> ips) {
        return new DefaultHostDescription(hostId.mac(), hostId.vlanId(), HostLocation.NONE, ips, new SparseAnnotations[0]);
    }
}

