/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.topology.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.graph.GraphPathSearch;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.common.DefaultTopology;
import org.onosproject.event.Event;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.ClusterId;
import org.onosproject.net.topology.DefaultGraphDescription;
import org.onosproject.net.topology.GeoDistanceLinkWeight;
import org.onosproject.net.topology.GraphDescription;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.MetricLinkWeight;
import org.onosproject.net.topology.PathAdminService;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyCluster;
import org.onosproject.net.topology.TopologyEdge;
import org.onosproject.net.topology.TopologyEvent;
import org.onosproject.net.topology.TopologyGraph;
import org.onosproject.net.topology.TopologyStore;
import org.onosproject.net.topology.TopologyStoreDelegate;
import org.onosproject.net.topology.TopologyVertex;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.LogicalClockService;
import org.onosproject.store.service.StorageService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedTopologyStore
extends AbstractStore<TopologyEvent, TopologyStoreDelegate>
implements TopologyStore,
PathAdminService {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String FORMAT = "Settings: linkWeightFunction={}";
    private volatile DefaultTopology current = new DefaultTopology(ProviderId.NONE, (GraphDescription)new DefaultGraphDescription(0L, System.currentTimeMillis(), Collections.emptyList(), Collections.emptyList(), new SparseAnnotations[0]));
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LogicalClockService clockService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    private static final String HOP_COUNT = "hopCount";
    private static final String LINK_METRIC = "linkMetric";
    private static final String GEO_DISTANCE = "geoDistance";
    private static final String DEFAULT_LINK_WEIGHT_FUNCTION = "hopCount";
    @Property(name="linkWeightFunction", value={"hopCount"}, label="Default link-weight function: hopCount, linkMetric, geoDistance")
    private String linkWeightFunction = "hopCount";
    private EventuallyConsistentMap<DeviceId, Set<ConnectPoint>> broadcastPoints;
    private EventuallyConsistentMapListener<DeviceId, Set<ConnectPoint>> listener = new InternalBroadcastPointListener();

    @Activate
    protected void activate() {
        this.configService.registerProperties(((Object)((Object)this)).getClass());
        KryoNamespace.Builder hostSerializer = KryoNamespace.newBuilder().register(KryoNamespaces.API);
        this.broadcastPoints = this.storageService.eventuallyConsistentMapBuilder().withName("onos-broadcast-trees").withSerializer(hostSerializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.broadcastPoints.addListener(this.listener);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.configService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.broadcastPoints.removeListener(this.listener);
        this.broadcastPoints.destroy();
        this.log.info("Stopped");
    }

    @Modified
    protected void modified(ComponentContext context) {
        Dictionary properties = context.getProperties();
        String newLinkWeightFunction = Tools.get((Dictionary)properties, (String)"linkWeightFunction");
        if (newLinkWeightFunction != null && !Objects.equals(newLinkWeightFunction, this.linkWeightFunction)) {
            this.linkWeightFunction = newLinkWeightFunction;
            MetricLinkWeight weight = this.linkWeightFunction.equals(LINK_METRIC) ? new MetricLinkWeight() : (this.linkWeightFunction.equals(GEO_DISTANCE) ? new GeoDistanceLinkWeight(this.deviceService) : null);
            this.setDefaultLinkWeight((LinkWeight)weight);
        }
        this.log.info(FORMAT, (Object)this.linkWeightFunction);
    }

    public Topology currentTopology() {
        return this.current;
    }

    public boolean isLatest(Topology topology) {
        return topology == this.current;
    }

    public TopologyGraph getGraph(Topology topology) {
        return this.defaultTopology(topology).getGraph();
    }

    public Set<TopologyCluster> getClusters(Topology topology) {
        return this.defaultTopology(topology).getClusters();
    }

    public TopologyCluster getCluster(Topology topology, ClusterId clusterId) {
        return this.defaultTopology(topology).getCluster(clusterId);
    }

    public Set<DeviceId> getClusterDevices(Topology topology, TopologyCluster cluster) {
        return this.defaultTopology(topology).getClusterDevices(cluster);
    }

    public Set<Link> getClusterLinks(Topology topology, TopologyCluster cluster) {
        return this.defaultTopology(topology).getClusterLinks(cluster);
    }

    public Set<Path> getPaths(Topology topology, DeviceId src, DeviceId dst) {
        return this.defaultTopology(topology).getPaths(src, dst);
    }

    public Set<Path> getPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeight weight) {
        return this.defaultTopology(topology).getPaths(src, dst, weight);
    }

    public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst) {
        return this.defaultTopology(topology).getDisjointPaths(src, dst);
    }

    public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeight weight) {
        return this.defaultTopology(topology).getDisjointPaths(src, dst, weight);
    }

    public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst, Map<Link, Object> riskProfile) {
        return this.defaultTopology(topology).getDisjointPaths(src, dst, riskProfile);
    }

    public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeight weight, Map<Link, Object> riskProfile) {
        return this.defaultTopology(topology).getDisjointPaths(src, dst, weight, riskProfile);
    }

    public boolean isInfrastructure(Topology topology, ConnectPoint connectPoint) {
        return this.defaultTopology(topology).isInfrastructure(connectPoint);
    }

    public boolean isBroadcastPoint(Topology topology, ConnectPoint connectPoint) {
        return this.defaultTopology(topology).isBroadcastPoint(connectPoint);
    }

    private boolean isBroadcastPoint(ConnectPoint connectPoint) {
        if (!this.current.isInfrastructure(connectPoint)) {
            return true;
        }
        TopologyCluster cluster = this.current.getCluster(connectPoint.deviceId());
        Preconditions.checkArgument((cluster != null ? 1 : 0) != 0, (String)"No cluster found for device %s", (Object[])new Object[]{connectPoint.deviceId()});
        Set points = (Set)this.broadcastPoints.get((Object)cluster.root().deviceId());
        return Tools.isNullOrEmpty((Collection)points) || points.contains(connectPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopologyEvent updateTopology(ProviderId providerId, GraphDescription graphDescription, List<Event> reasons) {
        if (this.current != null && graphDescription.timestamp() < this.current.time()) {
            return null;
        }
        DefaultTopology newTopology = new DefaultTopology(providerId, graphDescription, this::isBroadcastPoint);
        this.updateBroadcastPoints(newTopology);
        DistributedTopologyStore distributedTopologyStore = this;
        synchronized (distributedTopologyStore) {
            this.current = newTopology;
            return new TopologyEvent(TopologyEvent.Type.TOPOLOGY_CHANGED, (Topology)this.current, reasons);
        }
    }

    private void updateBroadcastPoints(DefaultTopology topology) {
        Set<DeviceId> toRemove = this.broadcastPoints.keySet().stream().filter(arg_0 -> ((MastershipService)this.mastershipService).isLocalMaster(arg_0)).collect(Collectors.toSet());
        topology.getClusters().forEach(c -> {
            toRemove.remove(c.root().deviceId());
            if (this.mastershipService.isLocalMaster(c.root().deviceId())) {
                this.broadcastPoints.put((Object)c.root().deviceId(), (Object)topology.broadcastPoints(c.id()));
            }
        });
        toRemove.forEach(arg_0 -> this.broadcastPoints.remove(arg_0));
    }

    private DefaultTopology defaultTopology(Topology topology) {
        Preconditions.checkArgument((boolean)(topology instanceof DefaultTopology), (String)"Topology class %s not supported", (Object[])new Object[]{topology.getClass()});
        return (DefaultTopology)topology;
    }

    public void setDefaultLinkWeight(LinkWeight linkWeight) {
        DefaultTopology.setDefaultLinkWeight((LinkWeight)linkWeight);
    }

    public void setDefaultGraphPathSearch(GraphPathSearch<TopologyVertex, TopologyEdge> graphPathSearch) {
        DefaultTopology.setDefaultGraphPathSearch(graphPathSearch);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindClockService(LogicalClockService logicalClockService) {
        this.clockService = logicalClockService;
    }

    protected void unbindClockService(LogicalClockService logicalClockService) {
        if (this.clockService == logicalClockService) {
            this.clockService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindConfigService(ComponentConfigService componentConfigService) {
        this.configService = componentConfigService;
    }

    protected void unbindConfigService(ComponentConfigService componentConfigService) {
        if (this.configService == componentConfigService) {
            this.configService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    private class InternalBroadcastPointListener
    implements EventuallyConsistentMapListener<DeviceId, Set<ConnectPoint>> {
        private InternalBroadcastPointListener() {
        }

        public void event(EventuallyConsistentMapEvent<DeviceId, Set<ConnectPoint>> event) {
            if (event.type() == EventuallyConsistentMapEvent.Type.PUT && !((Set)event.value()).isEmpty()) {
                DistributedTopologyStore.this.log.debug("Cluster rooted at {} has {} broadcast-points; #{}", new Object[]{event.key(), ((Set)event.value()).size(), ((Set)event.value()).hashCode()});
            }
        }
    }
}

