/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.esotericsoftware.kryo.Serializer;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.net.resource.ContinuousResource;
import org.onosproject.net.resource.ContinuousResourceId;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceConsumerId;
import org.onosproject.net.resource.ResourceEvent;
import org.onosproject.net.resource.ResourceId;
import org.onosproject.net.resource.ResourceStore;
import org.onosproject.net.resource.ResourceStoreDelegate;
import org.onosproject.net.resource.Resources;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.resource.impl.ConsistentContinuousResourceSubStore;
import org.onosproject.store.resource.impl.ConsistentDiscreteResourceSubStore;
import org.onosproject.store.resource.impl.ContinuousResourceAllocation;
import org.onosproject.store.resource.impl.EmptyDiscreteResources;
import org.onosproject.store.resource.impl.EncodableDiscreteResources;
import org.onosproject.store.resource.impl.EncodableDiscreteResourcesSerializer;
import org.onosproject.store.resource.impl.EncodedDiscreteResources;
import org.onosproject.store.resource.impl.EncodedResourcesSerializer;
import org.onosproject.store.resource.impl.GenericDiscreteResources;
import org.onosproject.store.resource.impl.MplsLabelCodec;
import org.onosproject.store.resource.impl.PortNumberCodec;
import org.onosproject.store.resource.impl.TransactionalContinuousResourceSubStore;
import org.onosproject.store.resource.impl.TransactionalDiscreteResourceSubStore;
import org.onosproject.store.resource.impl.UnifiedDiscreteResources;
import org.onosproject.store.resource.impl.VlanIdCodec;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.CommitStatus;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.TransactionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
@Beta
public class ConsistentResourceStore
extends AbstractStore<ResourceEvent, ResourceStoreDelegate>
implements ResourceStore {
    private static final Logger log = LoggerFactory.getLogger(ConsistentResourceStore.class);
    static final org.onosproject.store.service.Serializer SERIALIZER = org.onosproject.store.service.Serializer.using((KryoNamespace)KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{UnifiedDiscreteResources.class}).register((Serializer)new EncodableDiscreteResourcesSerializer(), new Class[]{EncodableDiscreteResources.class}).register(new Class[]{GenericDiscreteResources.class}).register(new Class[]{EmptyDiscreteResources.class}).register((Serializer)new EncodedResourcesSerializer(), new Class[]{EncodedDiscreteResources.class}).register(new Class[]{ContinuousResourceAllocation.class}).register(new Class[]{PortNumberCodec.class}).register(new Class[]{VlanIdCodec.class}).register(new Class[]{MplsLabelCodec.class}).build());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService service;
    private ConsistentDiscreteResourceSubStore discreteStore;
    private ConsistentContinuousResourceSubStore continuousStore;

    @Activate
    public void activate() {
        this.discreteStore = new ConsistentDiscreteResourceSubStore(this.service);
        this.continuousStore = new ConsistentContinuousResourceSubStore(this.service);
        log.info("Started");
    }

    public List<ResourceAllocation> getResourceAllocations(ResourceId id) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkArgument((id instanceof DiscreteResourceId || id instanceof ContinuousResourceId ? 1 : 0) != 0);
        if (id instanceof DiscreteResourceId) {
            return this.discreteStore.getResourceAllocations((DiscreteResourceId)id);
        }
        return this.continuousStore.getResourceAllocations((ContinuousResourceId)id);
    }

    public boolean register(List<? extends Resource> resources) {
        Preconditions.checkNotNull(resources);
        if (log.isTraceEnabled()) {
            resources.forEach(r -> log.trace("registering {}", r));
        }
        TransactionContext tx = (TransactionContext)this.service.transactionContextBuilder().build();
        tx.begin();
        Map resourceMap = resources.stream().filter(x -> x.parent().isPresent()).collect(Collectors.groupingBy(x -> (DiscreteResource)x.parent().get(), LinkedHashMap::new, Collectors.toList()));
        TransactionalDiscreteResourceSubStore discreteTxStore = this.discreteStore.transactional(tx);
        TransactionalContinuousResourceSubStore continuousTxStore = this.continuousStore.transactional(tx);
        for (Map.Entry entry : resourceMap.entrySet()) {
            DiscreteResourceId parentId = ((DiscreteResource)entry.getKey()).id();
            if (!discreteTxStore.lookup(parentId).isPresent()) {
                return this.abortTransaction(tx);
            }
            if (this.register(discreteTxStore, continuousTxStore, parentId, (List)entry.getValue())) continue;
            return this.abortTransaction(tx);
        }
        return ((CompletableFuture)tx.commit().whenComplete((status, error) -> {
            if (status == CommitStatus.SUCCESS) {
                log.trace("Transaction commit succeeded on registration: resources={}", (Object)resources);
                List events = resources.stream().filter(x -> x.parent().isPresent()).map(x -> new ResourceEvent(ResourceEvent.Type.RESOURCE_ADDED, x)).collect(Collectors.toList());
                this.notifyDelegate(events);
            } else {
                log.warn("Transaction commit failed on registration", error);
            }
        })).join() == CommitStatus.SUCCESS;
    }

    public boolean unregister(List<? extends ResourceId> ids) {
        Preconditions.checkNotNull(ids);
        TransactionContext tx = (TransactionContext)this.service.transactionContextBuilder().build();
        tx.begin();
        TransactionalDiscreteResourceSubStore discreteTxStore = this.discreteStore.transactional(tx);
        TransactionalContinuousResourceSubStore continuousTxStore = this.continuousStore.transactional(tx);
        List resources = ids.stream().filter(x -> x.parent().isPresent()).map(x -> {
            if (x instanceof DiscreteResourceId) {
                return Optional.of(Resources.discrete((DiscreteResourceId)((DiscreteResourceId)x)).resource());
            }
            return continuousTxStore.lookup((ContinuousResourceId)x);
        }).flatMap(Tools::stream).collect(Collectors.toList());
        Map resourceMap = resources.stream().collect(Collectors.groupingBy(x -> ((DiscreteResource)x.parent().get()).id(), LinkedHashMap::new, Collectors.toList()));
        for (Map.Entry entry : resourceMap.entrySet()) {
            if (this.unregister(discreteTxStore, continuousTxStore, (DiscreteResourceId)entry.getKey(), (List)entry.getValue())) continue;
            log.warn("Failed to unregister {}: Failed to remove {} values.", entry.getKey(), (Object)((List)entry.getValue()).size());
            log.debug("Failed to unregister {}: Failed to remove values: {}", entry.getKey(), entry.getValue());
            return this.abortTransaction(tx);
        }
        return ((CompletableFuture)tx.commit().whenComplete((status, error) -> {
            if (status == CommitStatus.SUCCESS) {
                List events = resources.stream().filter(x -> x.parent().isPresent()).map(x -> new ResourceEvent(ResourceEvent.Type.RESOURCE_REMOVED, x)).collect(Collectors.toList());
                this.notifyDelegate(events);
            } else {
                String message = resources.stream().map(Resource::simpleTypeName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(e -> String.format("%d %s type resources", e.getValue(), e.getKey())).collect(Collectors.joining(", "));
                log.warn("Failed to unregister {}: Commit failed.", (Object)message, error);
            }
        })).join() == CommitStatus.SUCCESS;
    }

    public boolean allocate(List<? extends Resource> resources, ResourceConsumer consumer) {
        Preconditions.checkNotNull(resources);
        Preconditions.checkNotNull((Object)consumer);
        TransactionContext tx = (TransactionContext)this.service.transactionContextBuilder().build();
        tx.begin();
        TransactionalDiscreteResourceSubStore discreteTxStore = this.discreteStore.transactional(tx);
        TransactionalContinuousResourceSubStore continuousTxStore = this.continuousStore.transactional(tx);
        for (Resource resource : resources) {
            if (!(resource instanceof DiscreteResource ? !discreteTxStore.allocate(consumer.consumerId(), (DiscreteResource)resource) : resource instanceof ContinuousResource && !continuousTxStore.allocate(consumer.consumerId(), (ContinuousResource)resource))) continue;
            return this.abortTransaction(tx);
        }
        return tx.commit().join() == CommitStatus.SUCCESS;
    }

    public boolean release(List<ResourceAllocation> allocations) {
        Preconditions.checkNotNull(allocations);
        TransactionContext tx = (TransactionContext)this.service.transactionContextBuilder().build();
        tx.begin();
        TransactionalDiscreteResourceSubStore discreteTxStore = this.discreteStore.transactional(tx);
        TransactionalContinuousResourceSubStore continuousTxStore = this.continuousStore.transactional(tx);
        for (ResourceAllocation allocation : allocations) {
            Resource resource = allocation.resource();
            ResourceConsumerId consumerId = allocation.consumerId();
            if (!(resource instanceof DiscreteResource ? !discreteTxStore.release((DiscreteResource)resource, consumerId) : resource instanceof ContinuousResource && !continuousTxStore.release((ContinuousResource)resource, consumerId))) continue;
            return this.abortTransaction(tx);
        }
        return tx.commit().join() == CommitStatus.SUCCESS;
    }

    public boolean isAvailable(Resource resource) {
        Preconditions.checkNotNull((Object)resource);
        Preconditions.checkArgument((resource instanceof DiscreteResource || resource instanceof ContinuousResource ? 1 : 0) != 0);
        if (resource instanceof DiscreteResource) {
            return this.discreteStore.isAvailable((DiscreteResource)resource);
        }
        return this.continuousStore.isAvailable((ContinuousResource)resource);
    }

    public Collection<Resource> getResources(ResourceConsumer consumer) {
        Preconditions.checkNotNull((Object)consumer);
        Stream<DiscreteResource> discrete = this.discreteStore.getResources(consumer.consumerId());
        Stream<ContinuousResource> continuous = this.continuousStore.getResources(consumer.consumerId());
        return Stream.concat(discrete, continuous).collect(Collectors.toList());
    }

    public Set<Resource> getChildResources(DiscreteResourceId parent) {
        Preconditions.checkNotNull((Object)parent);
        return ImmutableSet.builder().addAll(this.discreteStore.getChildResources(parent)).addAll(this.continuousStore.getChildResources(parent)).build();
    }

    public <T> Set<Resource> getChildResources(DiscreteResourceId parent, Class<T> cls) {
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull(cls);
        return ImmutableSet.builder().addAll(this.discreteStore.getChildResources(parent, cls)).addAll(this.continuousStore.getChildResources(parent, cls)).build();
    }

    public <T> Collection<Resource> getAllocatedResources(DiscreteResourceId parent, Class<T> cls) {
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull(cls);
        Stream<DiscreteResource> discrete = this.discreteStore.getAllocatedResources(parent, cls);
        Stream<ContinuousResource> continuous = this.continuousStore.getAllocatedResources(parent, cls);
        return Stream.concat(discrete, continuous).collect(Collectors.toList());
    }

    private boolean abortTransaction(TransactionContext tx) {
        tx.abort();
        return false;
    }

    private boolean register(TransactionalDiscreteResourceSubStore discreteTxStore, TransactionalContinuousResourceSubStore continuousTxStore, DiscreteResourceId parent, List<Resource> resources) {
        Set discreteResources = resources.stream().filter(x -> x instanceof DiscreteResource).map(x -> (DiscreteResource)x).collect(Collectors.toCollection(LinkedHashSet::new));
        Set continuousResources = resources.stream().filter(x -> x instanceof ContinuousResource).map(x -> (ContinuousResource)x).collect(Collectors.toCollection(LinkedHashSet::new));
        return discreteTxStore.register(parent, discreteResources) && continuousTxStore.register(parent, continuousResources);
    }

    private boolean unregister(TransactionalDiscreteResourceSubStore discreteTxStore, TransactionalContinuousResourceSubStore continuousTxStore, DiscreteResourceId parent, List<Resource> resources) {
        Set discreteResources = resources.stream().filter(x -> x instanceof DiscreteResource).map(x -> (DiscreteResource)x).collect(Collectors.toCollection(LinkedHashSet::new));
        Set continuousResources = resources.stream().filter(x -> x instanceof ContinuousResource).map(x -> (ContinuousResource)x).collect(Collectors.toCollection(LinkedHashSet::new));
        return discreteTxStore.unregister(parent, discreteResources) && continuousTxStore.unregister(parent, continuousResources);
    }

    protected void bindService(StorageService storageService) {
        this.service = storageService;
    }

    protected void unbindService(StorageService storageService) {
        if (this.service == storageService) {
            this.service = null;
        }
    }
}

