/*
 * Copyright 2016-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.onosproject.codec.impl;

import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.behaviour.protection.TransportEndpointDescription;
import org.onosproject.net.behaviour.protection.TransportEndpointDescription.Builder;

import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * JSON Codec for {@link TransportEndpointDescription}.
 */
public class TransportEndpointDescriptionCodec
    extends JsonCodec<TransportEndpointDescription> {

    private static final String OUTPUT = "output";
    private static final String ENABLED = "enabled";

    @Override
    public TransportEndpointDescription decode(ObjectNode json,
                                               CodecContext context) {

        Builder builder = TransportEndpointDescription.builder();
        builder.withEnabled(json.get(ENABLED).asBoolean(true));
        builder.withOutput(context.decode(json.get(OUTPUT), FilteredConnectPoint.class));

        return builder.build();
    }

    @Override
    public ObjectNode encode(TransportEndpointDescription entity,
                             CodecContext context) {
        ObjectNode node = context.mapper().createObjectNode();
        node.put(ENABLED, entity.isEnabled());
        node.set(OUTPUT, context.encode(entity.output(), FilteredConnectPoint.class));
        return node;
    }
}
