/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.persistence.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.onosproject.persistence.PersistenceService;
import org.onosproject.persistence.PersistentMapBuilder;
import org.onosproject.persistence.PersistentSetBuilder;
import org.onosproject.persistence.impl.DefaultPersistentMapBuilder;
import org.onosproject.persistence.impl.DefaultPersistentSetBuilder;
import org.onosproject.persistence.impl.PersistenceException;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class PersistenceManager
implements PersistenceService {
    private static final String DATABASE_ROOT = System.getProperty("karaf.data") + "/db/local/";
    private static final String DATABASE_PATH = "cache";
    static final String MAP_PREFIX = "map:";
    static final String SET_PREFIX = "set:";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private DB localDB = null;
    private static final int FLUSH_FREQUENCY_MILLIS = 3000;
    private Timer timer;
    private final CommitTask commitTask = new CommitTask();

    @Activate
    public void activate() {
        boolean dbFound;
        this.timer = new Timer();
        File dbFolderPath = new File(DATABASE_ROOT);
        Path dbPath = dbFolderPath.toPath().resolve(DATABASE_PATH);
        this.log.debug("dbPath: {}", (Object)dbPath);
        if (!dbFolderPath.isDirectory()) {
            this.log.info("The specified folder location for the database did not exist and will be created.");
            try {
                Files.createDirectories(dbFolderPath.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.log.error("Could not create the required folder for the database.");
                throw new PersistenceException("Database folder could not be created.");
            }
        }
        if (!(dbFound = Files.exists(dbPath, new LinkOption[0]))) {
            this.log.info("The database file could not be located, a new database will be constructed.");
        } else {
            this.log.info("A previous database file has been found.");
        }
        this.localDB = DBMaker.newFileDB((File)dbPath.toFile()).asyncWriteEnable().closeOnJvmShutdown().make();
        this.timer.schedule((TimerTask)this.commitTask, 3000L, 3000L);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.timer.cancel();
        for (Map.Entry entry : this.localDB.getAll().entrySet()) {
            Set asSet;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map asMap = (Map)value;
                if (!asMap.isEmpty()) continue;
                this.localDB.delete(key);
                continue;
            }
            if (!(value instanceof Set) || !(asSet = (Set)value).isEmpty()) continue;
            this.localDB.delete(key);
        }
        this.localDB.commit();
        this.localDB.close();
        this.log.info("Stopped");
    }

    public <K, V> PersistentMapBuilder<K, V> persistentMapBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PERSISTENCE_WRITE);
        return new DefaultPersistentMapBuilder(this.localDB);
    }

    public <E> PersistentSetBuilder<E> persistentSetBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PERSISTENCE_WRITE);
        return new DefaultPersistentSetBuilder(this.localDB);
    }

    private class CommitTask
    extends TimerTask {
        private CommitTask() {
        }

        @Override
        public void run() {
            PersistenceManager.this.localDB.commit();
        }
    }
}

