/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.persistence.impl;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.persistence.impl.MapDBTest;
import org.onosproject.persistence.impl.PersistentMap;
import org.onosproject.store.service.Serializer;

public class PersistentMapTest
extends MapDBTest {
    private PersistentMap<Integer, Integer> map = null;

    @Before
    public void setUp() throws Exception {
        this.map = new PersistentMap(new Serializer(){

            public <T> byte[] encode(T object) {
                if (object == null) {
                    return null;
                }
                int num = (Integer)object;
                byte[] result = new byte[]{(byte)(num >> 24), (byte)(num >> 16), (byte)(num >> 8), (byte)num};
                return result;
            }

            public <T> T decode(byte[] bytes) {
                if (bytes == null) {
                    return null;
                }
                int num = 0;
                num |= bytes[0] << 24;
                num |= bytes[1] << 16;
                num |= bytes[2] << 8;
                return (T)Integer.valueOf(num |= bytes[3]);
            }
        }, this.fakeDB, "map");
    }

    @Test
    public void testRemove() throws Exception {
        this.fillMap(10);
        Assert.assertEquals((long)10L, (long)this.map.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((String)"The previous value was wrong.", (Object)i, (Object)this.map.remove((Object)i));
            Assert.assertNull((String)"The previous value was wrong.", (Object)this.map.remove((Object)i));
            Assert.assertEquals((String)"The size was wrong.", (long)(10 - (i + 1)), (long)this.map.size());
        }
    }

    @Test
    public void testSize() throws Exception {
        int i;
        for (i = 0; i < 10; ++i) {
            this.map.put((Object)i, (Object)i);
            Assert.assertEquals((String)"The map size is wrong.", (long)(i + 1), (long)this.map.size());
        }
        for (i = 0; i < 10; ++i) {
            this.map.remove((Object)i);
            Assert.assertEquals((String)"The map size is wrong.", (long)(9 - i), (long)this.map.size());
        }
    }

    @Test
    public void testIsEmpty() throws Exception {
        Assert.assertTrue((String)"Map should be empty", (boolean)this.map.isEmpty());
        this.map.put((Object)1, (Object)1);
        Assert.assertFalse((String)"Map shouldn't be empty.", (boolean)this.map.isEmpty());
        this.map.remove((Object)1);
        Assert.assertTrue((String)"Map should be empty", (boolean)this.map.isEmpty());
    }

    @Test
    public void testContains() throws Exception {
        for (int i = 0; i < 10; ++i) {
            Assert.assertFalse((String)"Map should not contain the key", (boolean)this.map.containsKey((Object)i));
            Assert.assertFalse((String)"Map should not contain the value", (boolean)this.map.containsValue((Object)i));
            this.map.put((Object)i, (Object)i);
            Assert.assertTrue((String)"Map should contain the key", (boolean)this.map.containsKey((Object)i));
            Assert.assertTrue((String)"Map should contain the value", (boolean)this.map.containsValue((Object)i));
        }
    }

    @Test
    public void testGet() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.map.put((Object)i, (Object)i);
            for (int j = 0; j <= i; ++j) {
                Assert.assertEquals((String)"The value was wrong.", (Object)j, (Object)this.map.get((Object)j));
            }
        }
        Assert.assertNull((String)"Null return value for nonexistent keys.", (Object)this.map.get((Object)10));
    }

    @Test
    public void testPutAll() throws Exception {
        HashMap testMap = Maps.newHashMap();
        this.fillMap(10);
        this.map.putAll((Map)testMap);
        for (int i = 0; i < 10; ++i) {
            Assert.assertTrue((String)"The map should contain the current 'i' value.", (boolean)this.map.containsKey((Object)i));
            Assert.assertTrue((String)"The map should contain the current 'i' value.", (boolean)this.map.containsValue((Object)i));
        }
    }

    @Test
    public void testClear() throws Exception {
        Assert.assertTrue((String)"Map was initialized incorrectly, should be empty.", (boolean)this.map.isEmpty());
        this.fillMap(10);
        Assert.assertFalse((String)"Map should contain entries now.", (boolean)this.map.isEmpty());
        this.map.clear();
        Assert.assertTrue((String)"Map should have been cleared of entries.", (boolean)this.map.isEmpty());
    }

    @Test
    public void testKeySet() throws Exception {
        this.fillMap(10);
        Set keys = this.map.keySet();
        for (int i = 0; i < 10; ++i) {
            Assert.assertTrue((String)"The key set doesn't contain all keys 0-9", (boolean)keys.contains(i));
        }
        Assert.assertEquals((String)"The key set has an incorrect number of entries", (long)10L, (long)keys.size());
    }

    @Test
    public void testValues() throws Exception {
        this.fillMap(10);
        Set values = (Set)this.map.values();
        for (int i = 0; i < 10; ++i) {
            Assert.assertTrue((String)"The key set doesn't contain all keys 0-9", (boolean)values.contains(i));
        }
        Assert.assertEquals((String)"The key set has an incorrect number of entries", (long)10L, (long)values.size());
    }

    @Test
    public void testEntrySet() throws Exception {
        this.fillMap(10);
        Set entries = this.map.entrySet();
        for (int i = 0; i < 10; ++i) {
            Assert.assertTrue((String)"The key set doesn't contain all keys 0-9", (boolean)entries.contains(Maps.immutableEntry((Object)i, (Object)i)));
        }
        Assert.assertEquals((String)"The key set has an incorrect number of entries", (long)10L, (long)entries.size());
    }

    @Test
    public void testPut() throws Exception {
        this.fillMap(10);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((String)"Put should return the previous value", (Object)i, (Object)this.map.put((Object)i, (Object)(i + 1)));
        }
        Assert.assertNull((Object)this.map.put((Object)11, (Object)11));
    }

    private void fillMap(int numEntries) {
        for (int i = 0; i < numEntries; ++i) {
            this.map.put((Object)i, (Object)i);
        }
    }
}

