/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.persistence.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.persistence.impl.MapDBTest;
import org.onosproject.persistence.impl.PersistentSet;
import org.onosproject.store.service.Serializer;

public class PersistentSetTest
extends MapDBTest {
    private PersistentSet<Integer> set = null;

    @Before
    public void setUp() throws Exception {
        this.set = new PersistentSet(new Serializer(){

            public <T> byte[] encode(T object) {
                if (object == null) {
                    return null;
                }
                int num = (Integer)object;
                byte[] result = new byte[]{(byte)(num >> 24), (byte)(num >> 16), (byte)(num >> 8), (byte)num};
                return result;
            }

            public <T> T decode(byte[] bytes) {
                if (bytes == null) {
                    return null;
                }
                int num = 0;
                num |= bytes[0] << 24;
                num |= bytes[1] << 16;
                num |= bytes[2] << 8;
                return (T)Integer.valueOf(num |= bytes[3]);
            }
        }, this.fakeDB, "set");
    }

    @Test
    public void testSize() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.set.add((Object)i);
            Assert.assertEquals((String)"The set should have i + 1 entries.", (long)(i + 1), (long)this.set.size());
        }
    }

    @Test
    public void testIsEmpty() throws Exception {
        Assert.assertTrue((String)"The set should be initialized empty.", (boolean)this.set.isEmpty());
        this.fillSet(5, (Set<Integer>)this.set);
        Assert.assertFalse((String)"The set should no longer be empty.", (boolean)this.set.isEmpty());
        this.set.clear();
        Assert.assertTrue((String)"The set should have been cleared.", (boolean)this.set.isEmpty());
    }

    @Test
    public void testContains() throws Exception {
        Assert.assertFalse((String)"The set should not contain anything", (boolean)this.set.contains((Object)1));
        this.fillSet(10, (Set<Integer>)this.set);
        for (int i = 0; i < 10; ++i) {
            Assert.assertTrue((String)"The set should contain all values 0-9.", (boolean)this.set.contains((Object)i));
        }
    }

    @Test
    public void testIterator() throws Exception {
        HashSet validationSet = Sets.newHashSet();
        this.fillSet(10, (Set<Integer>)this.set);
        this.fillSet(10, validationSet);
        this.set.iterator().forEachRemaining(item -> Assert.assertTrue((String)"Items were mismatched.", (boolean)validationSet.remove(item)));
        Assert.assertTrue((String)"All entries in the validation set should have been removed.", (boolean)validationSet.isEmpty());
    }

    @Test
    public void testToArray() throws Exception {
        this.fillSet(10, (Set<Integer>)this.set);
        Object[] arr = this.set.toArray();
        Assert.assertEquals((String)"The array should be of length 10.", (long)10L, (long)arr.length);
        for (int i = 0; i < 10; ++i) {
            Assert.assertTrue((String)"All elements of the array should be in the set.", (boolean)this.set.contains(arr[i]));
        }
    }

    @Test
    public void testToArray1() throws Exception {
        Object[] originalArray = new Integer[9];
        this.fillSet(9, (Set<Integer>)this.set);
        Object[] retArray = this.set.toArray(originalArray);
        Assert.assertSame((String)"If the set can fit the array should be the one passed in.", (Object)originalArray, (Object)retArray);
        this.set.add((Object)9);
        Assert.assertNotEquals((String)"A new set should be generated if the contents will not fit in the passed set", (Object)this.set.toArray(originalArray), (Object)originalArray);
        this.set.clear();
        this.fillSet(5, (Set<Integer>)this.set);
        Assert.assertNull((String)"The character one after last should be null if the array is larger than the set.", (Object)((Integer[])this.set.toArray(originalArray))[5]);
    }

    @Test
    public void testAdd() throws Exception {
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((String)"The size of the set is wrong.", (long)i, (long)this.set.size());
            Assert.assertTrue((String)"The first add of an element should be true.", (boolean)this.set.add((Object)i));
            Assert.assertFalse((String)"The second add of an element should be false.", (boolean)this.set.add((Object)i));
        }
    }

    @Test
    public void testRemove() throws Exception {
        this.fillSet(10, (Set<Integer>)this.set);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((String)"The size of the set is wrong.", (long)(10 - i), (long)this.set.size());
            Assert.assertTrue((String)"The first removal should be true.", (boolean)this.set.remove((Object)i));
            Assert.assertFalse((String)"The second removal should be false (item no longer contained).", (boolean)this.set.remove((Object)i));
        }
        Assert.assertTrue((String)"All elements should have been removed.", (boolean)this.set.isEmpty());
    }

    @Test
    public void testContainsAll() throws Exception {
        HashSet integersToCheck = Sets.newHashSet();
        this.fillSet(10, integersToCheck);
        this.fillSet(10, (Set<Integer>)this.set);
        Assert.assertTrue((String)"The sets should be identical so mutual subsets.", (boolean)this.set.containsAll((Collection)integersToCheck));
        this.set.remove((Object)9);
        Assert.assertFalse((String)"The set should contain one fewer value.", (boolean)this.set.containsAll((Collection)integersToCheck));
    }

    @Test
    public void testAddAll() throws Exception {
        HashSet integersToCheck = Sets.newHashSet();
        this.fillSet(10, integersToCheck);
        Assert.assertFalse((String)"Set should be empty and so integers to check should not be a subset.", (boolean)this.set.containsAll((Collection)integersToCheck));
        Assert.assertTrue((String)"The set should have changed as a result of add all.", (boolean)this.set.addAll((Collection)integersToCheck));
        Assert.assertFalse((String)"The set should not have changed as a result of add all a second time.", (boolean)this.set.addAll((Collection)integersToCheck));
        Assert.assertTrue((String)"The sets should now be equivalent.", (boolean)this.set.containsAll((Collection)integersToCheck));
        Assert.assertTrue((String)"The sets should now be equivalent.", (boolean)integersToCheck.containsAll((Collection<?>)this.set));
    }

    @Test
    public void testRetainAll() throws Exception {
        HashSet retainSet = Sets.newHashSet();
        this.fillSet(10, (Set<Integer>)this.set);
        Assert.assertTrue((String)"The set should have changed.", (boolean)this.set.retainAll((Collection)retainSet));
        Assert.assertTrue((String)"The set should have been emptied.", (boolean)this.set.isEmpty());
        this.fillSet(10, (Set<Integer>)this.set);
        this.fillSet(10, retainSet);
        HashSet<Integer> duplicateSet = new HashSet<Integer>((Collection<Integer>)this.set);
        Assert.assertFalse((String)"The set should not have changed.", (boolean)this.set.retainAll((Collection)retainSet));
        Assert.assertEquals((String)"The set should be the same as the duplicate.", duplicateSet, this.set);
        retainSet.remove(9);
        Assert.assertTrue((String)"The set should have changed.", (boolean)this.set.retainAll((Collection)retainSet));
        duplicateSet.remove(9);
        Assert.assertEquals((String)"The set should have had the nine element removed.", duplicateSet, this.set);
    }

    @Test
    public void testRemoveAll() throws Exception {
        HashSet removeSet = Sets.newHashSet();
        this.fillSet(10, (Set<Integer>)this.set);
        HashSet duplicateSet = Sets.newHashSet(this.set);
        Assert.assertFalse((String)"No elements should change.", (boolean)this.set.removeAll((Collection)removeSet));
        Assert.assertEquals((String)"Set should not have diverged from the duplicate.", (Object)duplicateSet, this.set);
        this.fillSet(5, removeSet);
        Assert.assertTrue((String)"Elements should have been removed.", (boolean)this.set.removeAll((Collection)removeSet));
        Assert.assertNotEquals((String)"Duplicate set should no longer be equivalent.", (Object)duplicateSet, this.set);
        Assert.assertEquals((String)"Five elements should have been removed from set.", (long)5L, (long)this.set.size());
        for (Integer item : removeSet) {
            Assert.assertFalse((String)"No element of remove set should remain.", (boolean)this.set.contains((Object)item));
        }
    }

    @Test
    public void testClear() throws Exception {
        Assert.assertTrue((String)"The set should be initialized empty.", (boolean)this.set.isEmpty());
        this.set.clear();
        Assert.assertTrue((String)"Clear should have no effect on an empty set.", (boolean)this.set.isEmpty());
        this.fillSet(10, (Set<Integer>)this.set);
        Assert.assertFalse((String)"The set should no longer be empty.", (boolean)this.set.isEmpty());
        this.set.clear();
        Assert.assertTrue((String)"The set should be empty after clear.", (boolean)this.set.isEmpty());
    }

    private void fillSet(int numEntries, Set<Integer> set) {
        Preconditions.checkNotNull(set);
        for (int i = 0; i < numEntries; ++i) {
            set.add(i);
        }
    }
}

