/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.persistence.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mapdb.DB;
import org.mapdb.Hasher;
import org.onosproject.store.service.Serializer;

public class PersistentMap<K, V>
implements Map<K, V> {
    private final Serializer serializer;
    private final DB database;
    private final Map<byte[], byte[]> items;
    private final String name;

    public PersistentMap(Serializer serializer, DB database, String name) {
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer);
        this.database = (DB)Preconditions.checkNotNull((Object)database);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.items = database.createHashMap(name).keySerializer(org.mapdb.Serializer.BYTE_ARRAY).valueSerializer(org.mapdb.Serializer.BYTE_ARRAY).hasher(Hasher.BYTE_ARRAY).makeOrGet();
    }

    public void readInto(Map<K, V> items) {
        this.items.forEach((keyBytes, valueBytes) -> items.put(this.serializer.decode(keyBytes), this.serializer.decode(valueBytes)));
    }

    @Override
    public V remove(Object key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key can not be null.");
        V removed = this.get(key);
        this.items.remove(this.serializer.encode(key));
        return removed;
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null.");
        return this.items.containsKey(this.serializer.encode(key));
    }

    @Override
    public boolean containsValue(Object value) {
        Preconditions.checkNotNull((Object)value, (Object)"Value cannot be null.");
        byte[] serialized = this.serializer.encode(value);
        for (byte[] compareValue : this.items.values()) {
            boolean same = true;
            if (compareValue == null) {
                same = false;
            } else if (compareValue.length != serialized.length) {
                same = false;
            } else {
                for (int i = 0; i < serialized.length; ++i) {
                    if (serialized[i] == compareValue[i]) continue;
                    same = false;
                    break;
                }
            }
            if (!same) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null.");
        byte[] bytes = this.items.get(this.serializer.encode(key));
        return (V)(bytes == null ? null : this.serializer.decode(bytes));
    }

    @Override
    public V put(K key, V value) {
        Preconditions.checkNotNull(key, (Object)"Key cannot be null.");
        Preconditions.checkNotNull(value, (Object)"Value cannot be null.");
        byte[] prevVal = this.items.put(this.serializer.encode(key), this.serializer.encode(value));
        if (prevVal == null) {
            return null;
        }
        return (V)this.serializer.decode(prevVal);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Preconditions.checkNotNull(m, (Object)"The passed in map cannot be null.");
        m.forEach((k, v) -> this.items.put(this.serializer.encode(k), this.serializer.encode(v)));
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    @Override
    public Set<K> keySet() {
        HashSet keys = Sets.newHashSet();
        this.items.keySet().forEach((? super T k) -> keys.add(this.serializer.decode(k)));
        return keys;
    }

    @Override
    public Collection<V> values() {
        HashSet values = Sets.newHashSet();
        this.items.values().forEach((? super T v) -> values.add(this.serializer.decode(v)));
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet entries = Sets.newHashSet();
        this.items.entrySet().forEach((? super T e) -> entries.add(Maps.immutableEntry((Object)this.serializer.decode((byte[])e.getKey()), (Object)this.serializer.decode((byte[])e.getValue()))));
        return entries;
    }

    @Override
    public boolean equals(Object map) {
        if (!(map instanceof Map)) {
            return false;
        }
        Map asMap = (Map)map;
        if (this.size() != asMap.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry : this.entrySet()) {
            K key = entry.getKey();
            if (asMap.containsKey(key) && asMap.get(key).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

