/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.persistence.impl;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.mapdb.DB;
import org.onosproject.persistence.PersistentMapBuilder;
import org.onosproject.persistence.impl.PersistentMap;
import org.onosproject.store.service.Serializer;

public class DefaultPersistentMapBuilder<K, V>
implements PersistentMapBuilder<K, V> {
    private final DB localDB;
    private String name = null;
    private Serializer serializer = null;

    public DefaultPersistentMapBuilder(DB localDB) {
        Preconditions.checkNotNull((Object)localDB, (Object)"The local database cannot be null.");
        this.localDB = localDB;
    }

    public PersistentMapBuilder<K, V> withName(String name) {
        this.name = "map:" + (String)Preconditions.checkNotNull((Object)name);
        return this;
    }

    public PersistentMapBuilder<K, V> withSerializer(Serializer serializer) {
        Preconditions.checkArgument((this.serializer == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)serializer);
        this.serializer = serializer;
        return this;
    }

    public Map<K, V> build() {
        Preconditions.checkNotNull((Object)this.name, (Object)"The name must be assigned.");
        Preconditions.checkNotNull((Object)this.serializer, (Object)"The key serializer must be assigned.");
        return new PersistentMap(this.serializer, this.localDB, this.name);
    }
}

