/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.persistence.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.mapdb.DB;
import org.mapdb.Hasher;
import org.onosproject.store.service.Serializer;

public class PersistentSet<E>
implements Set<E> {
    private final Serializer serializer;
    private final DB database;
    private final Set<byte[]> items;
    private final String name;

    public PersistentSet(Serializer serializer, DB database, String name) {
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer);
        this.database = (DB)Preconditions.checkNotNull((Object)database);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.items = database.createHashSet(name).serializer(org.mapdb.Serializer.BYTE_ARRAY).hasher(Hasher.BYTE_ARRAY).makeOrGet();
    }

    public void readInto(Set<E> items) {
        this.items.forEach(item -> items.add(this.serializer.decode(item)));
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        Preconditions.checkNotNull((Object)o, (Object)"The argument cannot be null");
        return this.items.contains(this.serializer.encode(o));
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.transform(this.items.iterator(), arg_0 -> ((Serializer)this.serializer).decode(arg_0));
    }

    @Override
    public Object[] toArray() {
        Object[] retArray = new Object[this.items.size()];
        int index = 0;
        for (byte[] item : this.items) {
            retArray[index] = this.serializer.decode(item);
            ++index;
        }
        return retArray;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Preconditions.checkNotNull(a, (Object)"The passed in array cannot be null.");
        int index = 0;
        Iterator<byte[]> iterator = this.items.iterator();
        Object[] retArray = a.length >= this.items.size() ? a : new Object[this.items.size()];
        while (iterator.hasNext()) {
            retArray[index++] = this.serializer.decode(iterator.next());
        }
        if (retArray.length > this.items.size()) {
            retArray[index] = null;
        }
        return retArray;
    }

    @Override
    public boolean add(E item) {
        Preconditions.checkNotNull(item, (Object)"Item to be added cannot be null.");
        return this.items.add(this.serializer.encode(item));
    }

    @Override
    public boolean remove(Object o) {
        Preconditions.checkNotNull((Object)o, (Object)"Item to be removed cannot be null.");
        return this.items.remove(this.serializer.encode(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Preconditions.checkNotNull(c, (Object)"Collection cannot be internal.");
        for (Object item : c) {
            if (this.items.contains(this.serializer.encode(item))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Preconditions.checkNotNull(c, (Object)"The collection to be added cannot be null.");
        boolean changed = false;
        for (E item : c) {
            changed = this.items.add(this.serializer.encode(item)) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        for (byte[] item : this.items) {
            Object deserialized = this.serializer.decode(item);
            if (c.contains(deserialized)) continue;
            changed = this.items.remove(item) || changed;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object item : c) {
            changed = this.items.remove(this.serializer.encode(item)) || changed;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    @Override
    public boolean equals(Object set) {
        if (!(set instanceof Set)) {
            return false;
        }
        Set asSet = (Set)set;
        if (asSet.size() != this.size()) {
            return false;
        }
        for (E item : this) {
            if (asSet.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

