/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.AbstractEvent;
import org.onosproject.persistence.PersistenceService;
import org.onosproject.store.LogicalTimestamp;
import org.onosproject.store.Timestamp;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterCommunicationServiceAdapter;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.persistence.TestPersistenceService;
import org.onosproject.store.primitives.impl.AntiEntropyAdvertisement;
import org.onosproject.store.primitives.impl.EventuallyConsistentMapBuilderImpl;
import org.onosproject.store.primitives.impl.MapValue;
import org.onosproject.store.primitives.impl.UpdateEntry;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.KryoSerializer;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.WallClockTimestamp;

public class EventuallyConsistentMapImplTest {
    private EventuallyConsistentMap<String, String> ecMap;
    private PersistenceService persistenceService;
    private ClusterService clusterService;
    private ClusterCommunicationService clusterCommunicator;
    private SequentialClockService<String, String> clockService;
    private static final String MAP_NAME = "test";
    private static final MessageSubject UPDATE_MESSAGE_SUBJECT = new MessageSubject("ecm-test-update");
    private static final MessageSubject ANTI_ENTROPY_MESSAGE_SUBJECT = new MessageSubject("ecm-test-anti-entropy");
    private static final String KEY1 = "one";
    private static final String KEY2 = "two";
    private static final String VALUE1 = "oneValue";
    private static final String VALUE2 = "twoValue";
    private final ControllerNode self = new DefaultControllerNode(new NodeId("local"), IpAddress.valueOf((int)1));
    private Consumer<Collection<UpdateEntry<String, String>>> updateHandler;
    private Consumer<AntiEntropyAdvertisement<String>> antiEntropyHandler;
    private static final KryoSerializer SERIALIZER = new KryoSerializer(){

        protected void setupKryoPool() {
            this.serializerPool = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{TestTimestamp.class}).register(new Class[]{LogicalTimestamp.class}).register(new Class[]{WallClockTimestamp.class}).register(new Class[]{ArrayList.class}).register(new Class[]{AntiEntropyAdvertisement.class}).register(new Class[]{HashMap.class}).register(new Class[]{Optional.class}).build();
        }
    };

    @Before
    public void setUp() throws Exception {
        this.clusterService = (ClusterService)EasyMock.createMock(ClusterService.class);
        EasyMock.expect((Object)this.clusterService.getLocalNode()).andReturn((Object)this.self).anyTimes();
        EasyMock.expect((Object)this.clusterService.getNodes()).andReturn((Object)ImmutableSet.of((Object)this.self)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clusterService});
        this.clusterCommunicator = (ClusterCommunicationService)EasyMock.createMock(ClusterCommunicationService.class);
        this.persistenceService = new TestPersistenceService();
        this.clusterCommunicator.addSubscriber((MessageSubject)EasyMock.anyObject(MessageSubject.class), (Function)EasyMock.anyObject(Function.class), (Consumer)EasyMock.anyObject(Consumer.class), (Executor)EasyMock.anyObject(Executor.class));
        EasyMock.expectLastCall().andDelegateTo((Object)new TestClusterCommunicationService()).times(2);
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        this.clockService = new SequentialClockService();
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{TestTimestamp.class});
        this.ecMap = new EventuallyConsistentMapBuilderImpl(this.clusterService, this.clusterCommunicator, this.persistenceService).withName(MAP_NAME).withSerializer(serializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp((String)k, (String)v)).withCommunicationExecutor((ExecutorService)MoreExecutors.newDirectExecutorService()).withPersistence().build();
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
    }

    @After
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
        this.ecMap.destroy();
    }

    private EventuallyConsistentMapListener<String, String> getListener() {
        return (EventuallyConsistentMapListener)EasyMock.createMock(EventuallyConsistentMapListener.class);
    }

    @Test
    public void testSize() throws Exception {
        this.expectPeerMessage(this.clusterCommunicator);
        Assert.assertEquals((long)0L, (long)this.ecMap.size());
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        Assert.assertEquals((long)1L, (long)this.ecMap.size());
        this.ecMap.put((Object)KEY1, (Object)VALUE2);
        Assert.assertEquals((long)1L, (long)this.ecMap.size());
        this.ecMap.put((Object)KEY2, (Object)VALUE2);
        Assert.assertEquals((long)2L, (long)this.ecMap.size());
        for (int i = 0; i < 10; ++i) {
            this.ecMap.put((Object)("" + i), (Object)("" + i));
        }
        Assert.assertEquals((long)12L, (long)this.ecMap.size());
        this.ecMap.remove((Object)KEY1);
        Assert.assertEquals((long)11L, (long)this.ecMap.size());
        this.ecMap.remove((Object)KEY1);
        Assert.assertEquals((long)11L, (long)this.ecMap.size());
    }

    @Test
    public void testIsEmpty() throws Exception {
        this.expectPeerMessage(this.clusterCommunicator);
        Assert.assertTrue((boolean)this.ecMap.isEmpty());
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        TestCase.assertFalse((boolean)this.ecMap.isEmpty());
        this.ecMap.remove((Object)KEY1);
        Assert.assertTrue((boolean)this.ecMap.isEmpty());
    }

    @Test
    public void testContainsKey() throws Exception {
        this.expectPeerMessage(this.clusterCommunicator);
        TestCase.assertFalse((boolean)this.ecMap.containsKey((Object)KEY1));
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        Assert.assertTrue((boolean)this.ecMap.containsKey((Object)KEY1));
        TestCase.assertFalse((boolean)this.ecMap.containsKey((Object)KEY2));
        this.ecMap.remove((Object)KEY1);
        TestCase.assertFalse((boolean)this.ecMap.containsKey((Object)KEY1));
    }

    @Test
    public void testContainsValue() throws Exception {
        this.expectPeerMessage(this.clusterCommunicator);
        TestCase.assertFalse((boolean)this.ecMap.containsValue((Object)VALUE1));
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        Assert.assertTrue((boolean)this.ecMap.containsValue((Object)VALUE1));
        TestCase.assertFalse((boolean)this.ecMap.containsValue((Object)VALUE2));
        this.ecMap.put((Object)KEY1, (Object)VALUE2);
        TestCase.assertFalse((boolean)this.ecMap.containsValue((Object)VALUE1));
        Assert.assertTrue((boolean)this.ecMap.containsValue((Object)VALUE2));
        this.ecMap.remove((Object)KEY1);
        TestCase.assertFalse((boolean)this.ecMap.containsValue((Object)VALUE2));
    }

    @Test
    public void testGet() throws Exception {
        this.expectPeerMessage(this.clusterCommunicator);
        Assert.assertNull((Object)this.ecMap.get((Object)KEY1));
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        Assert.assertEquals((Object)VALUE1, (Object)this.ecMap.get((Object)KEY1));
        ImmutableList message = ImmutableList.of(this.generatePutMessage(KEY2, VALUE2, this.clockService.getTimestamp(KEY2, VALUE2)));
        CountDownLatch latch = new CountDownLatch(1);
        this.ecMap.addListener((EventuallyConsistentMapListener)new TestListener(latch));
        Assert.assertNull((Object)this.ecMap.get((Object)KEY2));
        this.updateHandler.accept((Collection<UpdateEntry<String, String>>)message);
        Assert.assertTrue((String)"External listener never got notified of internal event", (boolean)latch.await(100L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)VALUE2, (Object)this.ecMap.get((Object)KEY2));
        this.ecMap.remove((Object)KEY2);
        Assert.assertNull((Object)this.ecMap.get((Object)KEY2));
        message = ImmutableList.of(this.generateRemoveMessage(KEY1, this.clockService.getTimestamp(KEY1, VALUE1)));
        latch = new CountDownLatch(1);
        this.ecMap.addListener((EventuallyConsistentMapListener)new TestListener(latch));
        this.updateHandler.accept((Collection<UpdateEntry<String, String>>)message);
        Assert.assertTrue((String)"External listener never got notified of internal event", (boolean)latch.await(100L, TimeUnit.MILLISECONDS));
        Assert.assertNull((Object)this.ecMap.get((Object)KEY1));
    }

    @Test
    public void testPut() throws Exception {
        EventuallyConsistentMapListener<String, String> listener = this.getListener();
        listener.event(new EventuallyConsistentMapEvent(MAP_NAME, EventuallyConsistentMapEvent.Type.PUT, (Object)KEY1, (Object)VALUE1));
        listener.event(new EventuallyConsistentMapEvent(MAP_NAME, EventuallyConsistentMapEvent.Type.PUT, (Object)KEY1, (Object)VALUE2));
        EasyMock.replay((Object[])new Object[]{listener});
        this.ecMap.addListener(listener);
        EventuallyConsistentMapImplTest.expectSpecificMulticastMessage(this.generatePutMessage(KEY1, VALUE1, this.clockService.peekAtNextTimestamp()), UPDATE_MESSAGE_SUBJECT, this.clusterCommunicator);
        Assert.assertNull((Object)this.ecMap.get((Object)KEY1));
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        Assert.assertEquals((Object)VALUE1, (Object)this.ecMap.get((Object)KEY1));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EventuallyConsistentMapImplTest.expectSpecificMulticastMessage(this.generatePutMessage(KEY1, VALUE2, this.clockService.peekAtNextTimestamp()), UPDATE_MESSAGE_SUBJECT, this.clusterCommunicator);
        this.ecMap.put((Object)KEY1, (Object)VALUE2);
        Assert.assertEquals((Object)VALUE2, (Object)this.ecMap.get((Object)KEY1));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        this.clockService.turnBackTime();
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        Assert.assertEquals((Object)VALUE2, (Object)this.ecMap.get((Object)KEY1));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testRemove() throws Exception {
        EventuallyConsistentMapListener<String, String> listener = this.getListener();
        listener.event(new EventuallyConsistentMapEvent(MAP_NAME, EventuallyConsistentMapEvent.Type.REMOVE, (Object)KEY1, (Object)VALUE1));
        listener.event(new EventuallyConsistentMapEvent(MAP_NAME, EventuallyConsistentMapEvent.Type.PUT, (Object)KEY1, (Object)VALUE1));
        listener.event(new EventuallyConsistentMapEvent(MAP_NAME, EventuallyConsistentMapEvent.Type.PUT, (Object)KEY2, (Object)VALUE2));
        EasyMock.replay((Object[])new Object[]{listener});
        this.ecMap.addListener(listener);
        this.expectPeerMessage(this.clusterCommunicator);
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        Assert.assertEquals((Object)VALUE1, (Object)this.ecMap.get((Object)KEY1));
        EventuallyConsistentMapImplTest.expectSpecificMulticastMessage(this.generateRemoveMessage(KEY1, this.clockService.peekAtNextTimestamp()), UPDATE_MESSAGE_SUBJECT, this.clusterCommunicator);
        this.ecMap.remove((Object)KEY1);
        Assert.assertNull((Object)this.ecMap.get((Object)KEY1));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EventuallyConsistentMapImplTest.expectSpecificMulticastMessage(this.generateRemoveMessage(KEY1, this.clockService.peekAtNextTimestamp()), UPDATE_MESSAGE_SUBJECT, this.clusterCommunicator);
        this.ecMap.remove((Object)KEY1);
        Assert.assertNull((Object)this.ecMap.get((Object)KEY1));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        this.expectPeerMessage(this.clusterCommunicator);
        this.ecMap.put((Object)KEY2, (Object)VALUE2);
        this.clockService.turnBackTime();
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        this.ecMap.remove((Object)KEY2);
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testCompute() throws Exception {
        EventuallyConsistentMapListener<String, String> listener = this.getListener();
        listener.event(new EventuallyConsistentMapEvent(MAP_NAME, EventuallyConsistentMapEvent.Type.PUT, (Object)KEY1, (Object)VALUE1));
        listener.event(new EventuallyConsistentMapEvent(MAP_NAME, EventuallyConsistentMapEvent.Type.REMOVE, (Object)KEY1, (Object)VALUE1));
        listener.event(new EventuallyConsistentMapEvent(MAP_NAME, EventuallyConsistentMapEvent.Type.PUT, (Object)KEY2, (Object)VALUE2));
        EasyMock.replay((Object[])new Object[]{listener});
        this.ecMap.addListener(listener);
        this.expectPeerMessage(this.clusterCommunicator);
        this.ecMap.compute((Object)KEY1, (k, v) -> VALUE1);
        Assert.assertEquals((Object)VALUE1, (Object)this.ecMap.get((Object)KEY1));
        EventuallyConsistentMapImplTest.expectSpecificMulticastMessage(this.generateRemoveMessage(KEY1, this.clockService.peekAtNextTimestamp()), UPDATE_MESSAGE_SUBJECT, this.clusterCommunicator);
        this.ecMap.compute((Object)KEY1, (k, v) -> null);
        Assert.assertNull((Object)this.ecMap.get((Object)KEY1));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EventuallyConsistentMapImplTest.expectSpecificMulticastMessage(this.generateRemoveMessage(KEY1, this.clockService.peekAtNextTimestamp()), UPDATE_MESSAGE_SUBJECT, this.clusterCommunicator);
        this.ecMap.compute((Object)KEY1, (k, v) -> null);
        Assert.assertNull((Object)this.ecMap.get((Object)KEY1));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        this.expectPeerMessage(this.clusterCommunicator);
        this.ecMap.compute((Object)KEY2, (k, v) -> VALUE2);
        this.clockService.turnBackTime();
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        this.ecMap.compute((Object)KEY2, (k, v) -> null);
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testPutAll() throws Exception {
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        this.ecMap.putAll(new HashMap());
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EventuallyConsistentMapListener<String, String> listener = this.getListener();
        listener.event(new EventuallyConsistentMapEvent(MAP_NAME, EventuallyConsistentMapEvent.Type.PUT, (Object)KEY1, (Object)VALUE1));
        listener.event(new EventuallyConsistentMapEvent(MAP_NAME, EventuallyConsistentMapEvent.Type.PUT, (Object)KEY2, (Object)VALUE2));
        EasyMock.replay((Object[])new Object[]{listener});
        this.ecMap.addListener(listener);
        EventuallyConsistentMapImplTest.expectSpecificBroadcastMessage(this.generatePutMessage(KEY1, VALUE1, KEY2, VALUE2), UPDATE_MESSAGE_SUBJECT, this.clusterCommunicator);
        HashMap<String, String> putAllValues = new HashMap<String, String>();
        putAllValues.put(KEY1, VALUE1);
        putAllValues.put(KEY2, VALUE2);
        this.ecMap.putAll(putAllValues);
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testClear() throws Exception {
        EventuallyConsistentMapListener<String, String> listener = this.getListener();
        listener.event(new EventuallyConsistentMapEvent(MAP_NAME, EventuallyConsistentMapEvent.Type.REMOVE, (Object)KEY1, (Object)VALUE1));
        listener.event(new EventuallyConsistentMapEvent(MAP_NAME, EventuallyConsistentMapEvent.Type.REMOVE, (Object)KEY2, (Object)VALUE2));
        EasyMock.replay((Object[])new Object[]{listener});
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        Assert.assertTrue((boolean)this.ecMap.isEmpty());
        this.ecMap.clear();
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        this.expectPeerMessage(this.clusterCommunicator);
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        this.ecMap.put((Object)KEY2, (Object)VALUE2);
        this.ecMap.addListener(listener);
        EventuallyConsistentMapImplTest.expectSpecificBroadcastMessage(this.generateRemoveMessage(KEY1, KEY2), UPDATE_MESSAGE_SUBJECT, this.clusterCommunicator);
        this.ecMap.clear();
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testKeySet() throws Exception {
        this.expectPeerMessage(this.clusterCommunicator);
        Assert.assertTrue((boolean)this.ecMap.keySet().isEmpty());
        HashSet<String> keys = new HashSet<String>();
        for (int i = 1; i <= 10; ++i) {
            keys.add("" + i);
        }
        keys.forEach(k -> this.ecMap.put(k, (Object)("value" + k)));
        Assert.assertEquals(keys, (Object)this.ecMap.keySet());
        this.ecMap.put(keys.iterator().next(), (Object)"new-value");
        Assert.assertEquals(keys, (Object)this.ecMap.keySet());
        String removeKey = (String)keys.iterator().next();
        keys.remove(removeKey);
        this.ecMap.remove((Object)removeKey);
        Assert.assertEquals(keys, (Object)this.ecMap.keySet());
    }

    @Test
    public void testValues() throws Exception {
        this.expectPeerMessage(this.clusterCommunicator);
        Assert.assertTrue((boolean)this.ecMap.values().isEmpty());
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        for (int i = 1; i <= 10; ++i) {
            expectedValues.put("" + i, "value" + i);
        }
        expectedValues.entrySet().forEach(e -> this.ecMap.put(e.getKey(), e.getValue()));
        Assert.assertEquals((long)expectedValues.values().size(), (long)this.ecMap.values().size());
        expectedValues.values().forEach(v -> Assert.assertTrue((boolean)this.ecMap.values().contains(v)));
        Map.Entry first = expectedValues.entrySet().iterator().next();
        expectedValues.put((String)first.getKey(), "new-value");
        this.ecMap.put(first.getKey(), (Object)"new-value");
        Assert.assertEquals((long)expectedValues.values().size(), (long)this.ecMap.values().size());
        expectedValues.values().forEach(v -> Assert.assertTrue((boolean)this.ecMap.values().contains(v)));
        String removeKey = (String)expectedValues.keySet().iterator().next();
        expectedValues.remove(removeKey);
        this.ecMap.remove((Object)removeKey);
        Assert.assertEquals((long)expectedValues.values().size(), (long)this.ecMap.values().size());
        expectedValues.values().forEach(v -> Assert.assertTrue((boolean)this.ecMap.values().contains(v)));
    }

    @Test
    public void testEntrySet() throws Exception {
        this.expectPeerMessage(this.clusterCommunicator);
        Assert.assertTrue((boolean)this.ecMap.entrySet().isEmpty());
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        for (int i = 1; i <= 10; ++i) {
            expectedValues.put("" + i, "value" + i);
        }
        expectedValues.entrySet().forEach(e -> this.ecMap.put(e.getKey(), e.getValue()));
        Assert.assertTrue((boolean)EventuallyConsistentMapImplTest.entrySetsAreEqual(expectedValues, this.ecMap.entrySet()));
        Map.Entry first = expectedValues.entrySet().iterator().next();
        expectedValues.put((String)first.getKey(), "new-value");
        this.ecMap.put(first.getKey(), (Object)"new-value");
        Assert.assertTrue((boolean)EventuallyConsistentMapImplTest.entrySetsAreEqual(expectedValues, this.ecMap.entrySet()));
        String removeKey = (String)expectedValues.keySet().iterator().next();
        expectedValues.remove(removeKey);
        this.ecMap.remove((Object)removeKey);
        Assert.assertTrue((boolean)EventuallyConsistentMapImplTest.entrySetsAreEqual(expectedValues, this.ecMap.entrySet()));
    }

    private static boolean entrySetsAreEqual(Map<String, String> expectedMap, Set<Map.Entry<String, String>> actual) {
        if (expectedMap.entrySet().size() != actual.size()) {
            return false;
        }
        for (Map.Entry<String, String> e : actual) {
            if (!expectedMap.containsKey(e.getKey())) {
                return false;
            }
            if (Objects.equals(expectedMap.get(e.getKey()), e.getValue())) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testDestroy() throws Exception {
        this.clusterCommunicator.removeSubscriber(UPDATE_MESSAGE_SUBJECT);
        this.clusterCommunicator.removeSubscriber(ANTI_ENTROPY_MESSAGE_SUBJECT);
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        this.ecMap.destroy();
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        try {
            this.ecMap.get((Object)KEY1);
            Assert.fail((String)"get after destroy should throw exception");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            this.ecMap.put((Object)KEY1, (Object)VALUE1);
            Assert.fail((String)"put after destroy should throw exception");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    private UpdateEntry<String, String> generatePutMessage(String key, String value, Timestamp timestamp) {
        return new UpdateEntry((Object)key, new MapValue((Object)value, timestamp));
    }

    private List<UpdateEntry<String, String>> generatePutMessage(String key1, String value1, String key2, String value2) {
        ArrayList<UpdateEntry<String, String>> list = new ArrayList<UpdateEntry<String, String>>();
        Timestamp timestamp1 = this.clockService.peek(1);
        Timestamp timestamp2 = this.clockService.peek(2);
        list.add(this.generatePutMessage(key1, value1, timestamp1));
        list.add(this.generatePutMessage(key2, value2, timestamp2));
        return list;
    }

    private UpdateEntry<String, String> generateRemoveMessage(String key, Timestamp timestamp) {
        return new UpdateEntry((Object)key, new MapValue(null, timestamp));
    }

    private List<UpdateEntry<String, String>> generateRemoveMessage(String key1, String key2) {
        ArrayList<UpdateEntry<String, String>> list = new ArrayList<UpdateEntry<String, String>>();
        Timestamp timestamp1 = this.clockService.peek(1);
        Timestamp timestamp2 = this.clockService.peek(2);
        list.add(this.generateRemoveMessage(key1, timestamp1));
        list.add(this.generateRemoveMessage(key2, timestamp2));
        return list;
    }

    private static <T> void expectSpecificBroadcastMessage(T message, MessageSubject subject, ClusterCommunicationService clusterCommunicator) {
        EasyMock.reset((Object[])new Object[]{clusterCommunicator});
        clusterCommunicator.multicast(EasyMock.eq(message), (MessageSubject)EasyMock.eq((Object)subject), (Function)EasyMock.anyObject(Function.class), (Set)EasyMock.anyObject(Set.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{clusterCommunicator});
    }

    private static <T> void expectSpecificMulticastMessage(T message, MessageSubject subject, ClusterCommunicationService clusterCommunicator) {
        EasyMock.reset((Object[])new Object[]{clusterCommunicator});
        clusterCommunicator.multicast(EasyMock.eq(message), (MessageSubject)EasyMock.eq((Object)subject), (Function)EasyMock.anyObject(Function.class), (Set)EasyMock.anyObject(Set.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{clusterCommunicator});
    }

    private <T> void expectPeerMessage(ClusterCommunicationService clusterCommunicator) {
        EasyMock.reset((Object[])new Object[]{clusterCommunicator});
        EasyMock.expect((Object)clusterCommunicator.unicast(EasyMock.anyObject(), (MessageSubject)EasyMock.anyObject(MessageSubject.class), (Function)EasyMock.anyObject(Function.class), (NodeId)EasyMock.anyObject(NodeId.class))).andReturn(CompletableFuture.completedFuture(null)).anyTimes();
        EasyMock.replay((Object[])new Object[]{clusterCommunicator});
    }

    private void expectBroadcastMessage(ClusterCommunicationService clusterCommunicator) {
        EasyMock.reset((Object[])new Object[]{clusterCommunicator});
        clusterCommunicator.multicast(EasyMock.anyObject(AbstractEvent.class), (MessageSubject)EasyMock.anyObject(MessageSubject.class), (Function)EasyMock.anyObject(Function.class), (Set)EasyMock.anyObject(Set.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{clusterCommunicator});
    }

    private class TestListener
    implements EventuallyConsistentMapListener<String, String> {
        private CountDownLatch latch;

        public TestListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void event(EventuallyConsistentMapEvent<String, String> event) {
            this.latch.countDown();
        }
    }

    private class TestTimestamp
    implements Timestamp {
        private final long timestamp;

        public TestTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public int compareTo(Timestamp o) {
            Preconditions.checkArgument((boolean)(o instanceof TestTimestamp));
            TestTimestamp otherTimestamp = (TestTimestamp)o;
            return ComparisonChain.start().compare(this.timestamp, otherTimestamp.timestamp).result();
        }
    }

    private class SequentialClockService<T, U> {
        private static final long INITIAL_VALUE = 1L;
        private final AtomicLong counter = new AtomicLong(1L);

        private SequentialClockService() {
        }

        public Timestamp getTimestamp(T object, U object2) {
            return new TestTimestamp(this.counter.getAndIncrement());
        }

        public Timestamp peekAtNextTimestamp() {
            return this.peek(1);
        }

        public Timestamp peek(int i) {
            Preconditions.checkArgument((i > 0 ? 1 : 0) != 0, (Object)"i must be a positive integer");
            return new TestTimestamp(this.counter.get() + (long)i - 1L);
        }

        public void turnBackTime() {
            this.counter.decrementAndGet();
            this.counter.decrementAndGet();
        }
    }

    private final class TestClusterCommunicationService
    extends ClusterCommunicationServiceAdapter {
        private TestClusterCommunicationService() {
        }

        public <M> void addSubscriber(MessageSubject subject, Function<byte[], M> decoder, Consumer<M> handler, Executor executor) {
            if (subject.equals((Object)UPDATE_MESSAGE_SUBJECT)) {
                EventuallyConsistentMapImplTest.this.updateHandler = handler;
            } else if (subject.equals((Object)ANTI_ENTROPY_MESSAGE_SUBJECT)) {
                EventuallyConsistentMapImplTest.this.antiEntropyHandler = handler;
            } else {
                throw new RuntimeException("Unexpected message subject " + subject.toString());
            }
        }
    }
}

