/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import junit.framework.TestCase;
import org.junit.Test;
import org.onosproject.store.primitives.impl.Result;

public class ResultTest {
    @Test
    public void testLocked() {
        Result r = Result.locked();
        TestCase.assertFalse((boolean)r.success());
        TestCase.assertNull((Object)r.value());
        TestCase.assertEquals((Object)Result.Status.LOCKED, (Object)r.status());
    }

    @Test
    public void testOk() {
        Result r = Result.ok((Object)"foo");
        TestCase.assertTrue((boolean)r.success());
        TestCase.assertEquals((String)"foo", (String)((String)r.value()));
        TestCase.assertEquals((Object)Result.Status.OK, (Object)r.status());
    }

    @Test
    public void testEquality() {
        Result r1 = Result.ok((Object)"foo");
        Result r2 = Result.locked();
        Result r3 = Result.ok((Object)"bar");
        Result r4 = Result.ok((Object)"foo");
        TestCase.assertTrue((boolean)r1.equals((Object)r4));
        TestCase.assertFalse((boolean)r1.equals((Object)r2));
        TestCase.assertFalse((boolean)r1.equals((Object)r3));
        TestCase.assertFalse((boolean)r2.equals((Object)r3));
    }
}

