/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import io.atomix.resource.ResourceType;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentMap;
import org.onosproject.store.primitives.resources.impl.AtomixTestBase;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.MapTransaction;
import org.onosproject.store.service.Versioned;

@Ignore
public class AtomixConsistentMapTest
extends AtomixTestBase {
    @Override
    protected ResourceType resourceType() {
        return new ResourceType(AtomixConsistentMap.class);
    }

    @Test
    public void testBasicMapOperations() throws Throwable {
        this.basicMapOperationTests(1);
        this.clearTests();
        this.basicMapOperationTests(2);
        this.clearTests();
        this.basicMapOperationTests(3);
    }

    @Test
    public void testMapComputeOperations() throws Throwable {
        this.mapComputeOperationTests(1);
        this.clearTests();
        this.mapComputeOperationTests(2);
        this.clearTests();
        this.mapComputeOperationTests(3);
    }

    @Test
    public void testMapListeners() throws Throwable {
        this.mapListenerTests(1);
        this.clearTests();
        this.mapListenerTests(2);
        this.clearTests();
        this.mapListenerTests(3);
    }

    @Test
    public void testTransactionCommit() throws Throwable {
        this.transactionCommitTests(1);
        this.clearTests();
        this.transactionCommitTests(2);
        this.clearTests();
        this.transactionCommitTests(3);
    }

    @Test
    public void testTransactionRollback() throws Throwable {
        this.transactionRollbackTests(1);
        this.clearTests();
        this.transactionRollbackTests(2);
        this.clearTests();
        this.transactionRollbackTests(3);
    }

    protected void basicMapOperationTests(int clusterSize) throws Throwable {
        this.createCopycatServers(clusterSize);
        byte[] rawFooValue = Tools.getBytesUtf8((String)"Hello foo!");
        byte[] rawBarValue = Tools.getBytesUtf8((String)"Hello bar!");
        AtomixConsistentMap map = (AtomixConsistentMap)this.createAtomixClient().get("test", AtomixConsistentMap.class).join();
        ((CompletableFuture)map.isEmpty().thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        ((CompletableFuture)map.put("foo", rawFooValue).thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertTrue((result == 1 ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.isEmpty().thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        ((CompletableFuture)map.putIfAbsent("foo", "Hello foo again!".getBytes()).thenAccept(result -> {
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)Arrays.equals((byte[])Versioned.valueOrElse((Versioned)result, null), rawFooValue));
        })).join();
        ((CompletableFuture)map.putIfAbsent("bar", rawBarValue).thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertTrue((result == 2 ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.keySet().thenAccept(result -> {
            Assert.assertTrue((result.size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)result.containsAll(Sets.newHashSet((Object[])new String[]{"foo", "bar"})));
        })).join();
        ((CompletableFuture)map.values().thenAccept(result -> {
            Assert.assertTrue((result.size() == 2 ? 1 : 0) != 0);
            List rawValues = result.stream().map(v -> Tools.toStringUtf8((byte[])((byte[])v.value()))).collect(Collectors.toList());
            Assert.assertTrue((boolean)rawValues.contains("Hello foo!"));
            Assert.assertTrue((boolean)rawValues.contains("Hello bar!"));
        })).join();
        ((CompletableFuture)map.entrySet().thenAccept(result -> Assert.assertTrue((result.size() == 2 ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.get("foo").thenAccept(result -> Assert.assertTrue((boolean)Arrays.equals((byte[])Versioned.valueOrElse((Versioned)result, null), rawFooValue)))).join();
        ((CompletableFuture)map.remove("foo").thenAccept(result -> Assert.assertTrue((boolean)Arrays.equals((byte[])Versioned.valueOrElse((Versioned)result, null), rawFooValue)))).join();
        ((CompletableFuture)map.containsKey("foo").thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        ((CompletableFuture)map.get("foo").thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.get("bar").thenAccept(result -> {
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)Arrays.equals((byte[])Versioned.valueOrElse((Versioned)result, null), rawBarValue));
        })).join();
        ((CompletableFuture)map.containsKey("bar").thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertTrue((result == 1 ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.containsValue(rawBarValue).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        ((CompletableFuture)map.containsValue(rawFooValue).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        ((CompletableFuture)map.replace("bar", "Goodbye bar!".getBytes()).thenAccept(result -> {
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)Arrays.equals((byte[])Versioned.valueOrElse((Versioned)result, null), rawBarValue));
        })).join();
        ((CompletableFuture)map.replace("foo", "Goodbye foo!".getBytes()).thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.replace("foo", "Goodbye foo!".getBytes(), rawFooValue).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        ((CompletableFuture)map.replace("bar", "Goodbye bar!".getBytes(), rawBarValue).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        ((CompletableFuture)map.replace("bar", "Goodbye bar!".getBytes(), rawBarValue).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        Versioned barValue = (Versioned)map.get("bar").join();
        ((CompletableFuture)map.replace("bar", barValue.version(), "Goodbye bar!".getBytes()).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        ((CompletableFuture)map.replace("bar", barValue.version(), rawBarValue).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        map.clear().join();
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertTrue((result == 0 ? 1 : 0) != 0))).join();
    }

    public void mapComputeOperationTests(int clusterSize) throws Throwable {
        this.createCopycatServers(clusterSize);
        byte[] value1 = Tools.getBytesUtf8((String)"value1");
        byte[] value2 = Tools.getBytesUtf8((String)"value2");
        byte[] value3 = Tools.getBytesUtf8((String)"value3");
        AtomixConsistentMap map = (AtomixConsistentMap)this.createAtomixClient().get("test", AtomixConsistentMap.class).join();
        ((CompletableFuture)map.computeIfAbsent((Object)"foo", k -> value1).thenAccept(result -> Assert.assertTrue((boolean)Arrays.equals((byte[])Versioned.valueOrElse((Versioned)result, null), value1)))).join();
        ((CompletableFuture)map.computeIfAbsent((Object)"foo", k -> value2).thenAccept(result -> Assert.assertTrue((boolean)Arrays.equals((byte[])Versioned.valueOrElse((Versioned)result, null), value1)))).join();
        map.computeIfPresent((Object)"bar", (k, v) -> value2).thenAccept(result -> Assert.assertNull((Object)result));
        ((CompletableFuture)map.computeIfPresent((Object)"foo", (k, v) -> value3).thenAccept(result -> Assert.assertTrue((boolean)Arrays.equals((byte[])Versioned.valueOrElse((Versioned)result, null), value3)))).join();
        ((CompletableFuture)map.computeIfPresent((Object)"foo", (k, v) -> null).thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.computeIf("foo", v -> v == null, (k, v) -> value1).thenAccept(result -> Assert.assertTrue((boolean)Arrays.equals((byte[])Versioned.valueOrElse((Versioned)result, null), value1)))).join();
        ((CompletableFuture)map.compute((Object)"foo", (k, v) -> value2).thenAccept(result -> Assert.assertTrue((boolean)Arrays.equals((byte[])Versioned.valueOrElse((Versioned)result, null), value2)))).join();
    }

    protected void mapListenerTests(int clusterSize) throws Throwable {
        this.createCopycatServers(clusterSize);
        byte[] value1 = Tools.getBytesUtf8((String)"value1");
        byte[] value2 = Tools.getBytesUtf8((String)"value2");
        byte[] value3 = Tools.getBytesUtf8((String)"value3");
        AtomixConsistentMap map = (AtomixConsistentMap)this.createAtomixClient().get("test", AtomixConsistentMap.class).join();
        TestMapEventListener listener = new TestMapEventListener();
        ((CompletableFuture)map.addListener((MapEventListener)listener).thenCompose(v -> map.put("foo", value1))).join();
        MapEvent<String, byte[]> event = listener.event();
        Assert.assertNotNull(event);
        Assert.assertEquals((Object)MapEvent.Type.INSERT, (Object)event.type());
        Assert.assertTrue((boolean)Arrays.equals(value1, (byte[])event.newValue().value()));
        ((CompletableFuture)map.removeListener((MapEventListener)listener).thenCompose(v -> map.put("foo", value2))).join();
        Assert.assertFalse((boolean)listener.eventReceived());
        ((CompletableFuture)map.addListener((MapEventListener)listener).thenCompose(v -> map.put("foo", value3))).join();
        event = listener.event();
        Assert.assertNotNull(event);
        Assert.assertEquals((Object)MapEvent.Type.UPDATE, (Object)event.type());
        Assert.assertTrue((boolean)Arrays.equals(value3, (byte[])event.newValue().value()));
        map.putIfAbsent("foo", value1).join();
        Assert.assertFalse((boolean)listener.eventReceived());
        map.remove("foo").join();
        event = listener.event();
        Assert.assertNotNull(event);
        Assert.assertEquals((Object)MapEvent.Type.REMOVE, (Object)event.type());
        Assert.assertTrue((boolean)Arrays.equals(value3, (byte[])event.oldValue().value()));
        map.computeIf("foo", v -> v == null, (k, v) -> value1).join();
        event = listener.event();
        Assert.assertNotNull(event);
        Assert.assertEquals((Object)MapEvent.Type.INSERT, (Object)event.type());
        Assert.assertTrue((boolean)Arrays.equals(value1, (byte[])event.newValue().value()));
        map.compute((Object)"foo", (k, v) -> value2).join();
        event = listener.event();
        Assert.assertNotNull(event);
        Assert.assertEquals((Object)MapEvent.Type.UPDATE, (Object)event.type());
        Assert.assertTrue((boolean)Arrays.equals(value2, (byte[])event.newValue().value()));
        map.computeIf("foo", v -> Arrays.equals(v, value2), (k, v) -> null).join();
        event = listener.event();
        Assert.assertNotNull(event);
        Assert.assertEquals((Object)MapEvent.Type.REMOVE, (Object)event.type());
        Assert.assertTrue((boolean)Arrays.equals(value2, (byte[])event.oldValue().value()));
        map.removeListener((MapEventListener)listener).join();
    }

    protected void transactionCommitTests(int clusterSize) throws Throwable {
        this.createCopycatServers(clusterSize);
        byte[] value1 = Tools.getBytesUtf8((String)"value1");
        byte[] value2 = Tools.getBytesUtf8((String)"value2");
        AtomixConsistentMap map = (AtomixConsistentMap)this.createAtomixClient().get("test", AtomixConsistentMap.class).join();
        TestMapEventListener listener = new TestMapEventListener();
        map.addListener((MapEventListener)listener).join();
        MapUpdate update1 = MapUpdate.newBuilder().withType(MapUpdate.Type.PUT_IF_ABSENT).withKey((Object)"foo").withValue((Object)value1).build();
        MapTransaction tx = new MapTransaction(TransactionId.from((String)"tx1"), Arrays.asList(update1));
        ((CompletableFuture)map.prepare(tx).thenAccept(result -> Assert.assertEquals((Object)true, (Object)result))).join();
        Assert.assertFalse((boolean)listener.eventReceived());
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertTrue((result == 0 ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.get("foo").thenAccept(result -> Assert.assertNull((Object)result))).join();
        try {
            map.put("foo", value2).join();
            Assert.assertTrue((boolean)false);
        }
        catch (CompletionException e) {
            Assert.assertEquals(ConcurrentModificationException.class, e.getCause().getClass());
        }
        Assert.assertFalse((boolean)listener.eventReceived());
        map.commit(tx.transactionId()).join();
        MapEvent<String, byte[]> event = listener.event();
        Assert.assertNotNull(event);
        Assert.assertEquals((Object)MapEvent.Type.INSERT, (Object)event.type());
        Assert.assertTrue((boolean)Arrays.equals(value1, (byte[])event.newValue().value()));
        ((CompletableFuture)map.put("foo", value2).thenAccept(result -> Assert.assertTrue((boolean)Arrays.equals((byte[])Versioned.valueOrElse((Versioned)result, null), value1)))).join();
        event = listener.event();
        Assert.assertNotNull(event);
        Assert.assertEquals((Object)MapEvent.Type.UPDATE, (Object)event.type());
        Assert.assertTrue((boolean)Arrays.equals(value2, (byte[])event.newValue().value()));
    }

    protected void transactionRollbackTests(int clusterSize) throws Throwable {
        this.createCopycatServers(clusterSize);
        byte[] value1 = Tools.getBytesUtf8((String)"value1");
        byte[] value2 = Tools.getBytesUtf8((String)"value2");
        AtomixConsistentMap map = (AtomixConsistentMap)this.createAtomixClient().get("test", AtomixConsistentMap.class).join();
        TestMapEventListener listener = new TestMapEventListener();
        map.addListener((MapEventListener)listener).join();
        MapUpdate update1 = MapUpdate.newBuilder().withType(MapUpdate.Type.PUT_IF_ABSENT).withKey((Object)"foo").withValue((Object)value1).build();
        MapTransaction tx = new MapTransaction(TransactionId.from((String)"tx1"), Arrays.asList(update1));
        ((CompletableFuture)map.prepare(tx).thenAccept(result -> Assert.assertEquals((Object)true, (Object)result))).join();
        Assert.assertFalse((boolean)listener.eventReceived());
        map.rollback(tx.transactionId()).join();
        Assert.assertFalse((boolean)listener.eventReceived());
        ((CompletableFuture)map.get("foo").thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.put("foo", value2).thenAccept(result -> Assert.assertNull((Object)result))).join();
        MapEvent<String, byte[]> event = listener.event();
        Assert.assertNotNull(event);
        Assert.assertEquals((Object)MapEvent.Type.INSERT, (Object)event.type());
        Assert.assertTrue((boolean)Arrays.equals(value2, (byte[])event.newValue().value()));
    }

    private static class TestMapEventListener
    implements MapEventListener<String, byte[]> {
        private final BlockingQueue<MapEvent<String, byte[]>> queue = new ArrayBlockingQueue<MapEvent<String, byte[]>>(1);

        private TestMapEventListener() {
        }

        public void event(MapEvent<String, byte[]> event) {
            try {
                this.queue.put(event);
            }
            catch (InterruptedException e) {
                Throwables.propagate((Throwable)e);
            }
        }

        public boolean eventReceived() {
            return !this.queue.isEmpty();
        }

        public MapEvent<String, byte[]> event() throws InterruptedException {
            return this.queue.take();
        }
    }
}

