/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.util.concurrent.Uninterruptibles;
import io.atomix.Atomix;
import io.atomix.AtomixClient;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.LocalServerRegistry;
import io.atomix.catalyst.transport.LocalTransport;
import io.atomix.catalyst.transport.Transport;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.copycat.server.storage.StorageLevel;
import io.atomix.manager.state.ResourceManagerState;
import io.atomix.resource.ResourceRegistry;
import io.atomix.resource.ResourceType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Before;
import org.onosproject.store.primitives.impl.CatalystSerializers;

public abstract class AtomixTestBase {
    private static final File TEST_DIR = new File("target/test-logs");
    protected LocalServerRegistry registry;
    protected int port;
    protected List<Address> members;
    protected List<CopycatClient> copycatClients = new ArrayList<CopycatClient>();
    protected List<CopycatServer> copycatServers = new ArrayList<CopycatServer>();
    protected List<Atomix> atomixClients = new ArrayList<Atomix>();
    protected List<CopycatServer> atomixServers = new ArrayList<CopycatServer>();
    protected Serializer serializer = CatalystSerializers.getSerializer();

    protected abstract ResourceType resourceType();

    private Address nextAddress() {
        Address address = new Address("localhost", this.port++);
        this.members.add(address);
        return address;
    }

    protected List<CopycatServer> createCopycatServers(int nodes) throws Throwable {
        int i;
        CountDownLatch latch = new CountDownLatch(nodes);
        ArrayList<CopycatServer> servers = new ArrayList<CopycatServer>();
        ArrayList<Address> members = new ArrayList<Address>();
        for (i = 0; i < nodes; ++i) {
            members.add(this.nextAddress());
        }
        for (i = 0; i < nodes; ++i) {
            CopycatServer server = this.createCopycatServer((Address)members.get(i));
            server.open().thenRun(latch::countDown);
            servers.add(server);
        }
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch);
        return servers;
    }

    protected CopycatServer createCopycatServer(Address address) {
        ResourceRegistry resourceRegistry = new ResourceRegistry();
        resourceRegistry.register(this.resourceType());
        CopycatServer server = CopycatServer.builder((Address)address, this.members).withTransport((Transport)new LocalTransport(this.registry)).withStorage(Storage.builder().withStorageLevel(StorageLevel.DISK).withDirectory(TEST_DIR + "/" + address.port()).build()).withStateMachine(() -> new ResourceManagerState(resourceRegistry)).withSerializer(this.serializer.clone()).withHeartbeatInterval(Duration.ofMillis(25L)).withElectionTimeout(Duration.ofMillis(50L)).withSessionTimeout(Duration.ofMillis(100L)).build();
        this.copycatServers.add(server);
        return server;
    }

    @Before
    @After
    public void clearTests() throws Exception {
        this.registry = new LocalServerRegistry();
        this.members = new ArrayList<Address>();
        this.port = 5000;
        CompletableFuture<Void> closeClients = CompletableFuture.allOf((CompletableFuture[])this.atomixClients.stream().map(Atomix::close).toArray(CompletableFuture[]::new));
        ((CompletableFuture)closeClients.thenCompose(v -> CompletableFuture.allOf((CompletableFuture[])this.copycatServers.stream().map(CopycatServer::close).toArray(CompletableFuture[]::new)))).join();
        this.deleteDirectory(TEST_DIR);
        this.atomixClients = new ArrayList<Atomix>();
        this.copycatServers = new ArrayList<CopycatServer>();
    }

    private void deleteDirectory(File directory) throws IOException {
        if (directory.exists()) {
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        this.deleteDirectory(file);
                        continue;
                    }
                    Files.delete(file.toPath());
                }
            }
            Files.delete(directory.toPath());
        }
    }

    protected Atomix createAtomixClient() {
        CountDownLatch latch = new CountDownLatch(1);
        AtomixClient client = AtomixClient.builder(this.members).withTransport((Transport)new LocalTransport(this.registry)).withSerializer(this.serializer.clone()).withResourceResolver(r -> r.register(this.resourceType())).build();
        client.open().thenRun(latch::countDown);
        this.atomixClients.add((Atomix)client);
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch);
        return client;
    }
}

