/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.onosproject.store.primitives.impl.DelegatingAsyncConsistentMap;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Versioned;

public class CachingAsyncConsistentMap<K, V>
extends DelegatingAsyncConsistentMap<K, V> {
    private final LoadingCache<K, CompletableFuture<Versioned<V>>> cache = CacheBuilder.newBuilder().maximumSize(10000L).build(new CacheLoader<K, CompletableFuture<Versioned<V>>>(){

        public CompletableFuture<Versioned<V>> load(K key) throws Exception {
            return CachingAsyncConsistentMap.super.get(key);
        }
    });
    private final MapEventListener<K, V> cacheInvalidator = event -> this.cache.invalidate(event.key());

    public CachingAsyncConsistentMap(AsyncConsistentMap<K, V> backingMap) {
        super(backingMap);
        super.addListener(this.cacheInvalidator);
    }

    public CompletableFuture<Void> destroy() {
        return super.destroy().thenCompose(v -> this.removeListener(this.cacheInvalidator));
    }

    @Override
    public CompletableFuture<Versioned<V>> get(K key) {
        return (CompletableFuture)this.cache.getUnchecked(key);
    }

    @Override
    public CompletableFuture<Versioned<V>> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return super.computeIf(key, condition, remappingFunction).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Versioned<V>> put(K key, V value) {
        return super.put(key, value).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Versioned<V>> putAndGet(K key, V value) {
        return super.putAndGet(key, value).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Versioned<V>> remove(K key) {
        return super.remove(key).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Void> clear() {
        return super.clear().whenComplete((r, e) -> this.cache.invalidateAll());
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, V value) {
        return super.remove(key, value).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                this.cache.invalidate(key);
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, long version) {
        return super.remove(key, version).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                this.cache.invalidate(key);
            }
        });
    }

    @Override
    public CompletableFuture<Versioned<V>> replace(K key, V value) {
        return super.replace(key, value).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return super.replace(key, oldValue, newValue).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                this.cache.invalidate(key);
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, long oldVersion, V newValue) {
        return super.replace(key, oldVersion, newValue).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                this.cache.invalidate(key);
            }
        });
    }
}

