/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.onosproject.store.service.AsyncAtomicValue;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.AtomicValueEvent;
import org.onosproject.store.service.AtomicValueEventListener;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.Versioned;
import org.onosproject.utils.MeteringAgent;

public class DefaultAsyncAtomicValue<V>
implements AsyncAtomicValue<V> {
    private final String name;
    private final Serializer serializer;
    private final AsyncConsistentMap<String, byte[]> backingMap;
    private final Map<AtomicValueEventListener<V>, MapEventListener<String, byte[]>> listeners = Maps.newIdentityHashMap();
    private final MeteringAgent monitor;
    private static final String COMPONENT_NAME = "atomicValue";
    private static final String GET = "get";
    private static final String GET_AND_SET = "getAndSet";
    private static final String SET = "set";
    private static final String COMPARE_AND_SET = "compareAndSet";
    private static final String ADD_LISTENER = "addListener";
    private static final String REMOVE_LISTENER = "removeListener";
    private static final String NOTIFY_LISTENER = "notifyListener";

    public DefaultAsyncAtomicValue(String name, Serializer serializer, AsyncConsistentMap<String, byte[]> backingMap) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name must not be null");
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer, (Object)"serializer must not be null");
        this.backingMap = (AsyncConsistentMap)Preconditions.checkNotNull(backingMap, (Object)"backingMap must not be null");
        this.monitor = new MeteringAgent(COMPONENT_NAME, name, true);
    }

    public String name() {
        return this.name;
    }

    public CompletableFuture<Boolean> compareAndSet(V expect, V update) {
        MeteringAgent.Context newTimer = this.monitor.startTimer(COMPARE_AND_SET);
        return this.backingMap.replace((Object)this.name, (Object)this.serializer.encode(expect), (Object)this.serializer.encode(update)).whenComplete((r, e) -> newTimer.stop(e));
    }

    public CompletableFuture<V> get() {
        MeteringAgent.Context newTimer = this.monitor.startTimer(GET);
        return ((CompletableFuture)((CompletableFuture)this.backingMap.get((Object)this.name).thenApply(Versioned::valueOrNull)).thenApply(v -> v == null ? null : this.serializer.decode(v))).whenComplete((r, e) -> newTimer.stop(e));
    }

    public CompletableFuture<V> getAndSet(V value) {
        MeteringAgent.Context newTimer = this.monitor.startTimer(GET_AND_SET);
        if (value == null) {
            return ((CompletableFuture)((CompletableFuture)this.backingMap.remove((Object)this.name).thenApply(Versioned::valueOrNull)).thenApply(v -> v == null ? null : this.serializer.decode(v))).whenComplete((r, e) -> newTimer.stop(e));
        }
        return ((CompletableFuture)((CompletableFuture)this.backingMap.put((Object)this.name, (Object)this.serializer.encode(value)).thenApply(Versioned::valueOrNull)).thenApply(v -> v == null ? null : this.serializer.decode(v))).whenComplete((r, e) -> newTimer.stop(e));
    }

    public CompletableFuture<Void> set(V value) {
        MeteringAgent.Context newTimer = this.monitor.startTimer(SET);
        if (value == null) {
            return ((CompletableFuture)this.backingMap.remove((Object)this.name).whenComplete((r, e) -> newTimer.stop(e))).thenApply(v -> null);
        }
        return ((CompletableFuture)this.backingMap.put((Object)this.name, (Object)this.serializer.encode(value)).whenComplete((r, e) -> newTimer.stop(e))).thenApply(v -> null);
    }

    public CompletableFuture<Void> addListener(AtomicValueEventListener<V> listener) {
        Preconditions.checkNotNull(listener, (Object)"listener must not be null");
        MeteringAgent.Context newTimer = this.monitor.startTimer(ADD_LISTENER);
        MapEventListener mapListener = this.listeners.computeIfAbsent(listener, key -> new InternalMapValueEventListener(listener));
        return this.backingMap.addListener(mapListener).whenComplete((r, e) -> newTimer.stop(e));
    }

    public CompletableFuture<Void> removeListener(AtomicValueEventListener<V> listener) {
        Preconditions.checkNotNull(listener, (Object)"listener must not be null");
        MeteringAgent.Context newTimer = this.monitor.startTimer(REMOVE_LISTENER);
        MapEventListener<String, byte[]> mapListener = this.listeners.remove(listener);
        if (mapListener != null) {
            return this.backingMap.removeListener(mapListener).whenComplete((r, e) -> newTimer.stop(e));
        }
        newTimer.stop(null);
        return CompletableFuture.completedFuture(null);
    }

    private class InternalMapValueEventListener
    implements MapEventListener<String, byte[]> {
        private final AtomicValueEventListener<V> listener;

        InternalMapValueEventListener(AtomicValueEventListener<V> listener) {
            this.listener = listener;
        }

        public void event(MapEvent<String, byte[]> event) {
            if (((String)event.key()).equals(DefaultAsyncAtomicValue.this.name)) {
                MeteringAgent.Context newTimer = DefaultAsyncAtomicValue.this.monitor.startTimer(DefaultAsyncAtomicValue.NOTIFY_LISTENER);
                byte[] rawNewValue = (byte[])Versioned.valueOrNull((Versioned)event.newValue());
                byte[] rawOldValue = (byte[])Versioned.valueOrNull((Versioned)event.oldValue());
                try {
                    this.listener.event(new AtomicValueEvent(DefaultAsyncAtomicValue.this.name, rawNewValue == null ? null : DefaultAsyncAtomicValue.this.serializer.decode(rawNewValue), rawOldValue == null ? null : DefaultAsyncAtomicValue.this.serializer.decode(rawOldValue)));
                    newTimer.stop(null);
                }
                catch (Exception e) {
                    newTimer.stop((Throwable)e);
                    Throwables.propagate((Throwable)e);
                }
            }
        }
    }
}

