/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import net.kuujo.copycat.state.Initializer;
import net.kuujo.copycat.state.StateContext;
import org.onlab.util.Match;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.CommitResponse;
import org.onosproject.store.primitives.impl.DatabaseState;
import org.onosproject.store.primitives.impl.Result;
import org.onosproject.store.primitives.impl.Transaction;
import org.onosproject.store.primitives.impl.UpdateResult;
import org.onosproject.store.service.Versioned;

public class DefaultDatabaseState
implements DatabaseState<String, byte[]> {
    private Long nextVersion;
    private Map<String, AtomicLong> counters;
    private Map<String, Map<String, Versioned<byte[]>>> maps;
    private Map<String, Queue<byte[]>> queues;
    private Map<String, Map<String, Update>> locks;

    @Override
    @Initializer
    public void init(StateContext<DatabaseState<String, byte[]>> context) {
        this.counters = (Map)context.get("counters");
        if (this.counters == null) {
            this.counters = Maps.newConcurrentMap();
            context.put("counters", this.counters);
        }
        this.maps = (Map)context.get("maps");
        if (this.maps == null) {
            this.maps = Maps.newConcurrentMap();
            context.put("maps", this.maps);
        }
        this.locks = (Map)context.get("locks");
        if (this.locks == null) {
            this.locks = Maps.newConcurrentMap();
            context.put("locks", this.locks);
        }
        this.queues = (Map)context.get("queues");
        if (this.queues == null) {
            this.queues = Maps.newConcurrentMap();
            context.put("queues", this.queues);
        }
        this.nextVersion = (Long)context.get("nextVersion");
        if (this.nextVersion == null) {
            this.nextVersion = 0L;
            context.put("nextVersion", (Object)this.nextVersion);
        }
    }

    @Override
    public Set<String> maps() {
        return ImmutableSet.copyOf(this.maps.keySet());
    }

    @Override
    public Map<String, Long> counters() {
        HashMap counterMap = Maps.newHashMap();
        this.counters.forEach((k, v) -> counterMap.put(k, v.get()));
        return counterMap;
    }

    @Override
    public int mapSize(String mapName) {
        return this.getMap(mapName).size();
    }

    @Override
    public boolean mapIsEmpty(String mapName) {
        return this.getMap(mapName).isEmpty();
    }

    @Override
    public boolean mapContainsKey(String mapName, String key) {
        return this.getMap(mapName).containsKey(key);
    }

    @Override
    public boolean mapContainsValue(String mapName, byte[] value) {
        return this.getMap(mapName).values().stream().anyMatch(v -> Arrays.equals((byte[])v.value(), value));
    }

    @Override
    public Versioned<byte[]> mapGet(String mapName, String key) {
        return this.getMap(mapName).get(key);
    }

    @Override
    public Result<UpdateResult<String, byte[]>> mapUpdate(String mapName, String key, Match<byte[]> valueMatch, Match<Long> versionMatch, byte[] value) {
        if (this.isLockedForUpdates(mapName, key)) {
            return Result.locked();
        }
        Versioned<byte[]> currentValue = this.getMap(mapName).get(key);
        if (!valueMatch.matches(currentValue == null ? null : (byte[])currentValue.value()) || !versionMatch.matches(currentValue == null ? null : Long.valueOf(currentValue.version()))) {
            return Result.ok(new UpdateResult<String, byte[]>(false, mapName, key, currentValue, currentValue));
        }
        if (value == null) {
            if (currentValue == null) {
                return Result.ok(new UpdateResult(false, mapName, key, null, null));
            }
            this.getMap(mapName).remove(key);
            return Result.ok(new UpdateResult<String, byte[]>(true, mapName, key, currentValue, null));
        }
        this.nextVersion = this.nextVersion + 1L;
        Versioned newValue = new Versioned((Object)value, this.nextVersion.longValue());
        this.getMap(mapName).put(key, (Versioned<byte[]>)newValue);
        return Result.ok(new UpdateResult<String, byte[]>(true, mapName, key, currentValue, newValue));
    }

    @Override
    public Result<Void> mapClear(String mapName) {
        if (this.areTransactionsInProgress(mapName)) {
            return Result.locked();
        }
        this.getMap(mapName).clear();
        return Result.ok(null);
    }

    @Override
    public Set<String> mapKeySet(String mapName) {
        return ImmutableSet.copyOf(this.getMap(mapName).keySet());
    }

    @Override
    public Collection<Versioned<byte[]>> mapValues(String mapName) {
        return ImmutableList.copyOf(this.getMap(mapName).values());
    }

    @Override
    public Set<Map.Entry<String, Versioned<byte[]>>> mapEntrySet(String mapName) {
        return ImmutableSet.copyOf((Collection)this.getMap(mapName).entrySet().stream().map(entry -> Maps.immutableEntry(entry.getKey(), entry.getValue())).collect(Collectors.toSet()));
    }

    @Override
    public Long counterAddAndGet(String counterName, long delta) {
        return this.getCounter(counterName).addAndGet(delta);
    }

    @Override
    public Long counterGetAndAdd(String counterName, long delta) {
        return this.getCounter(counterName).getAndAdd(delta);
    }

    @Override
    public Boolean counterCompareAndSet(String counterName, long expectedValue, long updateValue) {
        return this.getCounter(counterName).compareAndSet(expectedValue, updateValue);
    }

    @Override
    public Long counterGet(String counterName) {
        return this.getCounter(counterName).get();
    }

    @Override
    public void counterSet(String counterName, long value) {
        this.getCounter(counterName).set(value);
    }

    @Override
    public Long queueSize(String queueName) {
        return this.getQueue(queueName).size();
    }

    @Override
    public byte[] queuePeek(String queueName) {
        return this.getQueue(queueName).peek();
    }

    @Override
    public byte[] queuePop(String queueName) {
        return this.getQueue(queueName).poll();
    }

    @Override
    public void queuePush(String queueName, byte[] entry) {
        this.getQueue(queueName).offer(entry);
    }

    @Override
    public CommitResponse prepareAndCommit(Transaction transaction) {
        if (this.prepare(transaction)) {
            return this.commit(transaction);
        }
        return CommitResponse.failure();
    }

    @Override
    public boolean prepare(Transaction transaction) {
        if (transaction.updates().stream().anyMatch(update -> this.isLockedByAnotherTransaction(update.mapName(), (String)update.key(), transaction.id()))) {
            return false;
        }
        if (transaction.updates().stream().allMatch(this::isUpdatePossible)) {
            transaction.updates().forEach(update -> this.doProvisionalUpdate((MapUpdate<String, byte[]>)update, transaction.id()));
            return true;
        }
        return false;
    }

    @Override
    public CommitResponse commit(Transaction transaction) {
        return CommitResponse.success(Lists.transform(transaction.updates(), update -> this.commitProvisionalUpdate((MapUpdate<String, byte[]>)update, transaction.id())));
    }

    @Override
    public boolean rollback(Transaction transaction) {
        transaction.updates().forEach(update -> this.undoProvisionalUpdate((MapUpdate<String, byte[]>)update, transaction.id()));
        return true;
    }

    private Map<String, Versioned<byte[]>> getMap(String mapName) {
        return this.maps.computeIfAbsent(mapName, name -> Maps.newConcurrentMap());
    }

    private Map<String, Update> getLockMap(String mapName) {
        return this.locks.computeIfAbsent(mapName, name -> Maps.newConcurrentMap());
    }

    private AtomicLong getCounter(String counterName) {
        return this.counters.computeIfAbsent(counterName, name -> new AtomicLong(0L));
    }

    private Queue<byte[]> getQueue(String queueName) {
        return this.queues.computeIfAbsent(queueName, name -> new LinkedList());
    }

    private boolean isUpdatePossible(MapUpdate<String, byte[]> update) {
        Versioned<byte[]> existingEntry = this.mapGet(update.mapName(), (String)update.key());
        switch (update.type()) {
            case PUT: 
            case REMOVE: {
                return true;
            }
            case PUT_IF_ABSENT: {
                return existingEntry == null;
            }
            case PUT_IF_VERSION_MATCH: {
                return existingEntry != null && existingEntry.version() == update.currentVersion();
            }
            case PUT_IF_VALUE_MATCH: {
                return existingEntry != null && Arrays.equals((byte[])existingEntry.value(), (byte[])update.currentValue());
            }
            case REMOVE_IF_VERSION_MATCH: {
                return existingEntry == null || existingEntry.version() == update.currentVersion();
            }
            case REMOVE_IF_VALUE_MATCH: {
                return existingEntry == null || Arrays.equals((byte[])existingEntry.value(), (byte[])update.currentValue());
            }
        }
        throw new IllegalStateException("Unsupported type: " + update.type());
    }

    private void doProvisionalUpdate(MapUpdate<String, byte[]> update, TransactionId transactionId) {
        Map<String, Update> lockMap = this.getLockMap(update.mapName());
        switch (update.type()) {
            case PUT: 
            case PUT_IF_ABSENT: 
            case PUT_IF_VERSION_MATCH: 
            case PUT_IF_VALUE_MATCH: {
                lockMap.put((String)update.key(), new Update(transactionId, (byte[])update.value()));
                break;
            }
            case REMOVE: 
            case REMOVE_IF_VERSION_MATCH: 
            case REMOVE_IF_VALUE_MATCH: {
                lockMap.put((String)update.key(), new Update(transactionId, null));
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported type: " + update.type());
            }
        }
    }

    private UpdateResult<String, byte[]> commitProvisionalUpdate(MapUpdate<String, byte[]> update, TransactionId transactionId) {
        String mapName = update.mapName();
        String key = (String)update.key();
        Update provisionalUpdate = this.getLockMap(mapName).get(key);
        if (!Objects.equal((Object)transactionId, (Object)provisionalUpdate.transactionId())) {
            throw new IllegalStateException("Invalid transaction Id");
        }
        this.getLockMap(mapName).remove(key);
        return this.mapUpdate(mapName, key, (Match<byte[]>)Match.any(), (Match<Long>)Match.any(), provisionalUpdate.value()).value();
    }

    private void undoProvisionalUpdate(MapUpdate<String, byte[]> update, TransactionId transactionId) {
        String mapName = update.mapName();
        String key = (String)update.key();
        Update provisionalUpdate = this.getLockMap(mapName).get(key);
        if (provisionalUpdate == null) {
            return;
        }
        if (Objects.equal((Object)transactionId, (Object)provisionalUpdate.transactionId())) {
            this.getLockMap(mapName).remove(key);
        }
    }

    private boolean isLockedByAnotherTransaction(String mapName, String key, TransactionId transactionId) {
        Update update = this.getLockMap(mapName).get(key);
        return update != null && !Objects.equal((Object)transactionId, (Object)update.transactionId());
    }

    private boolean isLockedForUpdates(String mapName, String key) {
        return this.getLockMap(mapName).containsKey(key);
    }

    private boolean areTransactionsInProgress(String mapName) {
        return !this.getLockMap(mapName).isEmpty();
    }

    private class Update {
        private final TransactionId transactionId;
        private final byte[] value;

        public Update(TransactionId txId, byte[] value) {
            this.transactionId = txId;
            this.value = value;
        }

        public TransactionId transactionId() {
            return this.transactionId;
        }

        public byte[] value() {
            return this.value;
        }
    }
}

