/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.DefaultTransactionalMap;
import org.onosproject.store.primitives.impl.Transaction;
import org.onosproject.store.primitives.resources.impl.CommitResult;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionalMap;

public class DefaultTransactionContext
implements TransactionContext {
    private static final String TX_NOT_OPEN_ERROR = "Transaction Context is not open";
    private final Map<String, DefaultTransactionalMap> txMaps = Maps.newConcurrentMap();
    private boolean isOpen = false;
    private final Function<Transaction, CompletableFuture<CommitResult>> transactionCommitter;
    private final TransactionId transactionId;
    private final Supplier<ConsistentMapBuilder> mapBuilderSupplier;

    public DefaultTransactionContext(TransactionId transactionId, Function<Transaction, CompletableFuture<CommitResult>> transactionCommitter, Supplier<ConsistentMapBuilder> mapBuilderSupplier) {
        this.transactionId = transactionId;
        this.transactionCommitter = (Function)Preconditions.checkNotNull(transactionCommitter);
        this.mapBuilderSupplier = (Supplier)Preconditions.checkNotNull(mapBuilderSupplier);
    }

    public TransactionId transactionId() {
        return this.transactionId;
    }

    public void begin() {
        Preconditions.checkState((!this.isOpen ? 1 : 0) != 0, (Object)"Transaction Context is already open");
        this.isOpen = true;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public <K, V> TransactionalMap<K, V> getTransactionalMap(String mapName, Serializer serializer) {
        Preconditions.checkState((boolean)this.isOpen, (Object)TX_NOT_OPEN_ERROR);
        Preconditions.checkNotNull((Object)mapName);
        Preconditions.checkNotNull((Object)serializer);
        return this.txMaps.computeIfAbsent(mapName, name -> {
            ConsistentMapBuilder mapBuilder = (ConsistentMapBuilder)this.mapBuilderSupplier.get().withName(name).withSerializer(serializer);
            return new DefaultTransactionalMap((String)name, mapBuilder.buildAsyncMap(), this, serializer);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit() {
        Preconditions.checkState((boolean)this.isOpen, (Object)TX_NOT_OPEN_ERROR);
        CommitResult result = null;
        try {
            LinkedList updates = Lists.newLinkedList();
            this.txMaps.values().forEach(m -> updates.addAll(m.toMapUpdates()));
            Transaction transaction = new Transaction(this.transactionId, updates);
            result = (CommitResult)((Object)Futures.getUnchecked((Future)this.transactionCommitter.apply(transaction)));
            boolean bl = result == CommitResult.OK;
            return bl;
        }
        catch (Exception e) {
            this.abort();
            boolean bl = false;
            return bl;
        }
        finally {
            this.isOpen = false;
        }
    }

    public void abort() {
        if (this.isOpen) {
            try {
                this.txMaps.values().forEach(m -> m.abort());
            }
            finally {
                this.isOpen = false;
            }
        }
    }

    public String toString() {
        MoreObjects.ToStringHelper s = MoreObjects.toStringHelper((Object)this).add("transactionId", (Object)this.transactionId).add("isOpen", this.isOpen);
        this.txMaps.entrySet().forEach(e -> s.add((String)e.getKey(), e.getValue()));
        return s.toString();
    }

    public String name() {
        return this.transactionId.toString();
    }
}

