/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.onosproject.store.primitives.DistributedPrimitiveCreator;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.DefaultTransactionalMap;
import org.onosproject.store.primitives.impl.TransactionCoordinator;
import org.onosproject.store.primitives.impl.TransactionParticipant;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionalMap;

public class NewDefaultTransactionContext
implements TransactionContext {
    private final AtomicBoolean isOpen = new AtomicBoolean(false);
    private final DistributedPrimitiveCreator creator;
    private final TransactionId transactionId;
    private final TransactionCoordinator transactionCoordinator;
    private final Set<TransactionParticipant> txParticipants = Sets.newConcurrentHashSet();

    public NewDefaultTransactionContext(TransactionId transactionId, DistributedPrimitiveCreator creator, TransactionCoordinator transactionCoordinator) {
        this.transactionId = transactionId;
        this.creator = creator;
        this.transactionCoordinator = transactionCoordinator;
    }

    public String name() {
        return this.transactionId.toString();
    }

    public TransactionId transactionId() {
        return this.transactionId;
    }

    public boolean isOpen() {
        return this.isOpen.get();
    }

    public void begin() {
        if (!this.isOpen.compareAndSet(false, true)) {
            throw new IllegalStateException("TransactionContext is already open");
        }
    }

    public boolean commit() {
        this.transactionCoordinator.commit(this.transactionId, this.txParticipants).getNow(null);
        return true;
    }

    public void abort() {
        this.isOpen.set(false);
    }

    public <K, V> TransactionalMap<K, V> getTransactionalMap(String mapName, Serializer serializer) {
        DefaultTransactionalMap txMap = new DefaultTransactionalMap(mapName, this.creator.newAsyncConsistentMap(mapName, serializer), this, serializer);
        this.txParticipants.add(txMap);
        return txMap;
    }
}

