/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.MoreObjects;

public class StateMachineUpdate {
    private final String operationName;
    private final Object input;
    private final Object output;

    public StateMachineUpdate(String operationName, Object input, Object output) {
        this.operationName = operationName;
        this.input = input;
        this.output = output;
    }

    public Target target() {
        if (this.operationName.contains("mapUpdate")) {
            return Target.MAP_UPDATE;
        }
        if (this.operationName.contains("commit") || this.operationName.contains("prepareAndCommit")) {
            return Target.TX_COMMIT;
        }
        if (this.operationName.contains("queuePush")) {
            return Target.QUEUE_PUSH;
        }
        return Target.OTHER;
    }

    public <T> T input() {
        return (T)this.input;
    }

    public <T> T output() {
        return (T)this.output;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.operationName).add("input", this.input).add("output", this.output).toString();
    }

    static enum Target {
        MAP_UPDATE,
        TX_COMMIT,
        QUEUE_PUSH,
        OTHER;

    }
}

