/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import io.atomix.Atomix;
import io.atomix.AtomixClient;
import io.atomix.catalyst.transport.Transport;
import io.atomix.resource.ResourceRegistry;
import io.atomix.resource.ResourceType;
import io.atomix.variables.DistributedLong;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.onlab.util.HexString;
import org.onlab.util.KryoNamespace;
import org.onosproject.store.primitives.DistributedPrimitiveCreator;
import org.onosproject.store.primitives.impl.DefaultAsyncAtomicValue;
import org.onosproject.store.primitives.impl.DelegatingAsyncConsistentMap;
import org.onosproject.store.primitives.impl.DistributedPrimitives;
import org.onosproject.store.primitives.impl.Managed;
import org.onosproject.store.primitives.impl.StoragePartition;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentMap;
import org.onosproject.store.primitives.resources.impl.AtomixCounter;
import org.onosproject.store.primitives.resources.impl.AtomixLeaderElector;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncAtomicCounter;
import org.onosproject.store.service.AsyncAtomicValue;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.AsyncLeaderElector;
import org.onosproject.store.service.DistributedQueue;
import org.onosproject.store.service.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoragePartitionClient
implements DistributedPrimitiveCreator,
Managed<StoragePartitionClient> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final StoragePartition partition;
    private final Transport transport;
    private final io.atomix.catalyst.serializer.Serializer serializer;
    private final Collection<ResourceType> resourceTypes;
    private Atomix client;
    private static final String ATOMIC_VALUES_CONSISTENT_MAP_NAME = "onos-atomic-values";
    private final Supplier<AsyncConsistentMap<String, byte[]>> onosAtomicValuesMap = Suppliers.memoize(() -> this.newAsyncConsistentMap(ATOMIC_VALUES_CONSISTENT_MAP_NAME, Serializer.using((KryoNamespace)KryoNamespaces.BASIC)));

    public StoragePartitionClient(StoragePartition partition, io.atomix.catalyst.serializer.Serializer serializer, Transport transport, Collection<ResourceType> resourceTypes) {
        this.partition = partition;
        this.serializer = serializer;
        this.transport = transport;
        this.resourceTypes = ImmutableSet.copyOf(resourceTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> open() {
        if (this.client != null && this.client.isOpen()) {
            return CompletableFuture.completedFuture(null);
        }
        StoragePartitionClient storagePartitionClient = this;
        synchronized (storagePartitionClient) {
            this.client = AtomixClient.builder(this.partition.getMemberAddresses()).withSerializer(this.serializer.clone()).withResourceResolver(r -> this.resourceTypes.forEach(arg_0 -> ((ResourceRegistry)r).register(arg_0))).withTransport(this.transport).build();
        }
        return ((CompletableFuture)this.client.open().whenComplete((r, e) -> {
            if (e == null) {
                this.log.info("Successfully started client for partition {}", (Object)this.partition.getId());
            } else {
                this.log.info("Failed to start client for partition {}", (Object)this.partition.getId(), e);
            }
        })).thenApply(v -> null);
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.client != null ? this.client.close() : CompletableFuture.completedFuture(null);
    }

    public <K, V> AsyncConsistentMap<K, V> newAsyncConsistentMap(final String name, Serializer serializer) {
        DelegatingAsyncConsistentMap<String, byte[]> rawMap = new DelegatingAsyncConsistentMap<String, byte[]>((AsyncConsistentMap)this.client.get(name, AtomixConsistentMap.class).join()){

            @Override
            public String name() {
                return name;
            }
        };
        AsyncConsistentMap<Object, Object> transcodedMap = DistributedPrimitives.newTranscodingMap(rawMap, key -> HexString.toHexString((byte[])serializer.encode(key)), string -> serializer.decode(HexString.fromHexString((String)string)), value -> value == null ? null : serializer.encode(value), bytes -> serializer.decode(bytes));
        return DistributedPrimitives.newCachingMap(transcodedMap);
    }

    public <E> AsyncDistributedSet<E> newAsyncDistributedSet(String name, Serializer serializer) {
        return DistributedPrimitives.newSetFromMap(this.newAsyncConsistentMap(name, serializer));
    }

    public AsyncAtomicCounter newAsyncCounter(String name) {
        DistributedLong distributedLong = (DistributedLong)this.client.get(name, DistributedLong.class).join();
        return new AtomixCounter(name, distributedLong);
    }

    public <V> AsyncAtomicValue<V> newAsyncAtomicValue(String name, Serializer serializer) {
        return new DefaultAsyncAtomicValue(name, serializer, (AsyncConsistentMap<String, byte[]>)((AsyncConsistentMap)this.onosAtomicValuesMap.get()));
    }

    public <E> DistributedQueue<E> newDistributedQueue(String name, Serializer serializer) {
        throw new UnsupportedOperationException();
    }

    public AsyncLeaderElector newAsyncLeaderElector(String name) {
        return (AsyncLeaderElector)this.client.get(name, AtomixLeaderElector.class).join();
    }

    public Set<String> getAsyncConsistentMapNames() {
        return (Set)this.client.keys(AtomixConsistentMap.class).join();
    }

    public Set<String> getAsyncAtomicCounterNames() {
        return (Set)this.client.keys(DistributedLong.class).join();
    }

    @Override
    public boolean isOpen() {
        return this.client.isOpen();
    }

    @Override
    public boolean isClosed() {
        return this.client.isClosed();
    }
}

