/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.ImmutableSet;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.copycat.server.storage.StorageLevel;
import io.atomix.manager.ResourceManagerTypeResolver;
import io.atomix.manager.state.ResourceManagerState;
import io.atomix.resource.ResourceRegistry;
import io.atomix.resource.ResourceType;
import io.atomix.resource.ServiceLoaderResourceResolver;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.onosproject.store.primitives.impl.Managed;
import org.onosproject.store.primitives.impl.StoragePartition;
import org.onosproject.store.primitives.impl.StoragePartitionDetails;
import org.onosproject.store.service.PartitionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoragePartitionServer
implements Managed<StoragePartitionServer> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int MAX_ENTRIES_PER_LOG_SEGMENT = 32768;
    private final StoragePartition partition;
    private final Address localAddress;
    private final Supplier<Transport> transport;
    private final Serializer serializer;
    private final File dataFolder;
    private final Collection<ResourceType> resourceTypes;
    private CopycatServer server;

    public StoragePartitionServer(Address localAddress, StoragePartition partition, Serializer serializer, Supplier<Transport> transport, Collection<ResourceType> resourceTypes, File dataFolder) {
        this.partition = partition;
        this.localAddress = localAddress;
        this.serializer = serializer;
        this.transport = transport;
        this.resourceTypes = ImmutableSet.copyOf(resourceTypes);
        this.dataFolder = dataFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> open() {
        CompletableFuture serverOpenFuture;
        if (this.partition.getMemberAddresses().contains(this.localAddress)) {
            if (this.server != null && this.server.isOpen()) {
                return CompletableFuture.completedFuture(null);
            }
            StoragePartitionServer storagePartitionServer = this;
            synchronized (storagePartitionServer) {
                this.server = this.buildServer(this.partition.getMemberAddresses());
            }
            serverOpenFuture = this.server.open();
        } else {
            serverOpenFuture = CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)serverOpenFuture.whenComplete((r, e) -> {
            if (e == null) {
                this.log.info("Successfully started server for partition {}", (Object)this.partition.getId());
            } else {
                this.log.info("Failed to start server for partition {}", (Object)this.partition.getId(), e);
            }
        })).thenApply(v -> null);
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.server.kill();
    }

    public CompletableFuture<Void> closeAndExit() {
        return this.server.close();
    }

    private CopycatServer buildServer(Collection<Address> clusterMembers) {
        ServiceLoaderResourceResolver resourceResolver = new ServiceLoaderResourceResolver();
        ResourceRegistry registry = new ResourceRegistry();
        this.resourceTypes.forEach(arg_0 -> ((ResourceRegistry)registry).register(arg_0));
        resourceResolver.resolve(registry);
        CopycatServer server = CopycatServer.builder((Address)this.localAddress, clusterMembers).withName("partition-" + this.partition.getId()).withSerializer(this.serializer.clone()).withTransport(this.transport.get()).withStateMachine(() -> new ResourceManagerState(registry)).withStorage(Storage.builder().withStorageLevel(StorageLevel.DISK).withCompactionThreads(1).withDirectory(this.dataFolder).withMaxEntriesPerSegment(32768).build()).build();
        server.serializer().resolve(new SerializableTypeResolver[]{new ResourceManagerTypeResolver(registry)});
        return server;
    }

    public CompletableFuture<Void> join(Collection<Address> otherMembers) {
        this.server = this.buildServer(otherMembers);
        return ((CompletableFuture)this.server.open().whenComplete((r, e) -> {
            if (e == null) {
                this.log.info("Successfully joined partition {}", (Object)this.partition.getId());
            } else {
                this.log.info("Failed to join partition {}", (Object)this.partition.getId(), e);
            }
        })).thenApply(v -> null);
    }

    @Override
    public boolean isOpen() {
        return this.server.isOpen();
    }

    @Override
    public boolean isClosed() {
        return this.server.isClosed();
    }

    public PartitionInfo info() {
        return new StoragePartitionDetails(this.partition.getId(), this.server.cluster().members(), this.server.cluster().members(), this.server.cluster().leader(), this.server.cluster().term()).toPartitionInfo();
    }
}

