/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.Transaction;
import org.onosproject.store.primitives.impl.TransactionParticipant;
import org.onosproject.store.service.AsyncConsistentMap;

public class TransactionCoordinator {
    private final AsyncConsistentMap<TransactionId, Transaction.State> transactions;

    public TransactionCoordinator(AsyncConsistentMap<TransactionId, Transaction.State> transactions) {
        this.transactions = transactions;
    }

    CompletableFuture<Void> commit(TransactionId transactionId, Set<TransactionParticipant> transactionParticipants) {
        if (!transactionParticipants.stream().anyMatch(t -> t.hasPendingUpdates())) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.transactions.put((Object)transactionId, (Object)Transaction.State.PREPARING).thenCompose(v -> this.doPrepare(transactionParticipants))).thenCompose(result -> result != false ? ((CompletableFuture)this.transactions.put((Object)transactionId, (Object)Transaction.State.COMMITTING).thenCompose(v -> this.doCommit(transactionParticipants))).thenApply(v -> null) : ((CompletableFuture)this.transactions.put((Object)transactionId, (Object)Transaction.State.ROLLINGBACK).thenCompose(v -> this.doRollback(transactionParticipants))).thenApply(v -> null))).thenCompose(v -> this.transactions.remove((Object)transactionId))).thenApply(v -> null);
    }

    private CompletableFuture<Boolean> doPrepare(Set<TransactionParticipant> transactionParticipants) {
        return Tools.allOf(transactionParticipants.stream().map(TransactionParticipant::prepare).collect(Collectors.toList())).thenApply(list -> list.stream().reduce(Boolean::logicalAnd).orElse(true));
    }

    private CompletableFuture<Void> doCommit(Set<TransactionParticipant> transactionParticipants) {
        return CompletableFuture.allOf((CompletableFuture[])transactionParticipants.stream().map(p -> p.commit()).toArray(CompletableFuture[]::new));
    }

    private CompletableFuture<Void> doRollback(Set<TransactionParticipant> transactionParticipants) {
        return CompletableFuture.allOf((CompletableFuture[])transactionParticipants.stream().map(p -> p.rollback()).toArray(CompletableFuture[]::new));
    }
}

