/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.Database;
import org.onosproject.store.primitives.impl.Transaction;
import org.onosproject.store.primitives.resources.impl.CommitResult;
import org.onosproject.store.service.AsyncConsistentMap;

public class TransactionManager {
    private final Database database;
    private final AsyncConsistentMap<TransactionId, Transaction> transactions;

    public TransactionManager(Database database, AsyncConsistentMap<TransactionId, Transaction> transactions) {
        this.database = (Database)Preconditions.checkNotNull((Object)database, (Object)"database cannot be null");
        this.transactions = transactions;
    }

    public CompletableFuture<CommitResult> execute(Transaction transaction) {
        if (transaction.updates().size() <= 1) {
            return this.database.prepareAndCommit(transaction).thenApply(response -> response.success() ? CommitResult.OK : CommitResult.FAILURE_DURING_COMMIT);
        }
        if (transaction.state() == Transaction.State.COMMITTED || transaction.state() == Transaction.State.ROLLEDBACK) {
            return this.transactions.remove((Object)transaction.id()).thenApply(v -> CommitResult.OK);
        }
        if (transaction.state() == Transaction.State.COMMITTING) {
            return this.commit(transaction);
        }
        if (transaction.state() == Transaction.State.ROLLINGBACK) {
            return this.rollback(transaction).thenApply(v -> CommitResult.FAILURE_TO_PREPARE);
        }
        return this.prepare(transaction).thenCompose(v -> v != false ? this.commit(transaction) : this.rollback(transaction));
    }

    public CompletableFuture<Collection<TransactionId>> getPendingTransactionIds() {
        return this.transactions.values().thenApply(c -> c.stream().map(v -> (Transaction)v.value()).filter(v -> v.state() != Transaction.State.COMMITTED && v.state() != Transaction.State.ROLLEDBACK).map(Transaction::id).collect(Collectors.toList()));
    }

    private CompletableFuture<Boolean> prepare(Transaction transaction) {
        return ((CompletableFuture)this.transactions.put((Object)transaction.id(), (Object)transaction).thenCompose(v -> this.database.prepare(transaction))).thenCompose(status -> this.transactions.put((Object)transaction.id(), (Object)transaction.transition(status != false ? Transaction.State.COMMITTING : Transaction.State.ROLLINGBACK)).thenApply(v -> status));
    }

    private CompletableFuture<CommitResult> commit(Transaction transaction) {
        return this.database.commit(transaction).thenCompose(r -> {
            if (r.success()) {
                return this.transactions.put((Object)transaction.id(), (Object)transaction.transition(Transaction.State.COMMITTED)).thenApply(v -> CommitResult.OK);
            }
            return CompletableFuture.completedFuture(CommitResult.FAILURE_DURING_COMMIT);
        });
    }

    private CompletableFuture<CommitResult> rollback(Transaction transaction) {
        return ((CompletableFuture)this.database.rollback(transaction).thenCompose(v -> this.transactions.put((Object)transaction.id(), (Object)transaction.transition(Transaction.State.ROLLEDBACK)))).thenApply(v -> CommitResult.FAILURE_TO_PREPARE);
    }
}

