/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import java.util.function.Function;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.Versioned;

public class UpdateResult<K, V> {
    private final boolean updated;
    private final String mapName;
    private final K key;
    private final Versioned<V> oldValue;
    private final Versioned<V> newValue;

    public UpdateResult(boolean updated, String mapName, K key, Versioned<V> oldValue, Versioned<V> newValue) {
        this.updated = updated;
        this.mapName = mapName;
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public boolean updated() {
        return this.updated;
    }

    public String mapName() {
        return this.mapName;
    }

    public K key() {
        return this.key;
    }

    public Versioned<V> oldValue() {
        return this.oldValue;
    }

    public Versioned<V> newValue() {
        return this.newValue;
    }

    public <K1, V1> UpdateResult<K1, V1> map(Function<K, K1> keyTransform, Function<V, V1> valueMapper) {
        return new UpdateResult<K1, V>(this.updated, this.mapName, keyTransform.apply(this.key), this.oldValue == null ? null : this.oldValue.map(valueMapper), this.newValue == null ? null : this.newValue.map(valueMapper));
    }

    public MapEvent<K, V> toMapEvent() {
        if (!this.updated) {
            return null;
        }
        return new MapEvent(this.mapName(), this.key(), this.newValue, this.oldValue);
    }
}

