/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.kuujo.copycat.protocol.AbstractProtocol;
import net.kuujo.copycat.protocol.ProtocolClient;
import net.kuujo.copycat.protocol.ProtocolHandler;
import net.kuujo.copycat.protocol.ProtocolServer;
import net.kuujo.copycat.util.Configurable;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.MessageSubject;

public class CopycatCommunicationProtocol
extends AbstractProtocol {
    private static final MessageSubject COPYCAT_MESSAGE_SUBJECT = new MessageSubject("onos-copycat-message");
    protected ClusterService clusterService;
    protected ClusterCommunicationService clusterCommunicator;

    public CopycatCommunicationProtocol(ClusterService clusterService, ClusterCommunicationService clusterCommunicator) {
        this.clusterService = clusterService;
        this.clusterCommunicator = clusterCommunicator;
    }

    public Configurable copy() {
        return this;
    }

    public ProtocolClient createClient(URI uri) {
        NodeId nodeId = this.uriToNodeId(uri);
        if (nodeId == null) {
            throw new IllegalStateException("Unknown peer " + uri);
        }
        return new Client(nodeId);
    }

    public ProtocolServer createServer(URI uri) {
        return new Server();
    }

    private NodeId uriToNodeId(URI uri) {
        return this.clusterService.getNodes().stream().filter(node -> uri.getHost().equals(node.ip().toString())).map(ControllerNode::id).findAny().orElse(null);
    }

    private class Client
    implements ProtocolClient {
        private final NodeId peer;

        public Client(NodeId peer) {
            this.peer = peer;
        }

        public CompletableFuture<ByteBuffer> write(ByteBuffer request) {
            return CopycatCommunicationProtocol.this.clusterCommunicator.sendAndReceive((Object)request, COPYCAT_MESSAGE_SUBJECT, Tools::byteBuffertoArray, ByteBuffer::wrap, this.peer);
        }

        public CompletableFuture<Void> connect() {
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> close() {
            return CompletableFuture.completedFuture(null);
        }
    }

    private class Server
    implements ProtocolServer {
        private Server() {
        }

        public void handler(ProtocolHandler handler) {
            if (handler == null) {
                CopycatCommunicationProtocol.this.clusterCommunicator.removeSubscriber(COPYCAT_MESSAGE_SUBJECT);
            } else {
                CopycatCommunicationProtocol.this.clusterCommunicator.addSubscriber(COPYCAT_MESSAGE_SUBJECT, ByteBuffer::wrap, (Function)handler, Tools::byteBuffertoArray);
            }
        }

        public CompletableFuture<Void> listen() {
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> close() {
            CopycatCommunicationProtocol.this.clusterCommunicator.removeSubscriber(COPYCAT_MESSAGE_SUBJECT);
            return CompletableFuture.completedFuture(null);
        }
    }
}

