/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang.math.RandomUtils;
import org.onosproject.cluster.PartitionId;
import org.onosproject.store.cluster.messaging.MessagingService;
import org.onosproject.store.primitives.impl.CopycatTransport;
import org.onosproject.store.primitives.impl.CopycatTransportConnection;

public class CopycatTransportClient
implements Client {
    private final PartitionId partitionId;
    private final MessagingService messagingService;
    private final CopycatTransport.Mode mode;
    private final Set<CopycatTransportConnection> connections = Sets.newConcurrentHashSet();

    CopycatTransportClient(PartitionId partitionId, MessagingService messagingService, CopycatTransport.Mode mode) {
        this.partitionId = (PartitionId)Preconditions.checkNotNull((Object)partitionId);
        this.messagingService = (MessagingService)Preconditions.checkNotNull((Object)messagingService);
        this.mode = (CopycatTransport.Mode)((Object)Preconditions.checkNotNull((Object)((Object)mode)));
    }

    public CompletableFuture<Connection> connect(Address remoteAddress) {
        ThreadContext context = ThreadContext.currentContextOrThrow();
        CopycatTransportConnection connection = new CopycatTransportConnection(this.nextConnectionId(), CopycatTransport.Mode.CLIENT, this.partitionId, remoteAddress, this.messagingService, context);
        if (this.mode == CopycatTransport.Mode.CLIENT) {
            connection.setBidirectional();
        }
        this.connections.add(connection);
        return CompletableFuture.supplyAsync(() -> connection, context.executor());
    }

    public CompletableFuture<Void> close() {
        return CompletableFuture.allOf((CompletableFuture[])this.connections.stream().map(Connection::close).toArray(CompletableFuture[]::new));
    }

    private long nextConnectionId() {
        return RandomUtils.nextLong();
    }
}

