/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import java.util.List;
import org.onosproject.store.primitives.impl.Database;
import org.onosproject.store.primitives.impl.Partitioner;

public abstract class DatabasePartitioner
implements Partitioner<String> {
    protected final List<Database> partitions;

    public DatabasePartitioner(List<Database> partitions) {
        Preconditions.checkState((partitions != null && !partitions.isEmpty() ? 1 : 0) != 0, (Object)"Partitions cannot be null or empty");
        this.partitions = ImmutableList.copyOf(partitions);
    }

    protected int hash(String key) {
        return Math.abs(Hashing.md5().newHasher().putBytes(key.getBytes(Charsets.UTF_8)).hash().asInt());
    }
}

