/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.onlab.util.Match;
import org.onosproject.store.primitives.impl.CommitResponse;
import org.onosproject.store.primitives.impl.Result;
import org.onosproject.store.primitives.impl.Transaction;
import org.onosproject.store.primitives.impl.UpdateResult;
import org.onosproject.store.service.Versioned;

public interface DatabaseProxy<K, V> {
    public CompletableFuture<Set<String>> maps();

    public CompletableFuture<Map<String, Long>> counters();

    public CompletableFuture<Integer> mapSize(String var1);

    public CompletableFuture<Boolean> mapIsEmpty(String var1);

    public CompletableFuture<Boolean> mapContainsKey(String var1, K var2);

    public CompletableFuture<Boolean> mapContainsValue(String var1, V var2);

    public CompletableFuture<Versioned<V>> mapGet(String var1, K var2);

    public CompletableFuture<Result<UpdateResult<K, V>>> mapUpdate(String var1, K var2, Match<V> var3, Match<Long> var4, V var5);

    public CompletableFuture<Result<Void>> mapClear(String var1);

    public CompletableFuture<Set<K>> mapKeySet(String var1);

    public CompletableFuture<Collection<Versioned<V>>> mapValues(String var1);

    public CompletableFuture<Set<Map.Entry<K, Versioned<V>>>> mapEntrySet(String var1);

    public CompletableFuture<Long> counterAddAndGet(String var1, long var2);

    public CompletableFuture<Long> counterGetAndAdd(String var1, long var2);

    public CompletableFuture<Void> counterSet(String var1, long var2);

    public CompletableFuture<Boolean> counterCompareAndSet(String var1, long var2, long var4);

    public CompletableFuture<Long> counterGet(String var1);

    public CompletableFuture<Long> queueSize(String var1);

    public CompletableFuture<Void> queuePush(String var1, byte[] var2);

    public CompletableFuture<byte[]> queuePop(String var1);

    public CompletableFuture<byte[]> queuePeek(String var1);

    public CompletableFuture<CommitResponse> prepareAndCommit(Transaction var1);

    public CompletableFuture<Boolean> prepare(Transaction var1);

    public CompletableFuture<CommitResponse> commit(Transaction var1);

    public CompletableFuture<Boolean> rollback(Transaction var1);
}

