/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Preconditions;
import org.onosproject.store.primitives.impl.AsyncCachingConsistentMap;
import org.onosproject.store.primitives.impl.Database;
import org.onosproject.store.primitives.impl.DatabaseManager;
import org.onosproject.store.primitives.impl.DefaultAsyncConsistentMap;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;

public class DefaultConsistentMapBuilder<K, V>
extends ConsistentMapBuilder<K, V> {
    private final DatabaseManager manager;

    public DefaultConsistentMapBuilder(DatabaseManager manager) {
        this.manager = manager;
    }

    private void validateInputs() {
        Preconditions.checkState((this.name() != null ? 1 : 0) != 0, (Object)"name must be specified");
        Preconditions.checkState((this.serializer() != null ? 1 : 0) != 0, (Object)"serializer must be specified");
        if (this.purgeOnUninstall()) {
            Preconditions.checkState((this.applicationId() != null ? 1 : 0) != 0, (Object)"ApplicationId must be specified when purgeOnUninstall is enabled");
        }
    }

    public ConsistentMap<K, V> build() {
        return this.buildAndRegisterMap().asConsistentMap();
    }

    public AsyncConsistentMap<K, V> buildAsyncMap() {
        return this.buildAndRegisterMap();
    }

    private DefaultAsyncConsistentMap<K, V> buildAndRegisterMap() {
        Database database;
        this.validateInputs();
        Database database2 = database = this.partitionsDisabled() ? this.manager.inMemoryDatabase : this.manager.partitionedDatabase;
        if (this.relaxedReadConsistency()) {
            return this.manager.registerMap(new AsyncCachingConsistentMap(this.name(), this.applicationId(), database, this.serializer(), this.readOnly(), this.purgeOnUninstall(), this.meteringEnabled()));
        }
        return this.manager.registerMap(new DefaultAsyncConsistentMap(this.name(), this.applicationId(), database, this.serializer(), this.readOnly(), this.purgeOnUninstall(), this.meteringEnabled()));
    }
}

