/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.kuujo.copycat.Task;
import net.kuujo.copycat.resource.internal.AbstractResource;
import net.kuujo.copycat.resource.internal.ResourceManager;
import net.kuujo.copycat.state.StateMachine;
import net.kuujo.copycat.state.internal.DefaultStateMachine;
import net.kuujo.copycat.util.concurrent.Futures;
import net.kuujo.copycat.util.function.TriConsumer;
import org.onlab.util.Match;
import org.onosproject.store.primitives.impl.CommitResponse;
import org.onosproject.store.primitives.impl.Database;
import org.onosproject.store.primitives.impl.DatabaseProxy;
import org.onosproject.store.primitives.impl.DatabaseState;
import org.onosproject.store.primitives.impl.DefaultDatabaseState;
import org.onosproject.store.primitives.impl.Result;
import org.onosproject.store.primitives.impl.StateMachineUpdate;
import org.onosproject.store.primitives.impl.Transaction;
import org.onosproject.store.primitives.impl.UpdateResult;
import org.onosproject.store.service.Versioned;

public class DefaultDatabase
extends AbstractResource<Database>
implements Database {
    private final StateMachine<DatabaseState<String, byte[]>> stateMachine;
    private DatabaseProxy<String, byte[]> proxy;
    private final Set<Consumer<StateMachineUpdate>> consumers = Sets.newCopyOnWriteArraySet();
    private final TriConsumer<String, Object, Object> watcher = new InternalStateMachineWatcher();

    public DefaultDatabase(ResourceManager context) {
        super(context);
        this.stateMachine = new DefaultStateMachine(context, DatabaseState.class, DefaultDatabaseState.class, DefaultDatabase.class.getClassLoader());
        this.stateMachine.addStartupTask((Task & Serializable)() -> {
            this.stateMachine.registerWatcher(this.watcher);
            return CompletableFuture.completedFuture(null);
        });
        this.stateMachine.addShutdownTask((Task & Serializable)() -> {
            this.stateMachine.unregisterWatcher(this.watcher);
            return CompletableFuture.completedFuture(null);
        });
    }

    protected <T> CompletableFuture<T> checkOpen(Supplier<CompletableFuture<T>> supplier) {
        if (this.proxy == null) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("Database closed"));
        }
        return supplier.get();
    }

    @Override
    public CompletableFuture<Set<String>> maps() {
        return this.checkOpen(() -> this.proxy.maps());
    }

    @Override
    public CompletableFuture<Map<String, Long>> counters() {
        return this.checkOpen(() -> this.proxy.counters());
    }

    @Override
    public CompletableFuture<Integer> mapSize(String mapName) {
        return this.checkOpen(() -> this.proxy.mapSize(mapName));
    }

    @Override
    public CompletableFuture<Boolean> mapIsEmpty(String mapName) {
        return this.checkOpen(() -> this.proxy.mapIsEmpty(mapName));
    }

    @Override
    public CompletableFuture<Boolean> mapContainsKey(String mapName, String key) {
        return this.checkOpen(() -> this.proxy.mapContainsKey(mapName, key));
    }

    @Override
    public CompletableFuture<Boolean> mapContainsValue(String mapName, byte[] value) {
        return this.checkOpen(() -> this.proxy.mapContainsValue(mapName, value));
    }

    @Override
    public CompletableFuture<Versioned<byte[]>> mapGet(String mapName, String key) {
        return this.checkOpen(() -> this.proxy.mapGet(mapName, key));
    }

    @Override
    public CompletableFuture<Result<UpdateResult<String, byte[]>>> mapUpdate(String mapName, String key, Match<byte[]> valueMatch, Match<Long> versionMatch, byte[] value) {
        return this.checkOpen(() -> this.proxy.mapUpdate(mapName, key, valueMatch, versionMatch, value));
    }

    @Override
    public CompletableFuture<Result<Void>> mapClear(String mapName) {
        return this.checkOpen(() -> this.proxy.mapClear(mapName));
    }

    @Override
    public CompletableFuture<Set<String>> mapKeySet(String mapName) {
        return this.checkOpen(() -> this.proxy.mapKeySet(mapName));
    }

    @Override
    public CompletableFuture<Collection<Versioned<byte[]>>> mapValues(String mapName) {
        return this.checkOpen(() -> this.proxy.mapValues(mapName));
    }

    @Override
    public CompletableFuture<Set<Map.Entry<String, Versioned<byte[]>>>> mapEntrySet(String mapName) {
        return this.checkOpen(() -> this.proxy.mapEntrySet(mapName));
    }

    @Override
    public CompletableFuture<Long> counterGet(String counterName) {
        return this.checkOpen(() -> this.proxy.counterGet(counterName));
    }

    @Override
    public CompletableFuture<Long> counterAddAndGet(String counterName, long delta) {
        return this.checkOpen(() -> this.proxy.counterAddAndGet(counterName, delta));
    }

    @Override
    public CompletableFuture<Long> counterGetAndAdd(String counterName, long delta) {
        return this.checkOpen(() -> this.proxy.counterGetAndAdd(counterName, delta));
    }

    @Override
    public CompletableFuture<Void> counterSet(String counterName, long value) {
        return this.checkOpen(() -> this.proxy.counterSet(counterName, value));
    }

    @Override
    public CompletableFuture<Boolean> counterCompareAndSet(String counterName, long expectedValue, long update) {
        return this.checkOpen(() -> this.proxy.counterCompareAndSet(counterName, expectedValue, update));
    }

    @Override
    public CompletableFuture<Long> queueSize(String queueName) {
        return this.checkOpen(() -> this.proxy.queueSize(queueName));
    }

    @Override
    public CompletableFuture<Void> queuePush(String queueName, byte[] entry) {
        return this.checkOpen(() -> this.proxy.queuePush(queueName, entry));
    }

    @Override
    public CompletableFuture<byte[]> queuePop(String queueName) {
        return this.checkOpen(() -> this.proxy.queuePop(queueName));
    }

    @Override
    public CompletableFuture<byte[]> queuePeek(String queueName) {
        return this.checkOpen(() -> this.proxy.queuePeek(queueName));
    }

    @Override
    public CompletableFuture<CommitResponse> prepareAndCommit(Transaction transaction) {
        return this.checkOpen(() -> this.proxy.prepareAndCommit(transaction));
    }

    @Override
    public CompletableFuture<Boolean> prepare(Transaction transaction) {
        return this.checkOpen(() -> this.proxy.prepare(transaction));
    }

    @Override
    public CompletableFuture<CommitResponse> commit(Transaction transaction) {
        return this.checkOpen(() -> this.proxy.commit(transaction));
    }

    @Override
    public CompletableFuture<Boolean> rollback(Transaction transaction) {
        return this.checkOpen(() -> this.proxy.rollback(transaction));
    }

    public synchronized CompletableFuture<Database> open() {
        return ((CompletableFuture)((CompletableFuture)this.runStartupTasks().thenCompose(v -> this.stateMachine.open())).thenRun(() -> {
            this.proxy = (DatabaseProxy)this.stateMachine.createProxy(DatabaseProxy.class, this.getClass().getClassLoader());
        })).thenApply(v -> null);
    }

    public synchronized CompletableFuture<Void> close() {
        this.proxy = null;
        return this.stateMachine.close().thenCompose(v -> this.runShutdownTasks());
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Database) {
            return this.name().equals(((Database)other).name());
        }
        return false;
    }

    @Override
    public void registerConsumer(Consumer<StateMachineUpdate> consumer) {
        this.consumers.add(consumer);
    }

    @Override
    public void unregisterConsumer(Consumer<StateMachineUpdate> consumer) {
        this.consumers.remove(consumer);
    }

    private class InternalStateMachineWatcher
    implements TriConsumer<String, Object, Object> {
        private InternalStateMachineWatcher() {
        }

        public void accept(String name, Object input, Object output) {
            StateMachineUpdate update = new StateMachineUpdate(name, input, output);
            DefaultDatabase.this.consumers.forEach(consumer -> consumer.accept(update));
        }
    }
}

