/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.DefaultTransactionContext;
import org.onosproject.store.primitives.impl.Transaction;
import org.onosproject.store.primitives.resources.impl.CommitResult;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionContextBuilder;

public class DefaultTransactionContextBuilder
extends TransactionContextBuilder {
    private final Supplier<ConsistentMapBuilder> mapBuilderSupplier;
    private final Function<Transaction, CompletableFuture<CommitResult>> transactionCommitter;
    private final TransactionId transactionId;

    public DefaultTransactionContextBuilder(Supplier<ConsistentMapBuilder> mapBuilderSupplier, Function<Transaction, CompletableFuture<CommitResult>> transactionCommiter, TransactionId transactionId) {
        this.mapBuilderSupplier = mapBuilderSupplier;
        this.transactionCommitter = transactionCommiter;
        this.transactionId = transactionId;
    }

    public TransactionContext build() {
        return new DefaultTransactionContext(this.transactionId, this.transactionCommitter, () -> {
            ConsistentMapBuilder mapBuilder = this.mapBuilderSupplier.get();
            if (this.partitionsDisabled()) {
                mapBuilder = (ConsistentMapBuilder)mapBuilder.withPartitionsDisabled();
            }
            return mapBuilder;
        });
    }
}

