/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.persistence.PersistenceService;
import org.onosproject.store.Timestamp;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.primitives.impl.EventuallyConsistentMapImpl;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapBuilder;

public class EventuallyConsistentMapBuilderImpl<K, V>
implements EventuallyConsistentMapBuilder<K, V> {
    private final ClusterService clusterService;
    private final ClusterCommunicationService clusterCommunicator;
    private String name;
    private KryoNamespace.Builder serializerBuilder;
    private ExecutorService eventExecutor;
    private ExecutorService communicationExecutor;
    private ScheduledExecutorService backgroundExecutor;
    private BiFunction<K, V, Timestamp> timestampProvider;
    private BiFunction<K, V, Collection<NodeId>> peerUpdateFunction;
    private boolean tombstonesDisabled = false;
    private long antiEntropyPeriod = 5L;
    private TimeUnit antiEntropyTimeUnit = TimeUnit.SECONDS;
    private boolean convergeFaster = false;
    private boolean persistent = false;
    private boolean persistentMap = false;
    private final PersistenceService persistenceService;

    public EventuallyConsistentMapBuilderImpl(ClusterService clusterService, ClusterCommunicationService clusterCommunicator, PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
        this.clusterService = (ClusterService)Preconditions.checkNotNull((Object)clusterService);
        this.clusterCommunicator = (ClusterCommunicationService)Preconditions.checkNotNull((Object)clusterCommunicator);
    }

    public EventuallyConsistentMapBuilder<K, V> withName(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        return this;
    }

    public EventuallyConsistentMapBuilder<K, V> withSerializer(KryoNamespace.Builder serializerBuilder) {
        this.serializerBuilder = (KryoNamespace.Builder)Preconditions.checkNotNull((Object)serializerBuilder);
        return this;
    }

    public EventuallyConsistentMapBuilder<K, V> withTimestampProvider(BiFunction<K, V, Timestamp> timestampProvider) {
        this.timestampProvider = (BiFunction)Preconditions.checkNotNull(timestampProvider);
        return this;
    }

    public EventuallyConsistentMapBuilder<K, V> withEventExecutor(ExecutorService executor) {
        this.eventExecutor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
        return this;
    }

    public EventuallyConsistentMapBuilder<K, V> withCommunicationExecutor(ExecutorService executor) {
        this.communicationExecutor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
        return this;
    }

    public EventuallyConsistentMapBuilder<K, V> withBackgroundExecutor(ScheduledExecutorService executor) {
        this.backgroundExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor);
        return this;
    }

    public EventuallyConsistentMapBuilder<K, V> withPeerUpdateFunction(BiFunction<K, V, Collection<NodeId>> peerUpdateFunction) {
        this.peerUpdateFunction = (BiFunction)Preconditions.checkNotNull(peerUpdateFunction);
        return this;
    }

    public EventuallyConsistentMapBuilder<K, V> withTombstonesDisabled() {
        this.tombstonesDisabled = true;
        return this;
    }

    public EventuallyConsistentMapBuilder<K, V> withAntiEntropyPeriod(long period, TimeUnit unit) {
        Preconditions.checkArgument((period > 0L ? 1 : 0) != 0, (Object)"anti-entropy period must be greater than 0");
        this.antiEntropyPeriod = period;
        this.antiEntropyTimeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)unit)));
        return this;
    }

    public EventuallyConsistentMapBuilder<K, V> withFasterConvergence() {
        this.convergeFaster = true;
        return this;
    }

    public EventuallyConsistentMapBuilder<K, V> withPersistence() {
        Preconditions.checkNotNull((Object)this.persistenceService);
        this.persistent = true;
        return this;
    }

    public EventuallyConsistentMap<K, V> build() {
        Preconditions.checkNotNull((Object)this.name, (Object)"name is a mandatory parameter");
        Preconditions.checkNotNull((Object)this.serializerBuilder, (Object)"serializerBuilder is a mandatory parameter");
        Preconditions.checkNotNull(this.timestampProvider, (Object)"timestampProvider is a mandatory parameter");
        return new EventuallyConsistentMapImpl<K, V>(this.name, this.clusterService, this.clusterCommunicator, this.serializerBuilder, this.timestampProvider, this.peerUpdateFunction, this.eventExecutor, this.communicationExecutor, this.backgroundExecutor, this.tombstonesDisabled, this.antiEntropyPeriod, this.antiEntropyTimeUnit, this.convergeFaster, this.persistent, this.persistenceService);
    }
}

