/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterMetadata;
import org.onosproject.cluster.ClusterMetadataDiff;
import org.onosproject.cluster.ClusterMetadataEvent;
import org.onosproject.cluster.ClusterMetadataEventListener;
import org.onosproject.cluster.ClusterMetadataService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.Partition;
import org.onosproject.cluster.PartitionDiff;
import org.onosproject.cluster.PartitionId;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.cluster.messaging.MessagingService;
import org.onosproject.store.primitives.DistributedPrimitiveCreator;
import org.onosproject.store.primitives.PartitionAdminService;
import org.onosproject.store.primitives.PartitionEvent;
import org.onosproject.store.primitives.PartitionEventListener;
import org.onosproject.store.primitives.PartitionService;
import org.onosproject.store.primitives.impl.CatalystSerializers;
import org.onosproject.store.primitives.impl.StoragePartition;
import org.onosproject.store.service.PartitionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class PartitionManager
extends AbstractListenerManager<PartitionEvent, PartitionEventListener>
implements PartitionService,
PartitionAdminService {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MessagingService messagingService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterMetadataService metadataService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    private final Map<PartitionId, StoragePartition> partitions = Maps.newConcurrentMap();
    private final AtomicReference<ClusterMetadata> currentClusterMetadata = new AtomicReference();
    private final InternalClusterMetadataListener metadataListener = new InternalClusterMetadataListener();

    @Activate
    public void activate() {
        this.eventDispatcher.addSink(PartitionEvent.class, (EventSink)this.listenerRegistry);
        this.currentClusterMetadata.set(this.metadataService.getClusterMetadata());
        this.metadataService.addListener((EventListener)this.metadataListener);
        this.currentClusterMetadata.get().getPartitions().stream().filter(partition -> !partition.getId().equals((Object)PartitionId.from((int)0))).forEach(partition -> this.partitions.put(partition.getId(), new StoragePartition((Partition)partition, this.messagingService, this.clusterService, CatalystSerializers.getSerializer(), new File(System.getProperty("karaf.data") + "/data/" + partition.getId()))));
        CompletableFuture<Void> openFuture = CompletableFuture.allOf((CompletableFuture[])this.partitions.values().stream().map(StoragePartition::open).toArray(CompletableFuture[]::new));
        openFuture.join();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.metadataService.removeListener((EventListener)this.metadataListener);
        this.eventDispatcher.removeSink(PartitionEvent.class);
        CompletableFuture<Void> closeFuture = CompletableFuture.allOf((CompletableFuture[])this.partitions.values().stream().map(StoragePartition::close).toArray(CompletableFuture[]::new));
        closeFuture.join();
        this.log.info("Stopped");
    }

    public int getNumberOfPartitions() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PARTITION_READ);
        return this.partitions.size();
    }

    public Set<PartitionId> getAllPartitionIds() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PARTITION_READ);
        return this.partitions.keySet();
    }

    public DistributedPrimitiveCreator getDistributedPrimitiveCreator(PartitionId partitionId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PARTITION_READ);
        return this.partitions.get(partitionId).client();
    }

    public Set<NodeId> getConfiguredMembers(PartitionId partitionId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PARTITION_READ);
        StoragePartition partition = this.partitions.get(partitionId);
        return ImmutableSet.copyOf(partition.getMembers());
    }

    public Set<NodeId> getActiveMembersMembers(PartitionId partitionId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PARTITION_READ);
        return this.getConfiguredMembers(partitionId);
    }

    public List<PartitionInfo> partitionInfo() {
        return this.partitions.values().stream().flatMap(x -> Tools.stream(x.info())).collect(Collectors.toList());
    }

    private void processMetadataUpdate(ClusterMetadata clusterMetadata) {
        ClusterMetadataDiff diffExaminer = new ClusterMetadataDiff(this.currentClusterMetadata.get(), clusterMetadata);
        diffExaminer.partitionDiffs().values().stream().filter(diff -> !diff.partitionId().equals((Object)PartitionId.from((int)0))).filter(PartitionDiff::hasChanged).forEach(diff -> this.partitions.get(diff.partitionId()).onUpdate(diff.newValue()));
    }

    protected void bindMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    protected void unbindMessagingService(MessagingService messagingService) {
        if (this.messagingService == messagingService) {
            this.messagingService = null;
        }
    }

    protected void bindMetadataService(ClusterMetadataService clusterMetadataService) {
        this.metadataService = clusterMetadataService;
    }

    protected void unbindMetadataService(ClusterMetadataService clusterMetadataService) {
        if (this.metadataService == clusterMetadataService) {
            this.metadataService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    private class InternalClusterMetadataListener
    implements ClusterMetadataEventListener {
        private InternalClusterMetadataListener() {
        }

        public void event(ClusterMetadataEvent event) {
            PartitionManager.this.processMetadataUpdate((ClusterMetadata)event.subject());
        }
    }
}

