/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.collect.Sets;
import io.atomix.catalyst.util.Listener;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceTypeInfo;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Change;
import org.onosproject.store.primitives.resources.impl.AtomixLeaderElectorCommands;
import org.onosproject.store.primitives.resources.impl.AtomixLeaderElectorState;
import org.onosproject.store.service.AsyncLeaderElector;

@ResourceTypeInfo(id=-152, stateMachine=AtomixLeaderElectorState.class, typeResolver=AtomixLeaderElectorCommands.TypeResolver.class)
public class AtomixLeaderElector
extends Resource<AtomixLeaderElector>
implements AsyncLeaderElector {
    private final Set<Consumer<Change<Leadership>>> leadershipChangeListeners = Sets.newConcurrentHashSet();
    public static final String CHANGE_SUBJECT = "leadershipChangeEvents";
    private Listener<Change<Leadership>> listener;

    public AtomixLeaderElector(CopycatClient client, Resource.Options options) {
        super(client, options);
    }

    public String name() {
        return null;
    }

    public CompletableFuture<AtomixLeaderElector> open() {
        return super.open().thenApply(result -> {
            this.client.onEvent(CHANGE_SUBJECT, this::handleEvent);
            return result;
        });
    }

    private void handleEvent(List<Change<Leadership>> changes) {
        changes.forEach(change -> this.leadershipChangeListeners.forEach(l -> l.accept(change)));
    }

    public CompletableFuture<Leadership> run(String topic, NodeId nodeId) {
        return this.submit(new AtomixLeaderElectorCommands.Run(topic, nodeId));
    }

    public CompletableFuture<Void> withdraw(String topic) {
        return this.submit(new AtomixLeaderElectorCommands.Withdraw(topic));
    }

    public CompletableFuture<Boolean> anoint(String topic, NodeId nodeId) {
        return this.submit(new AtomixLeaderElectorCommands.Anoint(topic, nodeId));
    }

    public CompletableFuture<Boolean> promote(String topic, NodeId nodeId) {
        return this.submit(new AtomixLeaderElectorCommands.Promote(topic, nodeId));
    }

    public CompletableFuture<Void> evict(NodeId nodeId) {
        return this.submit(new AtomixLeaderElectorCommands.Evict(nodeId));
    }

    public CompletableFuture<Leadership> getLeadership(String topic) {
        return this.submit(new AtomixLeaderElectorCommands.GetLeadership(topic));
    }

    public CompletableFuture<Map<String, Leadership>> getLeaderships() {
        return this.submit(new AtomixLeaderElectorCommands.GetAllLeaderships());
    }

    public CompletableFuture<Set<String>> getElectedTopics(NodeId nodeId) {
        return this.submit(new AtomixLeaderElectorCommands.GetElectedTopics(nodeId));
    }

    public synchronized CompletableFuture<Void> addChangeListener(Consumer<Change<Leadership>> consumer) {
        if (this.leadershipChangeListeners.isEmpty()) {
            return this.submit(new AtomixLeaderElectorCommands.Listen()).thenRun(() -> this.leadershipChangeListeners.add(consumer));
        }
        this.leadershipChangeListeners.add(consumer);
        return CompletableFuture.completedFuture(null);
    }

    public synchronized CompletableFuture<Void> removeChangeListener(Consumer<Change<Leadership>> consumer) {
        if (this.leadershipChangeListeners.remove(this.listener) && this.leadershipChangeListeners.isEmpty()) {
            return this.submit(new AtomixLeaderElectorCommands.Unlisten()).thenApply(v -> null);
        }
        return CompletableFuture.completedFuture(null);
    }
}

