/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import java.util.Map;
import java.util.Set;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.NodeId;

public final class AtomixLeaderElectorCommands {
    private AtomixLeaderElectorCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        public void resolve(SerializerRegistry registry) {
            registry.register(Run.class, -861);
            registry.register(Withdraw.class, -862);
            registry.register(Anoint.class, -863);
            registry.register(GetAllLeaderships.class, -864);
            registry.register(GetElectedTopics.class, -865);
            registry.register(GetLeadership.class, -866);
            registry.register(Listen.class, -867);
            registry.register(Unlisten.class, -868);
            registry.register(Promote.class, -869);
            registry.register(Evict.class, -870);
        }
    }

    public static class Evict
    extends ElectionCommand<Void> {
        private NodeId nodeId;

        public Evict() {
        }

        public Evict(NodeId nodeId) {
            this.nodeId = nodeId;
        }

        public NodeId nodeId() {
            return this.nodeId;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("nodeId", (Object)this.nodeId).toString();
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            buffer.writeString(this.nodeId.toString());
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.nodeId = new NodeId(buffer.readString());
        }
    }

    public static class Promote
    extends ElectionChangeCommand<Boolean> {
        private Promote() {
        }

        public Promote(String topic, NodeId nodeId) {
            super(topic, nodeId);
        }
    }

    public static class Anoint
    extends ElectionChangeCommand<Boolean> {
        private Anoint() {
        }

        public Anoint(String topic, NodeId nodeId) {
            super(topic, nodeId);
        }
    }

    public static abstract class ElectionChangeCommand<V>
    extends ElectionCommand<V> {
        private String topic;
        private NodeId nodeId;

        ElectionChangeCommand() {
            this.topic = null;
            this.nodeId = null;
        }

        public ElectionChangeCommand(String topic, NodeId nodeId) {
            this.topic = topic;
            this.nodeId = nodeId;
        }

        public String topic() {
            return this.topic;
        }

        public NodeId nodeId() {
            return this.nodeId;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("topic", (Object)this.topic).add("nodeId", (Object)this.nodeId).toString();
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            buffer.writeString(this.topic);
            buffer.writeString(this.nodeId.toString());
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.topic = buffer.readString();
            this.nodeId = new NodeId(buffer.readString());
        }
    }

    public static class Withdraw
    extends ElectionCommand<Void> {
        private String topic;

        public Withdraw() {
        }

        public Withdraw(String topic) {
            this.topic = (String)Assert.argNot((Object)topic, (boolean)Strings.isNullOrEmpty((String)topic), (String)"topic cannot be null or empty", (Object[])new Object[0]);
        }

        public String topic() {
            return this.topic;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("topic", (Object)this.topic).toString();
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            buffer.writeString(this.topic);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.topic = buffer.readString();
        }
    }

    public static class Run
    extends ElectionCommand<Leadership> {
        private String topic;
        private NodeId nodeId;

        public Run() {
        }

        public Run(String topic, NodeId nodeId) {
            this.topic = (String)Assert.argNot((Object)topic, (boolean)Strings.isNullOrEmpty((String)topic), (String)"topic cannot be null or empty", (Object[])new Object[0]);
            this.nodeId = (NodeId)Assert.argNot((Object)nodeId, (nodeId == null ? 1 : 0) != 0, (String)"nodeId cannot be null", (Object[])new Object[0]);
        }

        public String topic() {
            return this.topic;
        }

        public NodeId nodeId() {
            return this.nodeId;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("topic", (Object)this.topic).add("nodeId", (Object)this.nodeId).toString();
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            buffer.writeString(this.topic);
            buffer.writeString(this.nodeId.toString());
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.topic = buffer.readString();
            this.nodeId = new NodeId(buffer.readString());
        }
    }

    public static class GetElectedTopics
    extends ElectionQuery<Set<String>> {
        private NodeId nodeId;

        public GetElectedTopics() {
        }

        public GetElectedTopics(NodeId nodeId) {
            this.nodeId = (NodeId)Assert.argNot((Object)nodeId, (nodeId == null ? 1 : 0) != 0, (String)"nodeId cannot be null", (Object[])new Object[0]);
        }

        public NodeId nodeId() {
            return this.nodeId;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("nodeId", (Object)this.nodeId).toString();
        }
    }

    public static class GetAllLeaderships
    extends ElectionQuery<Map<String, Leadership>> {
    }

    public static class GetLeadership
    extends TopicQuery<Leadership> {
        public GetLeadership() {
        }

        public GetLeadership(String topic) {
            super(topic);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("topic", (Object)this.topic).toString();
        }
    }

    public static class Unlisten
    extends ElectionCommand<Void> {
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }
    }

    public static class Listen
    extends ElectionCommand<Void> {
    }

    public static abstract class ElectionCommand<V>
    implements Command<V>,
    CatalystSerializable {
        public Command.ConsistencyLevel consistency() {
            return Command.ConsistencyLevel.LINEARIZABLE;
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }

    public static abstract class TopicQuery<V>
    extends ElectionQuery<V>
    implements CatalystSerializable {
        String topic;

        public TopicQuery() {
        }

        public TopicQuery(String topic) {
            this.topic = (String)Assert.notNull((Object)topic, (String)"topic");
        }

        public String topic() {
            return this.topic;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            serializer.writeObject((Object)this.topic, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.topic = (String)serializer.readObject(buffer);
        }
    }

    public static abstract class ElectionQuery<V>
    implements Query<V>,
    CatalystSerializable {
        public Query.ConsistencyLevel consistency() {
            return Query.ConsistencyLevel.BOUNDED_LINEARIZABLE;
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }
}

