/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import io.atomix.AtomixClient;
import io.atomix.resource.ResourceType;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Change;
import org.onosproject.store.primitives.resources.impl.AtomixLeaderElector;
import org.onosproject.store.primitives.resources.impl.AtomixTestBase;

@Ignore
public class AtomixLeaderElectorTest
extends AtomixTestBase {
    NodeId node1 = new NodeId("node1");
    NodeId node2 = new NodeId("node2");
    NodeId node3 = new NodeId("node3");

    @Override
    protected ResourceType resourceType() {
        return new ResourceType(AtomixLeaderElector.class);
    }

    @Test
    public void testRun() throws Throwable {
        this.leaderElectorRunTests(3);
    }

    private void leaderElectorRunTests(int numServers) throws Throwable {
        this.createCopycatServers(numServers);
        AtomixClient client1 = this.createAtomixClient();
        AtomixLeaderElector elector1 = (AtomixLeaderElector)client1.getResource("test-elector", AtomixLeaderElector.class).join();
        ((CompletableFuture)elector1.run("foo", this.node1).thenAccept(result -> {
            Assert.assertEquals((Object)this.node1, (Object)result.leaderNodeId());
            Assert.assertEquals((long)1L, (long)result.leader().term());
            Assert.assertEquals((long)1L, (long)result.candidates().size());
            Assert.assertEquals((Object)this.node1, result.candidates().get(0));
        })).join();
        AtomixClient client2 = this.createAtomixClient();
        AtomixLeaderElector elector2 = (AtomixLeaderElector)client2.getResource("test-elector", AtomixLeaderElector.class).join();
        ((CompletableFuture)elector2.run("foo", this.node2).thenAccept(result -> {
            Assert.assertEquals((Object)this.node1, (Object)result.leaderNodeId());
            Assert.assertEquals((long)1L, (long)result.leader().term());
            Assert.assertEquals((long)2L, (long)result.candidates().size());
            Assert.assertEquals((Object)this.node1, result.candidates().get(0));
            Assert.assertEquals((Object)this.node2, result.candidates().get(1));
        })).join();
    }

    @Test
    public void testWithdraw() throws Throwable {
        this.leaderElectorWithdrawTests(3);
    }

    private void leaderElectorWithdrawTests(int numServers) throws Throwable {
        this.createCopycatServers(numServers);
        AtomixClient client1 = this.createAtomixClient();
        AtomixLeaderElector elector1 = (AtomixLeaderElector)client1.getResource("test-elector", AtomixLeaderElector.class).join();
        elector1.run("foo", this.node1).join();
        AtomixClient client2 = this.createAtomixClient();
        AtomixLeaderElector elector2 = (AtomixLeaderElector)client2.getResource("test-elector", AtomixLeaderElector.class).join();
        elector2.run("foo", this.node2).join();
        LeaderEventListener listener1 = new LeaderEventListener();
        elector1.addChangeListener((Consumer)listener1).join();
        LeaderEventListener listener2 = new LeaderEventListener();
        elector2.addChangeListener((Consumer)listener2).join();
        elector1.withdraw("foo").join();
        ((CompletableFuture)listener1.nextEvent().thenAccept(result -> {
            Assert.assertEquals((Object)this.node2, (Object)((Leadership)result.newValue()).leaderNodeId());
            Assert.assertEquals((long)2L, (long)((Leadership)result.newValue()).leader().term());
            Assert.assertEquals((long)1L, (long)((Leadership)result.newValue()).candidates().size());
            Assert.assertEquals((Object)this.node2, ((Leadership)result.newValue()).candidates().get(0));
        })).join();
        ((CompletableFuture)listener2.nextEvent().thenAccept(result -> {
            Assert.assertEquals((Object)this.node2, (Object)((Leadership)result.newValue()).leaderNodeId());
            Assert.assertEquals((long)2L, (long)((Leadership)result.newValue()).leader().term());
            Assert.assertEquals((long)1L, (long)((Leadership)result.newValue()).candidates().size());
            Assert.assertEquals((Object)this.node2, ((Leadership)result.newValue()).candidates().get(0));
        })).join();
    }

    @Test
    public void testAnoint() throws Throwable {
        this.leaderElectorAnointTests(3);
    }

    private void leaderElectorAnointTests(int numServers) throws Throwable {
        this.createCopycatServers(numServers);
        AtomixClient client1 = this.createAtomixClient();
        AtomixLeaderElector elector1 = (AtomixLeaderElector)client1.getResource("test-elector", AtomixLeaderElector.class).join();
        AtomixClient client2 = this.createAtomixClient();
        AtomixLeaderElector elector2 = (AtomixLeaderElector)client2.getResource("test-elector", AtomixLeaderElector.class).join();
        AtomixClient client3 = this.createAtomixClient();
        AtomixLeaderElector elector3 = (AtomixLeaderElector)client3.getResource("test-elector", AtomixLeaderElector.class).join();
        elector1.run("foo", this.node1).join();
        elector2.run("foo", this.node2).join();
        LeaderEventListener listener1 = new LeaderEventListener();
        elector1.addChangeListener((Consumer)listener1).join();
        LeaderEventListener listener2 = new LeaderEventListener();
        elector2.addChangeListener((Consumer)listener2);
        LeaderEventListener listener3 = new LeaderEventListener();
        elector3.addChangeListener((Consumer)listener3).join();
        ((CompletableFuture)elector3.anoint("foo", this.node3).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        Assert.assertFalse((boolean)listener1.hasEvent());
        Assert.assertFalse((boolean)listener2.hasEvent());
        Assert.assertFalse((boolean)listener3.hasEvent());
        ((CompletableFuture)elector3.anoint("foo", this.node2).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        ((CompletableFuture)listener1.nextEvent().thenAccept(result -> {
            Assert.assertEquals((Object)this.node2, (Object)((Leadership)result.newValue()).leaderNodeId());
            Assert.assertEquals((long)2L, (long)((Leadership)result.newValue()).candidates().size());
            Assert.assertEquals((Object)this.node1, ((Leadership)result.newValue()).candidates().get(0));
            Assert.assertEquals((Object)this.node2, ((Leadership)result.newValue()).candidates().get(1));
        })).join();
        ((CompletableFuture)listener2.nextEvent().thenAccept(result -> {
            Assert.assertEquals((Object)this.node2, (Object)((Leadership)result.newValue()).leaderNodeId());
            Assert.assertEquals((long)2L, (long)((Leadership)result.newValue()).candidates().size());
            Assert.assertEquals((Object)this.node1, ((Leadership)result.newValue()).candidates().get(0));
            Assert.assertEquals((Object)this.node2, ((Leadership)result.newValue()).candidates().get(1));
        })).join();
        ((CompletableFuture)listener3.nextEvent().thenAccept(result -> {
            Assert.assertEquals((Object)this.node2, (Object)((Leadership)result.newValue()).leaderNodeId());
            Assert.assertEquals((long)2L, (long)((Leadership)result.newValue()).candidates().size());
            Assert.assertEquals((Object)this.node1, ((Leadership)result.newValue()).candidates().get(0));
            Assert.assertEquals((Object)this.node2, ((Leadership)result.newValue()).candidates().get(1));
        })).join();
    }

    @Test
    public void testPromote() throws Throwable {
        this.leaderElectorPromoteTests(3);
    }

    private void leaderElectorPromoteTests(int numServers) throws Throwable {
        this.createCopycatServers(numServers);
        AtomixClient client1 = this.createAtomixClient();
        AtomixLeaderElector elector1 = (AtomixLeaderElector)client1.getResource("test-elector", AtomixLeaderElector.class).join();
        AtomixClient client2 = this.createAtomixClient();
        AtomixLeaderElector elector2 = (AtomixLeaderElector)client2.getResource("test-elector", AtomixLeaderElector.class).join();
        AtomixClient client3 = this.createAtomixClient();
        AtomixLeaderElector elector3 = (AtomixLeaderElector)client3.getResource("test-elector", AtomixLeaderElector.class).join();
        elector1.run("foo", this.node1).join();
        elector2.run("foo", this.node2).join();
        LeaderEventListener listener1 = new LeaderEventListener();
        elector1.addChangeListener((Consumer)listener1).join();
        LeaderEventListener listener2 = new LeaderEventListener();
        elector2.addChangeListener((Consumer)listener2).join();
        LeaderEventListener listener3 = new LeaderEventListener();
        elector3.addChangeListener((Consumer)listener3).join();
        ((CompletableFuture)elector3.promote("foo", this.node3).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        Assert.assertFalse((boolean)listener1.hasEvent());
        Assert.assertFalse((boolean)listener2.hasEvent());
        Assert.assertFalse((boolean)listener3.hasEvent());
        elector3.run("foo", this.node3).join();
        ((CompletableFuture)listener1.nextEvent().thenAccept(result -> Assert.assertEquals((Object)this.node3, ((Leadership)result.newValue()).candidates().get(2)))).join();
        ((CompletableFuture)listener2.nextEvent().thenAccept(result -> Assert.assertEquals((Object)this.node3, ((Leadership)result.newValue()).candidates().get(2)))).join();
        ((CompletableFuture)listener3.nextEvent().thenAccept(result -> Assert.assertEquals((Object)this.node3, ((Leadership)result.newValue()).candidates().get(2)))).join();
        ((CompletableFuture)elector3.promote("foo", this.node3).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        ((CompletableFuture)listener1.nextEvent().thenAccept(result -> Assert.assertEquals((Object)this.node3, ((Leadership)result.newValue()).candidates().get(0)))).join();
        ((CompletableFuture)listener2.nextEvent().thenAccept(result -> Assert.assertEquals((Object)this.node3, ((Leadership)result.newValue()).candidates().get(0)))).join();
        ((CompletableFuture)listener3.nextEvent().thenAccept(result -> Assert.assertEquals((Object)this.node3, ((Leadership)result.newValue()).candidates().get(0)))).join();
    }

    @Test
    public void testLeaderSessionClose() throws Throwable {
        this.leaderElectorLeaderSessionCloseTests(3);
    }

    private void leaderElectorLeaderSessionCloseTests(int numServers) throws Throwable {
        this.createCopycatServers(numServers);
        AtomixClient client1 = this.createAtomixClient();
        AtomixLeaderElector elector1 = (AtomixLeaderElector)client1.getResource("test-elector", AtomixLeaderElector.class).join();
        elector1.run("foo", this.node1).join();
        AtomixClient client2 = this.createAtomixClient();
        AtomixLeaderElector elector2 = (AtomixLeaderElector)client2.getResource("test-elector", AtomixLeaderElector.class).join();
        LeaderEventListener listener = new LeaderEventListener();
        elector2.run("foo", this.node2).join();
        elector2.addChangeListener((Consumer)listener).join();
        client1.close();
        ((CompletableFuture)listener.nextEvent().thenAccept(result -> {
            Assert.assertEquals((Object)this.node2, (Object)((Leadership)result.newValue()).leaderNodeId());
            Assert.assertEquals((long)1L, (long)((Leadership)result.newValue()).candidates().size());
            Assert.assertEquals((Object)this.node2, ((Leadership)result.newValue()).candidates().get(0));
        })).join();
    }

    @Test
    public void testNonLeaderSessionClose() throws Throwable {
        this.leaderElectorNonLeaderSessionCloseTests(3);
    }

    private void leaderElectorNonLeaderSessionCloseTests(int numServers) throws Throwable {
        this.createCopycatServers(numServers);
        AtomixClient client1 = this.createAtomixClient();
        AtomixLeaderElector elector1 = (AtomixLeaderElector)client1.getResource("test-elector", AtomixLeaderElector.class).join();
        elector1.run("foo", this.node1).join();
        AtomixClient client2 = this.createAtomixClient();
        AtomixLeaderElector elector2 = (AtomixLeaderElector)client2.getResource("test-elector", AtomixLeaderElector.class).join();
        LeaderEventListener listener = new LeaderEventListener();
        elector2.run("foo", this.node2).join();
        elector1.addChangeListener((Consumer)listener).join();
        client2.close().join();
        ((CompletableFuture)listener.nextEvent().thenAccept(result -> {
            Assert.assertEquals((Object)this.node1, (Object)((Leadership)result.newValue()).leaderNodeId());
            Assert.assertEquals((long)1L, (long)((Leadership)result.newValue()).candidates().size());
            Assert.assertEquals((Object)this.node1, ((Leadership)result.newValue()).candidates().get(0));
        })).join();
    }

    @Test
    public void testQueries() throws Throwable {
        this.leaderElectorQueryTests(3);
    }

    private void leaderElectorQueryTests(int numServers) throws Throwable {
        this.createCopycatServers(numServers);
        AtomixClient client1 = this.createAtomixClient();
        AtomixClient client2 = this.createAtomixClient();
        AtomixLeaderElector elector1 = (AtomixLeaderElector)client1.getResource("test-elector", AtomixLeaderElector.class).join();
        AtomixLeaderElector elector2 = (AtomixLeaderElector)client2.getResource("test-elector", AtomixLeaderElector.class).join();
        elector1.run("foo", this.node1).join();
        elector2.run("foo", this.node2).join();
        elector2.run("bar", this.node2).join();
        ((CompletableFuture)elector1.getElectedTopics(this.node1).thenAccept(result -> {
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertTrue((boolean)result.contains("foo"));
        })).join();
        ((CompletableFuture)elector2.getElectedTopics(this.node1).thenAccept(result -> {
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertTrue((boolean)result.contains("foo"));
        })).join();
        ((CompletableFuture)elector1.getLeadership("foo").thenAccept(result -> {
            Assert.assertEquals((Object)this.node1, (Object)result.leaderNodeId());
            Assert.assertEquals((Object)this.node1, result.candidates().get(0));
            Assert.assertEquals((Object)this.node2, result.candidates().get(1));
        })).join();
        ((CompletableFuture)elector2.getLeadership("foo").thenAccept(result -> {
            Assert.assertEquals((Object)this.node1, (Object)result.leaderNodeId());
            Assert.assertEquals((Object)this.node1, result.candidates().get(0));
            Assert.assertEquals((Object)this.node2, result.candidates().get(1));
        })).join();
        ((CompletableFuture)elector1.getLeadership("bar").thenAccept(result -> {
            Assert.assertEquals((Object)this.node2, (Object)result.leaderNodeId());
            Assert.assertEquals((Object)this.node2, result.candidates().get(0));
        })).join();
        ((CompletableFuture)elector2.getLeadership("bar").thenAccept(result -> {
            Assert.assertEquals((Object)this.node2, (Object)result.leaderNodeId());
            Assert.assertEquals((Object)this.node2, result.candidates().get(0));
        })).join();
        ((CompletableFuture)elector1.getLeaderships().thenAccept(result -> {
            Assert.assertEquals((long)2L, (long)result.size());
            Leadership fooLeadership = (Leadership)result.get("foo");
            Assert.assertEquals((Object)this.node1, (Object)fooLeadership.leaderNodeId());
            Assert.assertEquals((Object)this.node1, fooLeadership.candidates().get(0));
            Assert.assertEquals((Object)this.node2, fooLeadership.candidates().get(1));
            Leadership barLeadership = (Leadership)result.get("bar");
            Assert.assertEquals((Object)this.node2, (Object)barLeadership.leaderNodeId());
            Assert.assertEquals((Object)this.node2, barLeadership.candidates().get(0));
        })).join();
        ((CompletableFuture)elector2.getLeaderships().thenAccept(result -> {
            Assert.assertEquals((long)2L, (long)result.size());
            Leadership fooLeadership = (Leadership)result.get("foo");
            Assert.assertEquals((Object)this.node1, (Object)fooLeadership.leaderNodeId());
            Assert.assertEquals((Object)this.node1, fooLeadership.candidates().get(0));
            Assert.assertEquals((Object)this.node2, fooLeadership.candidates().get(1));
            Leadership barLeadership = (Leadership)result.get("bar");
            Assert.assertEquals((Object)this.node2, (Object)barLeadership.leaderNodeId());
            Assert.assertEquals((Object)this.node2, barLeadership.candidates().get(0));
        })).join();
    }

    private static class LeaderEventListener
    implements Consumer<Change<Leadership>> {
        Queue<Change<Leadership>> eventQueue = new LinkedList<Change<Leadership>>();
        CompletableFuture<Change<Leadership>> pendingFuture;

        private LeaderEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Change<Leadership> change) {
            LeaderEventListener leaderEventListener = this;
            synchronized (leaderEventListener) {
                if (this.pendingFuture != null) {
                    this.pendingFuture.complete(change);
                    this.pendingFuture = null;
                } else {
                    this.eventQueue.add(change);
                }
            }
        }

        public boolean hasEvent() {
            return !this.eventQueue.isEmpty();
        }

        public void clearEvents() {
            this.eventQueue.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletableFuture<Change<Leadership>> nextEvent() {
            LeaderEventListener leaderEventListener = this;
            synchronized (leaderEventListener) {
                if (this.eventQueue.isEmpty()) {
                    if (this.pendingFuture == null) {
                        this.pendingFuture = new CompletableFuture();
                    }
                    return this.pendingFuture;
                }
                return CompletableFuture.completedFuture(this.eventQueue.poll());
            }
        }
    }
}

