/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Throwables;
import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.TypeSerializer;
import io.atomix.catalyst.serializer.TypeSerializerFactory;
import org.onosproject.store.service.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCatalystTypeSerializerFactory
implements TypeSerializerFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TypeSerializer<?> typeSerializer;

    public DefaultCatalystTypeSerializerFactory(Serializer serializer) {
        this.typeSerializer = new InternalSerializer(serializer);
    }

    public TypeSerializer<?> createSerializer(Class<?> clazz) {
        return this.typeSerializer;
    }

    private class InternalSerializer<T>
    implements TypeSerializer<T> {
        private final Serializer serializer;

        InternalSerializer(Serializer serializer) {
            this.serializer = serializer;
        }

        public void write(T object, BufferOutput buffer, io.atomix.catalyst.serializer.Serializer serializer) {
            try {
                byte[] payload = this.serializer.encode(object);
                buffer.writeInt(payload.length);
                buffer.write(payload);
            }
            catch (Exception e) {
                DefaultCatalystTypeSerializerFactory.this.log.warn("Failed to serialize {}", object, (Object)e);
            }
        }

        public T read(Class<T> type, BufferInput buffer, io.atomix.catalyst.serializer.Serializer serializer) {
            int size = buffer.readInt();
            try {
                byte[] payload = new byte[size];
                buffer.read(payload);
                return (T)this.serializer.decode(payload);
            }
            catch (Exception e) {
                DefaultCatalystTypeSerializerFactory.this.log.warn("Failed to deserialize as type {}. Payload size: {}", new Object[]{type, size, e});
                Throwables.propagate((Throwable)e);
                return null;
            }
        }
    }
}

