/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Preconditions;
import org.onosproject.store.primitives.DistributedPrimitiveCreator;
import org.onosproject.store.service.DistributedQueue;
import org.onosproject.store.service.DistributedQueueBuilder;
import org.onosproject.store.service.Serializer;

public class DefaultDistributedQueueBuilder<E>
implements DistributedQueueBuilder<E> {
    private final DistributedPrimitiveCreator primitiveCreator;
    private String name;
    private Serializer serializer;

    public DefaultDistributedQueueBuilder(DistributedPrimitiveCreator primitiveCreator) {
        this.primitiveCreator = primitiveCreator;
    }

    public DistributedQueueBuilder<E> withName(String name) {
        Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0);
        this.name = name;
        return this;
    }

    public DistributedQueueBuilder<E> withSerializer(Serializer serializer) {
        Preconditions.checkArgument((serializer != null ? 1 : 0) != 0);
        this.serializer = serializer;
        return this;
    }

    private boolean validInputs() {
        return this.name != null && this.serializer != null;
    }

    public DistributedQueue<E> build() {
        Preconditions.checkState((boolean)this.validInputs());
        return this.primitiveCreator.newDistributedQueue(this.name, this.serializer);
    }
}

