/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import java.util.function.Supplier;
import org.onosproject.core.ApplicationId;
import org.onosproject.store.primitives.impl.DefaultAsyncDistributedSet;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.Serializer;

public class DefaultDistributedSetBuilder<E>
extends DistributedSetBuilder<E> {
    private String name;
    private ConsistentMapBuilder<E, Boolean> mapBuilder;
    private boolean metering = true;

    public DefaultDistributedSetBuilder(Supplier<ConsistentMapBuilder<E, Boolean>> mapBuilderSupplier) {
        this.mapBuilder = mapBuilderSupplier.get();
        this.mapBuilder.withMeteringDisabled();
    }

    public DistributedSetBuilder<E> withName(String name) {
        this.mapBuilder.withName(name);
        this.name = name;
        return this;
    }

    public DistributedSetBuilder<E> withApplicationId(ApplicationId id) {
        this.mapBuilder.withApplicationId(id);
        return this;
    }

    public DistributedSetBuilder<E> withPurgeOnUninstall() {
        this.mapBuilder.withPurgeOnUninstall();
        return this;
    }

    public DistributedSetBuilder<E> withSerializer(Serializer serializer) {
        this.mapBuilder.withSerializer(serializer);
        return this;
    }

    public DistributedSetBuilder<E> withUpdatesDisabled() {
        this.mapBuilder.withUpdatesDisabled();
        return this;
    }

    public DistributedSetBuilder<E> withRelaxedReadConsistency() {
        this.mapBuilder.withRelaxedReadConsistency();
        return this;
    }

    public DistributedSetBuilder<E> withPartitionsDisabled() {
        this.mapBuilder.withPartitionsDisabled();
        return this;
    }

    public DistributedSetBuilder<E> withMeteringDisabled() {
        this.metering = false;
        return this;
    }

    public AsyncDistributedSet<E> build() {
        return new DefaultAsyncDistributedSet(this.mapBuilder.buildAsyncMap(), this.name, this.metering);
    }
}

