/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.onlab.util.HexString;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.impl.TransactionParticipant;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.MapTransaction;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionalMap;
import org.onosproject.store.service.Versioned;

public class DefaultTransactionalMap<K, V>
implements TransactionalMap<K, V>,
TransactionParticipant {
    private final TransactionContext txContext;
    private static final String TX_CLOSED_ERROR = "Transaction is closed";
    private final AsyncConsistentMap<K, V> backingMap;
    private final ConsistentMap<K, V> backingConsitentMap;
    private final String name;
    private final Serializer serializer;
    private final Map<K, Versioned<V>> readCache = Maps.newConcurrentMap();
    private final Map<K, V> writeCache = Maps.newConcurrentMap();
    private final Set<K> deleteSet = Sets.newConcurrentHashSet();
    private static final String ERROR_NULL_VALUE = "Null values are not allowed";
    private static final String ERROR_NULL_KEY = "Null key is not allowed";
    private final LoadingCache<K, String> keyCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<K, String>(){

        public String load(K key) {
            return HexString.toHexString((byte[])DefaultTransactionalMap.this.serializer.encode(key));
        }
    });

    protected K dK(String key) {
        return (K)this.serializer.decode(HexString.fromHexString((String)key));
    }

    public DefaultTransactionalMap(String name, AsyncConsistentMap<K, V> backingMap, TransactionContext txContext, Serializer serializer) {
        this.name = name;
        this.backingMap = backingMap;
        this.backingConsitentMap = backingMap.asConsistentMap();
        this.txContext = txContext;
        this.serializer = serializer;
    }

    public V get(K key) {
        Preconditions.checkState((boolean)this.txContext.isOpen(), (Object)TX_CLOSED_ERROR);
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        if (this.deleteSet.contains(key)) {
            return null;
        }
        V latest = this.writeCache.get(key);
        if (latest != null) {
            return latest;
        }
        Versioned v = this.readCache.computeIfAbsent(key, k -> this.backingConsitentMap.get(k));
        return (V)(v != null ? v.value() : null);
    }

    public V put(K key, V value) {
        Preconditions.checkState((boolean)this.txContext.isOpen(), (Object)TX_CLOSED_ERROR);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        V latest = this.get(key);
        this.writeCache.put(key, value);
        this.deleteSet.remove(key);
        return latest;
    }

    public V remove(K key) {
        Preconditions.checkState((boolean)this.txContext.isOpen(), (Object)TX_CLOSED_ERROR);
        V latest = this.get(key);
        if (latest != null) {
            this.writeCache.remove(key);
            this.deleteSet.add(key);
        }
        return latest;
    }

    public boolean remove(K key, V value) {
        Preconditions.checkState((boolean)this.txContext.isOpen(), (Object)TX_CLOSED_ERROR);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        V latest = this.get(key);
        if (Objects.equal(value, latest)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        Preconditions.checkState((boolean)this.txContext.isOpen(), (Object)TX_CLOSED_ERROR);
        Preconditions.checkNotNull(oldValue, (Object)ERROR_NULL_VALUE);
        Preconditions.checkNotNull(newValue, (Object)ERROR_NULL_VALUE);
        V latest = this.get(key);
        if (Objects.equal(oldValue, latest)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    public V putIfAbsent(K key, V value) {
        Preconditions.checkState((boolean)this.txContext.isOpen(), (Object)TX_CLOSED_ERROR);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        V latest = this.get(key);
        if (latest == null) {
            this.put(key, value);
        }
        return latest;
    }

    @Override
    public CompletableFuture<Boolean> prepare() {
        return this.backingMap.prepare(new MapTransaction(this.txContext.transactionId(), this.updates()));
    }

    @Override
    public CompletableFuture<Void> commit() {
        return this.backingMap.commit(this.txContext.transactionId());
    }

    @Override
    public CompletableFuture<Void> rollback() {
        return this.backingMap.rollback(this.txContext.transactionId());
    }

    @Override
    public CompletableFuture<Boolean> prepareAndCommit() {
        return this.backingMap.prepareAndCommit(new MapTransaction(this.txContext.transactionId(), this.updates()));
    }

    @Override
    public int totalUpdates() {
        return this.updates().size();
    }

    @Override
    public boolean hasPendingUpdates() {
        return this.updatesStream().findAny().isPresent();
    }

    protected Stream<MapUpdate<K, V>> updatesStream() {
        return Stream.concat(this.deleteSet.stream().map(key -> Pair.of((Object)key, this.readCache.get(key))).filter(e -> e.getValue() != null).map(e -> MapUpdate.newBuilder().withMapName(this.name).withType(MapUpdate.Type.REMOVE_IF_VERSION_MATCH).withKey(e.getKey()).withCurrentVersion(((Versioned)e.getValue()).version()).build()), this.writeCache.entrySet().stream().map(e -> {
            Versioned<V> original = this.readCache.get(e.getKey());
            if (original == null) {
                return MapUpdate.newBuilder().withMapName(this.name).withType(MapUpdate.Type.PUT_IF_ABSENT).withKey(e.getKey()).withValue(e.getValue()).build();
            }
            return MapUpdate.newBuilder().withMapName(this.name).withType(MapUpdate.Type.PUT_IF_VERSION_MATCH).withKey(e.getKey()).withCurrentVersion(original.version()).withValue(e.getValue()).build();
        }));
    }

    protected List<MapUpdate<K, V>> updates() {
        return this.updatesStream().collect(Collectors.toList());
    }

    protected List<MapUpdate<String, byte[]>> toMapUpdates() {
        LinkedList updates = Lists.newLinkedList();
        this.deleteSet.forEach(key -> {
            Versioned<V> original = this.readCache.get(key);
            if (original != null) {
                updates.add(MapUpdate.newBuilder().withMapName(this.name).withType(MapUpdate.Type.REMOVE_IF_VERSION_MATCH).withKey(this.keyCache.getUnchecked(key)).withCurrentVersion(original.version()).build());
            }
        });
        this.writeCache.forEach((key, value) -> {
            Versioned<V> original = this.readCache.get(key);
            if (original == null) {
                updates.add(MapUpdate.newBuilder().withMapName(this.name).withType(MapUpdate.Type.PUT_IF_ABSENT).withKey(this.keyCache.getUnchecked(key)).withValue((Object)this.serializer.encode(value)).build());
            } else {
                updates.add(MapUpdate.newBuilder().withMapName(this.name).withType(MapUpdate.Type.PUT_IF_VERSION_MATCH).withKey(this.keyCache.getUnchecked(key)).withCurrentVersion(original.version()).withValue((Object)this.serializer.encode(value)).build());
            }
        });
        return updates;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("backingMap", this.backingMap).add("updates", this.updates()).toString();
    }

    protected void abort() {
        this.readCache.clear();
        this.writeCache.clear();
        this.deleteSet.clear();
    }
}

