/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.onosproject.cluster.PartitionId;
import org.onosproject.store.primitives.DistributedPrimitiveCreator;
import org.onosproject.store.primitives.impl.DistributedPrimitives;
import org.onosproject.store.primitives.impl.Hasher;
import org.onosproject.store.primitives.impl.PartitionedAsyncConsistentMap;
import org.onosproject.store.primitives.impl.PartitionedAsyncLeaderElector;
import org.onosproject.store.service.AsyncAtomicCounter;
import org.onosproject.store.service.AsyncAtomicValue;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.AsyncLeaderElector;
import org.onosproject.store.service.DistributedQueue;
import org.onosproject.store.service.Serializer;

public class FederatedDistributedPrimitiveCreator
implements DistributedPrimitiveCreator {
    private final TreeMap<PartitionId, DistributedPrimitiveCreator> members = Maps.newTreeMap();
    private final List<PartitionId> sortedMemberPartitionIds;

    public FederatedDistributedPrimitiveCreator(Map<PartitionId, DistributedPrimitiveCreator> members) {
        this.members.putAll((Map)Preconditions.checkNotNull(members));
        this.sortedMemberPartitionIds = Lists.newArrayList(members.keySet());
    }

    public <K, V> AsyncConsistentMap<K, V> newAsyncConsistentMap(String name, Serializer serializer) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)serializer);
        NavigableMap maps = Maps.transformValues(this.members, partition -> partition.newAsyncConsistentMap(name, serializer));
        Hasher<Object> hasher = key -> {
            int hashCode = Hashing.sha256().hashBytes(serializer.encode(key)).asInt();
            return this.sortedMemberPartitionIds.get(Math.abs(hashCode) % this.members.size());
        };
        return new PartitionedAsyncConsistentMap(name, maps, hasher);
    }

    public <E> AsyncDistributedSet<E> newAsyncDistributedSet(String name, Serializer serializer) {
        return DistributedPrimitives.newSetFromMap(this.newAsyncConsistentMap(name, serializer));
    }

    public AsyncAtomicCounter newAsyncCounter(String name) {
        return this.getCreator(name).newAsyncCounter(name);
    }

    public <V> AsyncAtomicValue<V> newAsyncAtomicValue(String name, Serializer serializer) {
        return this.getCreator(name).newAsyncAtomicValue(name, serializer);
    }

    public <E> DistributedQueue<E> newDistributedQueue(String name, Serializer serializer) {
        return this.getCreator(name).newDistributedQueue(name, serializer);
    }

    public AsyncLeaderElector newAsyncLeaderElector(String name) {
        Preconditions.checkNotNull((Object)name);
        NavigableMap leaderElectors = Maps.transformValues(this.members, partition -> partition.newAsyncLeaderElector(name));
        Hasher<String> hasher = topic -> {
            int hashCode = Hashing.sha256().hashString((CharSequence)topic, Charsets.UTF_8).asInt();
            return this.sortedMemberPartitionIds.get(Math.abs(hashCode) % this.members.size());
        };
        return new PartitionedAsyncLeaderElector(name, leaderElectors, hasher);
    }

    public Set<String> getAsyncConsistentMapNames() {
        return this.members.values().stream().map(DistributedPrimitiveCreator::getAsyncConsistentMapNames).reduce(Sets::union).orElse((Set)ImmutableSet.of());
    }

    public Set<String> getAsyncAtomicCounterNames() {
        return this.members.values().stream().map(DistributedPrimitiveCreator::getAsyncAtomicCounterNames).reduce(Sets::union).orElse((Set)ImmutableSet.of());
    }

    private DistributedPrimitiveCreator getCreator(String name) {
        int hashCode = Hashing.sha256().hashString((CharSequence)name, Charsets.UTF_8).asInt();
        return this.members.get(this.sortedMemberPartitionIds.get(Math.abs(hashCode) % this.members.size()));
    }
}

