/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.onlab.util.Tools;
import org.onosproject.cluster.PartitionId;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.Hasher;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.MapTransaction;
import org.onosproject.store.service.Versioned;

public class PartitionedAsyncConsistentMap<K, V>
implements AsyncConsistentMap<K, V> {
    private final String name;
    private final TreeMap<PartitionId, AsyncConsistentMap<K, V>> partitions = Maps.newTreeMap();
    private final Hasher<K> keyHasher;

    public PartitionedAsyncConsistentMap(String name, Map<PartitionId, AsyncConsistentMap<K, V>> partitions, Hasher<K> keyHasher) {
        this.name = name;
        this.partitions.putAll((Map)Preconditions.checkNotNull(partitions));
        this.keyHasher = (Hasher)Preconditions.checkNotNull(keyHasher);
    }

    public String name() {
        return this.name;
    }

    public CompletableFuture<Integer> size() {
        AtomicInteger totalSize = new AtomicInteger(0);
        return CompletableFuture.allOf((CompletableFuture[])this.getMaps().stream().map(map -> map.size().thenAccept(totalSize::addAndGet)).toArray(CompletableFuture[]::new)).thenApply(v -> totalSize.get());
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.size().thenApply(size -> size == 0);
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        return this.getMap(key).containsKey(key);
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        AtomicBoolean contains = new AtomicBoolean(false);
        return CompletableFuture.allOf((CompletableFuture[])this.getMaps().stream().map(map -> map.containsValue(value).thenAccept(v -> contains.set(contains.get() || v != false))).toArray(CompletableFuture[]::new)).thenApply(v -> contains.get());
    }

    public CompletableFuture<Versioned<V>> get(K key) {
        return this.getMap(key).get(key);
    }

    public CompletableFuture<Versioned<V>> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.getMap(key).computeIf(key, condition, remappingFunction);
    }

    public CompletableFuture<Versioned<V>> put(K key, V value) {
        return this.getMap(key).put(key, value);
    }

    public CompletableFuture<Versioned<V>> putAndGet(K key, V value) {
        return this.getMap(key).putAndGet(key, value);
    }

    public CompletableFuture<Versioned<V>> remove(K key) {
        return this.getMap(key).remove(key);
    }

    public CompletableFuture<Void> clear() {
        return CompletableFuture.allOf((CompletableFuture[])this.getMaps().stream().map(map -> map.clear()).toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<Set<K>> keySet() {
        Set allKeys = Sets.newConcurrentHashSet();
        return CompletableFuture.allOf((CompletableFuture[])this.getMaps().stream().map(map -> map.keySet().thenAccept(allKeys::addAll)).toArray(CompletableFuture[]::new)).thenApply(v -> allKeys);
    }

    public CompletableFuture<Collection<Versioned<V>>> values() {
        CopyOnWriteArrayList allValues = Lists.newCopyOnWriteArrayList();
        return CompletableFuture.allOf((CompletableFuture[])this.getMaps().stream().map(map -> map.values().thenAccept(allValues::addAll)).toArray(CompletableFuture[]::new)).thenApply(v -> allValues);
    }

    public CompletableFuture<Set<Map.Entry<K, Versioned<V>>>> entrySet() {
        Set allEntries = Sets.newConcurrentHashSet();
        return CompletableFuture.allOf((CompletableFuture[])this.getMaps().stream().map(map -> map.entrySet().thenAccept(allEntries::addAll)).toArray(CompletableFuture[]::new)).thenApply(v -> allEntries);
    }

    public CompletableFuture<Versioned<V>> putIfAbsent(K key, V value) {
        return this.getMap(key).putIfAbsent(key, value);
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.getMap(key).remove(key, value);
    }

    public CompletableFuture<Boolean> remove(K key, long version) {
        return this.getMap(key).remove(key, version);
    }

    public CompletableFuture<Versioned<V>> replace(K key, V value) {
        return this.getMap(key).replace(key, value);
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return this.getMap(key).replace(key, oldValue, newValue);
    }

    public CompletableFuture<Boolean> replace(K key, long oldVersion, V newValue) {
        return this.getMap(key).replace(key, oldVersion, newValue);
    }

    public CompletableFuture<Void> addListener(MapEventListener<K, V> listener, Executor executor) {
        return CompletableFuture.allOf((CompletableFuture[])this.getMaps().stream().map(map -> map.addListener(listener, executor)).toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<Void> removeListener(MapEventListener<K, V> listener) {
        return CompletableFuture.allOf((CompletableFuture[])this.getMaps().stream().map(map -> map.removeListener(listener)).toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<Boolean> prepare(MapTransaction<K, V> transaction) {
        IdentityHashMap updatesGroupedByMap = Maps.newIdentityHashMap();
        transaction.updates().forEach(update -> {
            AsyncConsistentMap<Object, V> map = this.getMap(update.key());
            updatesGroupedByMap.computeIfAbsent(map, k -> Lists.newLinkedList()).add(update);
        });
        Map transactionsByMap = Maps.transformValues((Map)updatesGroupedByMap, list -> new MapTransaction(transaction.transactionId(), list));
        return Tools.allOf(transactionsByMap.entrySet().stream().map(e -> ((AsyncConsistentMap)e.getKey()).prepare((MapTransaction)e.getValue())).collect(Collectors.toList())).thenApply(list -> list.stream().reduce(Boolean::logicalAnd).orElse(true));
    }

    public CompletableFuture<Void> commit(TransactionId transactionId) {
        return CompletableFuture.allOf((CompletableFuture[])this.getMaps().stream().map(e -> e.commit(transactionId)).toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        return CompletableFuture.allOf((CompletableFuture[])this.getMaps().stream().map(e -> e.rollback(transactionId)).toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<Boolean> prepareAndCommit(MapTransaction<K, V> transaction) {
        IdentityHashMap updatesGroupedByMap = Maps.newIdentityHashMap();
        transaction.updates().forEach(update -> {
            AsyncConsistentMap<Object, V> map = this.getMap(update.key());
            updatesGroupedByMap.computeIfAbsent(map, k -> Lists.newLinkedList()).add(update);
        });
        Map transactionsByMap = Maps.transformValues((Map)updatesGroupedByMap, list -> new MapTransaction(transaction.transactionId(), list));
        return Tools.allOf(transactionsByMap.entrySet().stream().map(e -> ((AsyncConsistentMap)e.getKey()).prepareAndCommit((MapTransaction)e.getValue())).collect(Collectors.toList())).thenApply(list -> list.stream().reduce(Boolean::logicalAnd).orElse(true));
    }

    public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.partitions.values().forEach(map -> map.addStatusChangeListener(listener));
    }

    public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.partitions.values().forEach(map -> map.removeStatusChangeListener(listener));
    }

    public Collection<Consumer<DistributedPrimitive.Status>> statusChangeListeners() {
        throw new UnsupportedOperationException();
    }

    private AsyncConsistentMap<K, V> getMap(K key) {
        return this.partitions.get(this.keyHasher.hash(key));
    }

    private Collection<AsyncConsistentMap<K, V>> getMaps() {
        return this.partitions.values();
    }
}

