/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import io.atomix.AtomixClient;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.transport.Transport;
import io.atomix.copycat.client.ConnectionStrategies;
import io.atomix.copycat.client.ConnectionStrategy;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.copycat.client.RecoveryStrategies;
import io.atomix.copycat.client.RecoveryStrategy;
import io.atomix.copycat.client.ServerSelectionStrategies;
import io.atomix.copycat.client.ServerSelectionStrategy;
import io.atomix.manager.ResourceClient;
import io.atomix.manager.ResourceManagerException;
import io.atomix.manager.util.ResourceManagerTypeResolver;
import io.atomix.resource.ResourceFactory;
import io.atomix.resource.ResourceRegistry;
import io.atomix.resource.ResourceType;
import io.atomix.variables.DistributedLong;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.onlab.util.HexString;
import org.onlab.util.KryoNamespace;
import org.onosproject.store.primitives.DistributedPrimitiveCreator;
import org.onosproject.store.primitives.impl.DefaultAsyncAtomicValue;
import org.onosproject.store.primitives.impl.DelegatingAsyncConsistentMap;
import org.onosproject.store.primitives.impl.DistributedPrimitives;
import org.onosproject.store.primitives.impl.Managed;
import org.onosproject.store.primitives.impl.OnosCopycatClient;
import org.onosproject.store.primitives.impl.StoragePartition;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentMap;
import org.onosproject.store.primitives.resources.impl.AtomixCounter;
import org.onosproject.store.primitives.resources.impl.AtomixLeaderElector;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncAtomicCounter;
import org.onosproject.store.service.AsyncAtomicValue;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.AsyncLeaderElector;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.DistributedQueue;
import org.onosproject.store.service.PartitionClientInfo;
import org.onosproject.store.service.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoragePartitionClient
implements DistributedPrimitiveCreator,
Managed<StoragePartitionClient> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final StoragePartition partition;
    private final Transport transport;
    private final io.atomix.catalyst.serializer.Serializer serializer;
    private AtomixClient client;
    private ResourceClient resourceClient;
    private static final String ATOMIC_VALUES_CONSISTENT_MAP_NAME = "onos-atomic-values";
    private final Supplier<AsyncConsistentMap<String, byte[]>> onosAtomicValuesMap = Suppliers.memoize(() -> this.newAsyncConsistentMap(ATOMIC_VALUES_CONSISTENT_MAP_NAME, Serializer.using((KryoNamespace)KryoNamespaces.BASIC)));
    Function<CopycatClient.State, DistributedPrimitive.Status> mapper = state -> {
        switch (state) {
            case CONNECTED: {
                return DistributedPrimitive.Status.ACTIVE;
            }
            case SUSPENDED: {
                return DistributedPrimitive.Status.SUSPENDED;
            }
            case CLOSED: {
                return DistributedPrimitive.Status.INACTIVE;
            }
        }
        throw new IllegalStateException("Unknown state " + state);
    };

    public StoragePartitionClient(StoragePartition partition, io.atomix.catalyst.serializer.Serializer serializer, Transport transport) {
        this.partition = partition;
        this.serializer = serializer;
        this.transport = transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> open() {
        StoragePartitionClient storagePartitionClient = this;
        synchronized (storagePartitionClient) {
            this.resourceClient = this.newResourceClient(this.transport, this.serializer.clone(), StoragePartition.RESOURCE_TYPES);
            this.resourceClient.client().onStateChange(state -> this.log.debug("Partition {} client state changed to {}", (Object)this.partition.getId(), state));
            this.client = new AtomixClient(this.resourceClient);
        }
        return ((CompletableFuture)this.client.connect(this.partition.getMemberAddresses()).whenComplete((r, e) -> {
            if (e == null) {
                this.log.info("Successfully started client for partition {}", (Object)this.partition.getId());
            } else {
                this.log.info("Failed to start client for partition {}", (Object)this.partition.getId(), e);
            }
        })).thenApply(v -> null);
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.client != null ? this.client.close() : CompletableFuture.completedFuture(null);
    }

    public <K, V> AsyncConsistentMap<K, V> newAsyncConsistentMap(final String name, Serializer serializer) {
        AtomixConsistentMap atomixConsistentMap = (AtomixConsistentMap)((Object)this.client.getResource(name, AtomixConsistentMap.class).join());
        Consumer<CopycatClient.State> statusListener = state -> atomixConsistentMap.statusChangeListeners().forEach(listener -> listener.accept(this.mapper.apply((CopycatClient.State)state)));
        this.resourceClient.client().onStateChange(statusListener);
        DelegatingAsyncConsistentMap<String, byte[]> rawMap = new DelegatingAsyncConsistentMap<String, byte[]>((AsyncConsistentMap)atomixConsistentMap){

            @Override
            public String name() {
                return name;
            }
        };
        AsyncConsistentMap<Object, Object> transcodedMap = DistributedPrimitives.newTranscodingMap(rawMap, key -> HexString.toHexString((byte[])serializer.encode(key)), string -> serializer.decode(HexString.fromHexString((String)string)), value -> value == null ? null : serializer.encode(value), bytes -> serializer.decode(bytes));
        return transcodedMap;
    }

    public <E> AsyncDistributedSet<E> newAsyncDistributedSet(String name, Serializer serializer) {
        return DistributedPrimitives.newSetFromMap(this.newAsyncConsistentMap(name, serializer));
    }

    public AsyncAtomicCounter newAsyncCounter(String name) {
        DistributedLong distributedLong = (DistributedLong)this.client.getLong(name).join();
        return new AtomixCounter(name, distributedLong);
    }

    public <V> AsyncAtomicValue<V> newAsyncAtomicValue(String name, Serializer serializer) {
        return new DefaultAsyncAtomicValue(name, serializer, (AsyncConsistentMap<String, byte[]>)((AsyncConsistentMap)this.onosAtomicValuesMap.get()));
    }

    public <E> DistributedQueue<E> newDistributedQueue(String name, Serializer serializer) {
        throw new UnsupportedOperationException();
    }

    public AsyncLeaderElector newAsyncLeaderElector(String name) {
        AtomixLeaderElector leaderElector = (AtomixLeaderElector)((Object)((CompletableFuture)this.client.getResource(name, AtomixLeaderElector.class).thenCompose(AtomixLeaderElector::setupCache)).join());
        Consumer<CopycatClient.State> statusListener = state -> leaderElector.statusChangeListeners().forEach(listener -> listener.accept(this.mapper.apply((CopycatClient.State)state)));
        this.resourceClient.client().onStateChange(statusListener);
        return leaderElector;
    }

    public Set<String> getAsyncConsistentMapNames() {
        return (Set)this.client.keys(AtomixConsistentMap.class).join();
    }

    public Set<String> getAsyncAtomicCounterNames() {
        return (Set)this.client.keys(DistributedLong.class).join();
    }

    @Override
    public boolean isOpen() {
        return this.resourceClient.client().state() != CopycatClient.State.CLOSED;
    }

    public PartitionClientInfo clientInfo() {
        return new PartitionClientInfo(this.partition.getId(), this.partition.getMembers(), this.resourceClient.client().session().id(), this.mapper.apply(this.resourceClient.client().state()));
    }

    private ResourceClient newResourceClient(Transport transport, io.atomix.catalyst.serializer.Serializer serializer, Collection<ResourceType> resourceTypes) {
        ResourceRegistry registry = new ResourceRegistry();
        resourceTypes.forEach(arg_0 -> ((ResourceRegistry)registry).register(arg_0));
        CopycatClient copycatClient = CopycatClient.builder().withServerSelectionStrategy((ServerSelectionStrategy)ServerSelectionStrategies.ANY).withConnectionStrategy((ConnectionStrategy)ConnectionStrategies.FIBONACCI_BACKOFF).withRecoveryStrategy((RecoveryStrategy)RecoveryStrategies.RECOVER).withTransport(transport).withSerializer(serializer).build();
        copycatClient.serializer().resolve(new SerializableTypeResolver[]{new ResourceManagerTypeResolver()});
        for (ResourceType type : registry.types()) {
            try {
                ((ResourceFactory)type.factory().newInstance()).createSerializableTypeResolver().resolve(copycatClient.serializer().registry());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ResourceManagerException((Throwable)e);
            }
        }
        return new ResourceClient((CopycatClient)new OnosCopycatClient(copycatClient, 5, 100L));
    }
}

